<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6140"
	title	= "テーブル結合(フィルター)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "CLM,NAME_JA,SYSTEM_ID"
	nullCheck = "SYSTEM_ID"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" dbid="{@FROM_DBID}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select '1' as WRITABLE,A.CLM,A.NAME_JA,B.LNAME,B.SNAME,A.CLS_NAME,A.USE_LENGTH,A.VIEW_LENGTH,
		A.RENDERER,A.EDITOR,A.DBTYPE,A.LABEL_CLM,A.CODE_CLM,A.ROLES,
		A.DATA_DEFAULT,A.COMMENTS,A.RENDERER_PARAM,A.EDITOR_PARAM,A.TYPE_PARAM,A.SYSTEM_ID,A.KBSAKU,
		B.DESCRIPTION,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,COALESCE(B.LANG,'ja') LANG,A.UNIQ,B.UNIQ UNIQ_GEA08,
		'' ABC
		from GEA03 A left outer join GEA08 B
		on	A.SYSTEM_ID = B.SYSTEM_ID
		and	A.CLM		= B.CLM
		and B.LANG		= '{@LANG}'
		and B.FGJ		= '1'
		where A.SYSTEM_ID in ( '{@SYSTEM_ID}','{@AST}' )
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "A.FGJ          =    '{@FGJ}'"          />
		<og:and value = "UPPER(A.CLM)   like UPPER('{@CLM}%')"  />
		<og:and value = "A.NAME_JA      like '{@NAME_JA}%'"     />
		<og:and value = "A.CLS_NAME     like '{@CLS_NAME}%'"    />
		<og:and value = "A.RENDERER     like '{@RENDERER}%'"    />
		<og:and value = "A.EDITOR       like '{@EDITOR}%'"      />
		<og:and value = "A.DBTYPE       like '{@DBTYPE}%'"      />
		<og:and value = "A.LABEL_CLM    like '{@LABEL_CLM}%'"   />
		<og:and value = "A.CODE_CLM     like '{@CODE_CLM}%'"    />
		<og:and value = "A.USE_LENGTH   =    '{@USE_LENGTH}'"   />
		<og:and value = "A.VIEW_LENGTH  =    '{@VIEW_LENGTH}%'" />
		<og:and value = "A.KBSAKU       =    '{@KBSAKU}'"       />
		<og:and value = "A.ROLES        like '{@ROLES}%'"       />
		<og:and value = "A.COMMENTS     like '{@COMMENTS}%'"    />
		<og:and value = "A.RDC_CODE     = '{@RDC_CODE}'"   />
		<og:and value = "A.DYUPD    &gt;= '{@DYUPDFROM}'"  />
		<og:and value = "A.DYUPD    &lt;= '{@DYUPDTO}99'"  />
		<og:and value = "A.RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
		<og:and value = "A.USRUPD       =    '{@USRUPD}'"  />
		<og:and value = "A.CDKH {@CDKH}" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.CLM" />
</og:query>

<og:tableFilter
	classId     = "DBSELECT"
	keys        = "CLM"
	vals        = "ABC"
	selectedAll = "true"
>
	select NAME_JA FROM GEA08 WHERE CLM=[CLM] AND FGJ='1'
</og:tableFilter>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CLM],1,[LANG]" />
	<og:link column="RENDERER" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		onLink="[RENDERER]" markList="MENU"
		keys="command,SYSTEM_ID,CLM,FGJ,LANG"
		vals="NEW,[SYSTEM_ID],[CLM],1,[LANG]" />
</og:viewLink>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}">
		<jsp:text>{@USER.LASTSQL}</jsp:text>
	</og:query>
	<og:tableMerge
		action        = "{@ACTION}"
		masterScope   = "session"
		masterKeys    = "SYSTEM_ID,CLM"
		diffKeys      = "NAME_JA,CLS_NAME,USE_LENGTH,VIEW_LENGTH,RENDERER,EDITOR,DBTYPE,LABEL_CLM,CODE_CLM,ROLES,DATA_DEFAULT,COMMENTS,RENDERER_PARAM,EDITOR_PARAM,TYPE_PARAM,KBSAKU"
		slaveScope    = "request"
		modifyClms    = "UNIQ"
		display       = "true"
	/>
</og:equals>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "UNIQ,UNIQ_GEA08"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
