/**************************************************************************/
/* GE32 ( 送信履歴テーブル )                                              */
/*                                                                        */
/* Created : 2010/11/08 13:14:03                                          */
/**************************************************************************/
CREATE TABLE GE32 (
   YKNO      NUMBER(9)         DEFAULT 0   NOT NULL      /* 10  要求ＮＯ       */
 , PARA_KEY  VARCHAR2(9)                                 /* 20  パラメータキー */
 , PTN_ID    VARCHAR2(20)                                /* 30  定型文ID       */
 , SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 40  システムID     */
 , FROM_ADDR VARCHAR2(100)                 NOT NULL      /* 50  送信元         */
 , TITLE     VARCHAR2(300)                               /* 60  タイトル       */
 , CONTENTS  VARCHAR2(4000)                              /* 70  内容           */
 , ATTACH1   VARCHAR2(256)                               /* 80  添付１         */
 , ATTACH2   VARCHAR2(256)                               /* 90  添付２         */
 , ATTACH3   VARCHAR2(256)                               /* 100 添付３         */
 , ATTACH4   VARCHAR2(256)                               /* 110 添付４         */
 , ATTACH5   VARCHAR2(256)                               /* 120 添付５         */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 130 ユニークキー   */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 140 状態フラグ     */
 , DYSET     VARCHAR2(14)                                /* 150 登録日時       */
 , PGSET     VARCHAR2(10)                                /* 160 作成PG         */
 , PGPSET    VARCHAR2(10)                                /* 170 作成親PG       */
 , USRSET    VARCHAR2(10)                                /* 180 作成社員       */
 , DYUPD     VARCHAR2(14)                                /* 190 更新日時       */
 , PGUPD     VARCHAR2(10)                                /* 200 更新PG         */
 , PGPUPD    VARCHAR2(10)                                /* 210 更新親PG       */
 , USRUPD    VARCHAR2(10)                                /* 220 更新者         */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE32S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE32T00 
BEFORE INSERT ON GE32
FOR EACH ROW 
BEGIN 
SELECT GE32S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

