<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="mis-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:query | //og:update | //og:plsqlUpdate" />
    <xsl:apply-templates select="//og:value[@command='SQL'] | //og:userInfo[@command='SQL']" />
  </xsl:template>

  <xsl:template match="og:query | og:update | og:plsqlUpdate">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID   ><xsl:value-of select="@tableId"   /></TABLEID>
       <DBID      ><xsl:value-of select="@dbid"      /></DBID>
       <SQL_TYPE  ><xsl:value-of select="@queryType" /></SQL_TYPE>
       <JSP_SCOPE ><xsl:value-of select="@scope"     /></JSP_SCOPE>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

  <xsl:template match="og:value[@command='SQL'] | og:userInfo[@command='SQL']">
     <ROW>
       <xsl:copy-of select="$row_header" />
       <TAGNAME   ><xsl:value-of select="name()"     /></TAGNAME>
       <CLMS      ><xsl:value-of select="@names"     /></CLMS>
       <TABLEID  />
       <DBID     />
       <SQL_TYPE />
       <JSP_SCOPE/>
       <SQL_TEXT  ><xsl:copy-of select="node()"      /></SQL_TEXT>
     </ROW>
  </xsl:template>

</xsl:stylesheet>
