<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX011"
	title	= "帳票処理結果更新(BPEL)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<table>
<tr>
<og:column name="SYSTEM_ID" value="{@SystemId}" writable="false" />
<og:column name="YKNO" value="{@DemandNo}" writable="false" />
<og:column name="KEKKA" value="{@Result}" writable="false" />
<og:column name="MESSAGE" value="{@Message}" writable="false" />
</tr>
</table>

<!-- GE50にデータが存在しない場合はエラー -->
<og:value command="SQL">
	<jsp:text>
		SELECT COUNT(*) CNT
		FROM GE50
		WHERE FGJ = '1'
		AND SYSTEM_ID = '{@SystemId}'
		AND YKNO = '{@DemandNo}'
	</jsp:text>
</og:value>
<og:equals val1="{@CNT}" val2="0">
	<og:error logMsgType="LONG" viewMsgType="LONG" skipPage="true">{@LBL.GFM0041 @SystemId @DemandNo @Result}</og:error>
</og:equals>

<!-- GE50更新 -->
<og:query command="NEW" scope="request">
	<jsp:text>
		UPDATE GE50
			SET FGKAN = DECODE('{@Result}','OK','2','8')
				,DYUPD = TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS')
			--	,DMN_NAME = DMN_NAME
				,DMN_HOST = '{@SYS.SERVER_NAME}'
			WHERE FGJ = '1'
			AND SYSTEM_ID = '{@SystemId}'
			AND YKNO = '{@DemandNo}'
	</jsp:text>
</og:query>

<!-- 結果がOKの場合以外はGE56に登録 -->
<og:equals val1="{@Result}" val2="OK" notEquals="true">
	<og:query command="NEW" scope="request">
		<jsp:text>
			INSERT INTO GE56 ( FGJ,SYSTEM_ID,YKNO,ERRMSG
				,DYSET,DYUPD,USRSET,USRUPD,PGUPD )
			VALUES ( '1','{@SystemId}','{@DemandNo}','{@Message}'
				,TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS'),TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS'),'{@USER.ID}','{@USER.ID}','REP15' )
		</jsp:text>
	</og:query>
</og:equals>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
