/**************************************************************************/
/* GE15 ( アクセス調査テーブル )                                          */
/*                                                                        */
/* Created : 2011/11/01 14:24:50                                          */
/**************************************************************************/
CREATE TABLE GE15 (
   SYSTEM_ID      VARCHAR(10)                  NOT NULL      /* 10  システムID               */
 , USERID         VARCHAR(10)                  NOT NULL      /* 20  ユーザーID               */
 , GUIKEY         VARCHAR(30)                                /* 30  画面ID                   */
 , DYLOGIN        VARCHAR(14)                                /* 40  ログイン時間             */
 , DYLOGOUT       VARCHAR(14)                                /* 50  ログアウト時間           */
 , USED_TIME      INTEGER          DEFAULT 0   NOT NULL      /* 60  使用時間(秒)             */
 , CNT_ACCESS     INTEGER          DEFAULT 0   NOT NULL      /* 70  アクセス件数             */
 , CNT_ERROR      INTEGER          DEFAULT 0   NOT NULL      /* 80  エラー件数               */
 , CNT_READ       INTEGER          DEFAULT 0   NOT NULL      /* 90  読込件数                 */
 , CNT_WRITE      INTEGER          DEFAULT 0   NOT NULL      /* 100 出力件数                 */
 , TM_TOTAL_QUERY BIGINT           DEFAULT 0   NOT NULL      /* 110 トータルDBクエリ時間(ms) */
 , TM_MAX_QUERY   INTEGER          DEFAULT 0   NOT NULL      /* 120 最大DBクエリ時間(ms)     */
 , MAX_QUERY      VARCHAR(4000)                              /* 200 最長実行クエリ           */
 , USERADRS       VARCHAR(40)                                /* 210 IPアドレス(local)        */
 , HOSTADRS       VARCHAR(40)                                /* 220 IPアドレス(remote)       */
 , UNIQ           IDENTITY                                   /* 800 ユニークキー             */
 , FGJ            VARCHAR(1)       DEFAULT '1' NOT NULL      /* 810 状態フラグ               */
 , DYSET          VARCHAR(14)                                /* 820 登録日時                 */
 , PGSET          VARCHAR(10)                                /* 830 作成PG                   */
 , PGPSET         VARCHAR(10)                                /* 840 作成親PG                 */
 , USRSET         VARCHAR(10)                                /* 850 作成社員                 */
 , DYUPD          VARCHAR(14)                                /* 860 更新日時                 */
 , PGUPD          VARCHAR(10)                                /* 870 更新PG                   */
 , PGPUPD         VARCHAR(10)                                /* 880 更新親PG                 */
 , USRUPD         VARCHAR(10)                                /* 890 更新者                   */
);


