/**************************************************************************/
/* GF76 ( ファイル検索テーブル )                                          */
/*                                                                        */
/* Created : 2011/11/01 14:24:48                                          */
/**************************************************************************/
CREATE TABLE GF76 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , ADDRESS    VARCHAR2(256)                              /* 20  アドレス     */
 , PRE_FIX    VARCHAR2(10)                 NOT NULL      /* 30  名前空間     */
 , FILENAME   VARCHAR2(60)                               /* 40  ファイル名   */
 , FILEPATH   VARCHAR2(256)                              /* 50  ファイルパス */
 , MODIFIED   VARCHAR2(14)                               /* 60  最終更新日   */
 , TAGNAME    VARCHAR2(30)                               /* 70  タグ名称     */
 , TITLE      VARCHAR2(300)                              /* 80  タイトル     */
 , VERNO      VARCHAR2(10)                               /* 90  バージョン   */
 , MODIFYDATE VARCHAR2(30)                               /* 100 更新日       */
 , AUTHOR     VARCHAR2(100)                              /* 110 更新者       */
 , TEXTBODY   CLOB                                       /* 120 コメント文   */
 , FGOMIT     VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 130 除外フラグ   */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 140 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 150 状態フラグ   */
 , DYSET      VARCHAR2(14)                               /* 160 登録日時     */
 , PGSET      VARCHAR2(10)                               /* 170 作成PG       */
 , PGPSET     VARCHAR2(10)                               /* 180 作成親PG     */
 , USRSET     VARCHAR2(10)                               /* 190 作成社員     */
 , DYUPD      VARCHAR2(14)                               /* 200 更新日時     */
 , PGUPD      VARCHAR2(10)                               /* 210 更新PG       */
 , PGPUPD     VARCHAR2(10)                               /* 220 更新親PG     */
 , USRUPD     VARCHAR2(10)                               /* 230 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 512K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GF76S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF76T00 
BEFORE INSERT ON GF76
FOR EACH ROW 
BEGIN 
SELECT GF76S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

