/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.transfer;


/**
 * 伝送の定義情報を管理するためのデータクラスです。
 *
 * @og.group 伝送システム
 *
 * @version  5.0
 * @author   Hiroki.Nakamura
 * @since    JDK1.6
 */
public class TransferConfig {

	private final String	readObj;	// 読取対象
	private final String	readPrm;	// 読取パラーメーター
	private final String	kbExec;		// 実行方法
	private final String	execDbid;	// 実行DB接続先ID
	private final String	execObj;	// 実行対象
	private final String	execPrm;	// 実行パラメーター

	/**
	 * コンストラクタです。
	 * 
	 * @param readObj 読取対象
	 * @param readPrm 読取パラーメーター
	 * @param kbExec 実行方法
	 * @param execDbid 実行DB接続先ID
	 * @param execObj 実行対象
	 * @param execPrm 実行パラメーター
	 */
	public TransferConfig(
			final String readObj, final String readPrm, final String kbExec
			,final String execDbid, final String execObj, final String execPrm ) {
				this.readObj	= readObj;
				this.readPrm	= readPrm;
				this.kbExec		= kbExec;
				this.execDbid	= execDbid;
				this.execObj	= execObj;
				this.execPrm	= execPrm;
	}

	/**
	 * 読取対象を返します。
	 * 
	 * @return 読取対象
	 */
	public String getReadObj() {
		return readObj;
	}

	/**
	 * 読取パラーメーターを返します。
	 * 
	 * @return 読取パラーメーター
	 */
	public String getReadPrm() {
		return readPrm;
	}

	/**
	 * 実行方法を返します。
	 * 
	 * @return 実行方法
	 */
	public String getKbExec() {
		return kbExec;
	}

	/**
	 * 実行DB接続先IDを返します。
	 * 
	 * @return 実行DB接続先ID
	 */
	public String getExecDbid() {
		return execDbid;
	}

	/**
	 * 実行対象を返します。
	 * 
	 * @return 実行対象
	 */
	public String getExecObj() {
		return execObj;
	}

	/**
	 * 実行パラメーターを返します。
	 * 
	 * @return 実行パラメーター
	 */
	public String getExecPrm() {
		return execPrm;
	}

	/**
	 * このクラスの文字列表現を返します
	 * 
	 * @return 文字列表現
	 */
	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append( "readObj=" ).append( readObj )
			.append( ",readPrm=" ).append( readPrm )
			.append( ",kbExec=" ).append( kbExec )
			.append( ",execDbid=" ).append( execDbid )
			.append( ",execObj=" ).append( execObj )
			.append( ",execPrm=" ).append( execPrm );
		return buf.toString();
	}
}
