/************************************************************************************/
/* 旧 focusHilight.js の内容を移植 5.2.1.0 (2010/10/01)                             */
/*                                                                                  */
/* フォーカスが当っているアクティブフィールドの色を変更します                       */
/* 色はfocusFieldクラスで指定しています                                             */
/*                                                                                  */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用                */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* Revision: $Id$                                                                   */
/************************************************************************************/

var orgFldCls = null;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusin( function(){ doFocus2( this ); } );
//	$('textarea,select,input[type="text"]').focusout( function(){ doBlur2( this ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusin", function(){ doFocus2( this ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ doBlur2( this ); } );
});

function doFocus2( obj ) {
	// 入力中のフォームの色
	if( obj != null  ) { 
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 4.3.2.2 (2008/09/16) 入力中のフォームの色をcustom.cssに指定するように変更
			orgFldCls    = obj.className;
			obj.className = 'focusField ' + orgFldCls;
		}
	}
}

function doBlur2( obj ) {
	if( obj != null ) {
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 元のフォームの色
			if( orgFldCls != null ) {
				obj.className = orgFldCls;
			}
			else {
				obj.className = 'notFocusField';
			}
		}
	}
}

/* 旧関数を呼び出した場合はアラートを出す（旧の*_inof.jsp対策） */
oldDoFocusFlag = true;
function doFocus( obj ) {
	if(oldDoFocusFlag){
		oldDoFocusFlag = false;
//		setTimeout(alert("custom/query_info.jsp及びcustom/result_info.jspで次の部分を削除して下さい。\n<script>タグ（ヘッダ固定とフォーカス）、BODYのonLoadとoncontextmenu属性"),100);
		setTimeout(alert("Old Script Error!!\ncustom/query_info.jsp,custom/result_info.jsp Please delete the following part.\n<script>Tag(Header fix and Focus) , BODY onLoad and oncontextmenu Attribute"),100);
	}
}
/*エラー対策の空関数 */
function doBlur( obj ) {}

/************************************************************************************/
/* 旧 autoConvert.js の内容を移植 5.2.1.0 (2010/10/01)                              */
/*                                                                                  */
/* 入力値自動変換機能 4.3.0.0 (2008/07/25) 追加                                     */
/* dbType XL及びXUについて、大文字・小文字の自動変換を行います                      */
/*                                                                                  */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)                      */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* Revision: $Id$                                                                   */
/************************************************************************************/
$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ convert( this ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ convert( this ); } );
});

function convert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( cls.match( /XL/ ) && !(cls.match( /XLU/ )) ) {
			obj.value = val.toLowerCase();
		}
		else if( cls.match( /XU/ ) && !(cls.match( /XUL/ )) ) {
			obj.value = val.toUpperCase();
		}
	}
	return true;
}

/************************************************************************************/
/* 旧 eventColumn.js の内容を移植 5.2.1.0 (2010/10/01)                              */
/*                                                                                  */
/* 動的プルダウンを実行するためのJavaScriptです。                                   */
/*                                                                                  */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* Revision: $Id$                                                                   */
/************************************************************************************/
var colMap;
var notFireCols;
var jH_evElm;

$(function(){
	if( ! ( typeof( EC_NAME ) == "undefined" ) ) {
		// 初期化処理だけは、予め要素オブジェクトを取得しておき、ここから子カラムを取得する。
		jH_evElm = $( ".h_evElm" );

		makeColMapping();

		setEvent( "textarea,select,input[type=\"text\"]", "change", function(){ makeColumn( this ); }, ".h_evCol", true, addEvColCls );
		setEvent( "input[type=checkbox],input[type=radio]", "click", function(){ makeColumn( this ); }, ".h_evCol", true );
	}
});

/**
 * 親カラムをキーにしたイベントカラムの一覧を作成します。
 *
 * 親カラムを連想配列のキーとして、子カラムの一覧を配列として保持します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
**/
function makeColMapping() {
	var i , j , evCols , evc , cCols ;

	if( colMap ){ return; }

	colMap = new Object();
	for(  i=0; i<EC_EVCOL.length; i++ ) {
		evCols = EC_EVCOL[i].split(",");
		for( j=0; j<evCols.length; j++ ) {
			evc = evCols[j];
			if( evc.charAt(0) == "_" ) {
				evc = evc.substring(1);
				if( notFireCols ) { notFireCols += ","; }
				notFireCols += evc;
			}
			cCols = colMap[evc];
			if( !cCols ) { cCols = new Array(); }
			cCols[cCols.length] = EC_NAME[i];
			colMap[evc] = cCols;
		}
	}
}

/**
 * 親カラムに対してクラスを付加します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
**/
function addEvColCls() {
	for( var evCol in colMap ) {
		$("#"+evCol+",[id^="+evCol+"__]").addClass("h_evCol");
	}
}

/**
 * イベントカラムが設定されたタグ(spanタグ)を検索し、親カラムにイベントを登録します。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 新規作成(動的プルダウン実装見直し)
 *
 * @param evCol	イベントが発生した親カラムのオブジェクト
**/
function makeColumn( evCol ) {
	var jEvCol , evColId , evColName , cColNameArr , i , suffix , cid , cname , jTag , writable ;

	if( jH_evElm && isEndInitEvent() ) { jH_evElm = null; }

	jEvCol = $( evCol );
	evColId = jEvCol.attr("id");
	evColName = evColId.split("__")[0];

	cColNameArr = colMap[evColName];
	if( !cColNameArr ) { return; }

	// イベントカラムでカラム名の頭文字が'_'で始まっている場合、初回イベント発行を行わない。
	if( !isEndInitEvent() && notFireCols && notFireCols.indexOf( evColName ) >= 0 ) { return; }

	for( i=0; i<cColNameArr.length; i++ ) {
		suffix = ( evColId == evColName ? "" : "__" + evColId.split("__")[1] );
		cid = cColNameArr[i]+suffix;
		cname = cid.split("__")[0];
		jTag = isEndInitEvent() ? $( ".h_evElm[h_evCid="+cid+"]" ) : jH_evElm.filter( "[h_evCid="+cid+"]" );
		writable = jTag.attr("h_evWrtbl");
		eventColumn( jEvCol, jTag, cid, cname, suffix, writable );
	}
}

/**
 * Ajax動的カラム変更用の共通JavaScript
 * 
 * カラムにeventColumnをセットした時に親側にID指定でChangeイベントとして登録されます。
 * ※イベント処理用のJSP用に送られるパラメーターに関しては、jsp/common/eventColumnMaker.jspの
 *   コメントを参照して下さい。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
 *
 * @param jEvCol	イベントが発生した親カラムのjQueryオブジェクト
 * @param jTag		置き換え要素をラップしたspanタグのjQueryオブジェクト
 * @param cid		変更対象の子要素(inputタグなど)のID
 * @param cname		子のカラム名
 * @param suffix	__ + 行番号(一覧表示の場合のみ)
 * @param writable	書き込み可能かどうか
**/
function eventColumn( jEvCol, jTag, cid, cname, suffix, writable ){
	var evVal , url , param , _pos1 , _pos2 , _repClm, _rep, _clm , noVal , columnFocus , jCol , val , renderer , editor , ATTRS , optAttrs , i , optAtt , vtype , isAdd ;

	if( !jTag || jTag.length == 0 ) {
//		alert( "[SYSTEM_ERROR] : イベントカラムで置き換え対象の要素が存在しません" );
		alert( "[SYSTEM_ERROR] : jTag is null. The element of the replacement object doesn't exist." );
		return;
	}

//	if( cid == null || cid == "" || cname == null || cname == "" ) {
//		alert( "[SYSTEM_ERROR] : 子要素のIDまたはNAMEがセットされていません" );
//		return;
//	}

	if( !isEndInitEvent() ) {
		evVal = jEvCol.val();
		if( !evVal || evVal == null || evVal == "" ) { return; }
	}

	try {
		url = eval( "EC_" + cname + "_URL" );
	}
	catch( e ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。(変数未定義)" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified. (variable undefinition)" );
		return;
	}
	if( !url || url == "" ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified." );
		return;
	}

	// SQL文をパースして{@xxx}をxxxのvalue値に変更する。一覧での利用では同一行のカラムになる。
	//（リクエスト変数はテキストボックスで一度受ける必要がある）
	// 又、パースして得られたvalue値をJSPのリクエスト変数としてURLの後ろに付ける
	param = "";
	try { param = ( writable ? eval( "EC_" + cname + "_EDITPARAM" ) : eval( "EC_" + cname + "_RENDPARAM" ) ); } catch( e ) {}
	if( param != null && param != "" ) {
		url += "?";
		_pos1 = 0;
		_pos2 = 0;
		while( (_pos1 = param.indexOf("{@",_pos2)) != -1){
			_pos2 = param.indexOf("}",_pos1);
			_clm = param.substring(_pos1+2,_pos2);
			if( _clm.indexOf(".") < 0 ) {
				_repClm = "{@"+_clm+"}";
				_rep = suffix == "" ? $('#'+_clm).val() : $('#'+_clm+suffix).val();
				_rep = ( _rep == null ? "" : _rep );
				param = param.replace(_repClm,_rep);
				url += _clm + "=" +  encodeURIComponent(_rep) +"&";
			}
			_pos2 = _pos1+1; // 4.3.6.2 (2009/04/15)
		}
	}

	// 子がSelectタグの場合、最上部に空のoptionが存在すればEC_NOVALUEをtrueで送る
	noVal = function(){
		_firstOption = jCol.children('option').get(0);
		if( _firstOption == null || _firstOption.value != "" ){ return false; }
		return true;
	};

	// 4.3.6.5 (2009/05/08) must,mustAnyを引数でJSPに送る。
//	var mustOrMustAny = function(){
//		var _haveClasses = jCol.attr("class");
//		if( _haveClasses && _haveClasses.indexOf("must") >= 0 ){
//			if( _haveClasses.indexOf("mustAny") >= 0 )	{ return "mustAny"; }
//			else										{ return "must"; }
//			return "";
//		}
//	}

	columnFocus = function() {
		jCol.attr("isfocus","true");
	};

//	var jCol;
	if( cid != null && cid != "" ) {
		jCol = jTag.find( "#"+cid );
	}
	else {
		jCol = new Array(0);
	}

	if( jCol.length > 0 && isEndInitEvent() ) {
		jCol.bind("focus",columnFocus);
	}

	val = "";
	if( jCol.length > 0 ) {
		if( isEndInitEvent() )	{ val = ( jCol.val() == null ? "" : jCol.val() ); }
		else					{ val = ( jTag.attr( "h_evVal" ) == null ? "" : jTag.attr( "h_evVal" ) ); }
	}

	renderer = "";
	try { renderer = eval( "EC_" + cname + "_RENDERER" ); } catch( e ) {}

	editor = "";
	try { editor = eval( "EC_" + cname + "_EDITOR" ); } catch( e ) {}

	// 5.2.0.0 (2010/09/01) 属性値が正しく引き継がれないバグを修正
	ATTRS = [ "title", "style", "tabindex", "readonly", "disabled"
				, "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp"
				, "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup" ];
	optAttrs = "";
	if( jCol.length > 0 ) {
		for( i=0; i<ATTRS.length; i++ ) {
			optAtt = jCol.attr(ATTRS[i]);
			if( optAtt != null ) {
				vtype = typeof( optAtt );
				isAdd = false;
				if( vtype == "function" ) {
					optAtt = optAtt.toString();
					isAdd = optAtt.length > 0 ? true : false;
					// 関数の場合は、文字列表現として"function anonymous(){...}"という関数定義が返るため、
					// ( FUNCTION )(); 形式で関数を実行するように変更
					optAtt = "(" + optAtt + ")()";
				}
				else if( vtype == "boolean" ) {
					isAdd = optAtt;
				}
				else {
					isAdd = optAtt.length > 0 ? true : false;
				}

				if( isAdd ) {
					optAttrs += ATTRS[i] + "='" + optAtt + "' ";
				}
			}
		}
	}

	// JSPを呼び出して処理する
	$.ajax({
		url: url,
		data: {
			"EC_CID"		: ( cid == null ? "" : cid ),
			"EC_CNAME"		: ( cname == null ? "" : cname ),
			"EC_RENDERER"	:renderer,
			"EC_EDITOR"		: editor,
			"EC_PARAM"		: param,
			"EC_SQL"		: param,
			"EC_WRITABLE"	: ( writable == null ? "" : writable ),
			"EC_CVALUE"		: val,
			"EC_NOVALUE"	: ( jCol.length == 0 ? "" : noVal() ),
//			"EC_MUST"		: ( jCol.length == 0 ? "" : mustOrMustAny() ),
			"EC_CLASS"		: ( jCol.length == 0 ? "" : jCol.attr("class") ),
			"EC_SIZE"		: ( jCol.length == 0 ? "" : jCol.attr("size") ),
			"EC_MAXLENGTH"	: ( jCol.length == 0 ? "" : jCol.attr("maxlength") ),
			"EC_OPTATTRS"	: optAttrs,
			"EC_PNAME"		: jEvCol.attr("id") == null ? "" : jEvCol.attr("id").split("__")[0],
			"EC_PVALUE"		: jEvCol.val() == null ? "" : jEvCol.val()
		},
		type: 'POST',
		dataType: 'html',
		async : isEndInitEvent(),
		error: function(r,s,e){
			alert('EventColumnError:'+r+':'+s+':'+e+':'+cname);
		},
		success: function(data,status){
			var jNewCol = $(data);

			if( jCol.length > 0 ) {
				if( isEndInitEvent() ) {
					jCol.unbind("focus",columnFocus);
				}
				bindOldEvents( jNewCol.get(0), jQuery.data( jCol.clone(true).get(0),"events" ) );
			}

			jTag.empty().append( jNewCol );

			if( jCol.length > 0 ) {
				jTag.find("input,select,textarea").attr( "name", cid ).attr( "id", cid );

				if( isEndInitEvent() ) {
					// 置き換え先の要素にフォーカスが当たっていた場合は、フォーカスを復活
					if( jCol.attr("isfocus") ) {
//						jNewCol.focus();
						jNewCol.get(0).focus();
						// IEの場合、置き換え先の要素がテキストボックスの場合は、もう１度フォーカスする必要がある。
						if( $.browser.msie ) {
							jNewCol.get(0).focus();
						}
					}
				}
				// 初回読み込み時に置き換えられた要素はchangeイベントを発行
				if( !isEndInitEvent() ) {
					jNewCol.change();
				}
			}

			// ヘッダー固定再計算(処理が重いので、見直しの必要あり)
			if( suffix != null && suffix != "" ) {
				// 暫定対応
				if( !isEndInitEvent() ) {
					setTimeout( function() {
						$('table#viewTable').resizeView();
					}, 100);
				}
				else {
					$('table#viewTable').resizeView();
				}
			}
		}
	});
}

function bindOldEvents( newCol, oldEvents ) {
	var type , handler ;
	for ( type in oldEvents ) {
		for ( handler in oldEvents[type] ) {
			jQuery.event.add( newCol, type, oldEvents[type][handler], oldEvents[type][handler].data );
		}
	}
}

/********************************************************************************************/
/* 旧 realTimeCheck.js の内容を移植 5.2.1.0 (2010/10/01)                                    */
/*                                                                                          */
/* 入力欄の簡易チェック(リアルタイム)                                                       */
/* DBTYPE に応じた簡易チェックを行います。あくまで簡易的なチェックです。                    */
/* 大文字小文字などは、JavaScriptで変換できる為、チェックは行いません。                     */
/*                                                                                          */
/* @og.rev 4.3.3.0 (2008/10/01) サーバーサイドのリアルタイムチェック対応                    */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)								*/
/* @og.rev 4.3.6.6 (2009/05/15) bodyに追加し、いつも上に表示                                */
/* @og.rev 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる                */
/* @og.rev 5.2.1.0 (2010/10/01) h_ で始まる内部設定フィールドはチェックしない。             */
/* @og.rev 5.3.7.0 (2011/07/01) 入力項目が上方にある場合は、下にチェックチップを表示する。  */
/* Revision: $Id$                                                                           */
/********************************************************************************************/
var isShowTip = false;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ check( this, '../common/realtimecheck.jsp' ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ check( this, '../common/realtimecheck.jsp' ); } );

	// 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。
	$('table#viewTable').parent().parent().scroll( function () {
		if( isShowTip ) { isShowTip = false; $(".tipErr").remove(); }
	});
});

function check( obj, sUrl ) {
	var sFullFN , val , arrFName , bTMCheck , sParam , ajaxSettings , tipId ;

	sFullFN = obj.name;
//	var cls = obj.className;
//	var msg = null;

	if (typeof jQuery != "undefined" && sFullFN.indexOf( "h_" ) != 0 ) {
		val = obj.value;
		arrFName = sFullFN.split('__');
		bTMCheck = (2 == arrFName.length);
//		var sParam = "command=RTCHECK&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" );
		sParam = "command=RENEW&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" ) // 4.3.4.0 (2008/12/01)
				   + ( bTMCheck ? "&h_rowSel=" + arrFName[1] : "" )
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + val;
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURI( val ); // 4.3.4.0 (2008/12/01)
				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURIComponent( val ); // 5.2.0.0 (2010/09/01)
		ajaxSettings = {   
				dataType : 'html',
				type	 : 'POST',
				url		 : sUrl,
				data	 : sParam
		};

		ajaxSettings.error = function() {};
		ajaxSettings.success = function(data) {
			//Remove old msg
//			var sOutId = getTipId(obj);
//			$("#" + sOutId).remove();
			tipId = $(obj).data( "tipId" );
			$("#" + tipId).remove();

			if( $.trim(data).indexOf("row_error") >= 0 ) {
				showCheckTip( obj, data );
				isShowTip = true;
			}
		};
		$.ajax(ajaxSettings);
	}

	return true;
}

/* Revised From jTip Plug-in of jQuery */
function showCheckTip( oEditOut, content ) {
//	var jEditOut , hEditOffset , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;
	var jEditOut , hEditOffset , iTipOffset , sArrowId , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;

	jEditOut = $(oEditOut);
	hEditOffset = jEditOut.offset();

	// 5.3.7.0 (2011/07/01) 上に表示する場合
	if( hEditOffset.top >= 30 ) {
		sJtDiv = "<div class='tipErr'><div id='tipArrowBottom'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + (-11 - jJtDiv[0].offsetHeight);
	}
	// 5.3.7.0 (2011/07/01) 下に表示する場合
	else {
		sJtDiv = "<div class='tipErr'><div id='tipArrowTop'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + 11 + jJtDiv[0].offsetHeight;
	}

	tipId = (new Date()).getTime();
	$(oEditOut).data( "tipId", tipId );

	jJtDiv.css( { left: clickElementx+"px", top: clickElementy+"px" } )
			.attr( 'id', tipId )
			.click( function() { $(this).remove(); } )
			.show();
}

//function getTipId(oEdit) {
//	return "JT" + $.data(oEdit);
//}

/********************************************************************************************/
/* 旧 bindEvents.js の内容を移植 5.2.1.0 (2010/10/01)                                       */
/*                                                                                          */
/* 各JavaScriptで登録されたイベント(主にカラムに割り当てられたイベント)を                   */
/* 実際のイベントハンドラにバインドします。                                                 */
/*                                                                                          */
/* @og.rev 5.2.0.0 (2010/09/01) 新規作成                                                    */
/* Revision: $Id$                                                                           */
/********************************************************************************************/
$(function(){
	bindEvents();
});
