/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report.RFIDPrintPointService;
import org.opengion.hayabusa.report2.QueueManager_DB;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class RFIDPrintRequest {
    private static final String CR = HybsSystem.CR;
    private final StringBuilder errMsg = new StringBuilder();
    private ResourceManager resource = null;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final String LANG;
    private final String FGRUN;
    private final String PRTID;
    private final String PRGDIR;
    private final String PRGFILE;
    private final String OUTDIR;
    private final boolean DEBUG;
    private String bSQL = null;
    private boolean fgLOCAL = false;
    private String prtName = null;
    private String hostName = null;
    private String portnm = null;
    private String fgkan = "8";
    private final Map<String, String[]> rfidLayout = new HashMap<String, String[]>();
    private static final String GE54_SELECT = "SELECT BSQL,FGLOCAL,SYSTEM_ID FROM GE54 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  LISTID = ?";
    private static final int GE54_BSQL = 0;
    private static final int GE54_FGLOCAL = 1;
    private static final int GE54_SYSTEM_ID = 2;
    private static final String GE55_SELECT = "SELECT PRTNM,HOST_ID,SYSTEM_ID,PORTNM FROM GE55 WHERE FGJ = '1' AND  SYSTEM_ID IN (?,'**') AND  PRTID = ?";
    private static final int GE55_PRTNM = 0;
    private static final int GE55_HOST_ID = 1;
    private static final int GE55_SYSTEM_ID = 2;
    private static final int GE55_PORTNM = 3;
    private static final String CLM = HybsSystem.sysBool("VER4_COMPATIBLE_MODE") ? "COLUMN_NAME" : "CLM";
    private static final String GE58_SELECT = "SELECT KBOUT,DATA1,DATA2,DATA3,DATA4,DATA5,DATA6,DATA7,DATA8 ,DATA9,DATA10,DATA11,DATA12,DATA13,DATA14,DATA15," + CLM + " FROM GE58 WHERE SYSTEM_ID IN (?,'**')" + " AND LISTID = ?";
    public static final int GE58_KBOUT = 0;
    public static final int GE58_DATA1 = 1;
    public static final int GE58_DATA2 = 2;
    public static final int GE58_DATA3 = 3;
    public static final int GE58_DATA4 = 4;
    public static final int GE58_DATA5 = 5;
    public static final int GE58_DATA6 = 6;
    public static final int GE58_DATA7 = 7;
    public static final int GE58_DATA8 = 8;
    public static final int GE58_DATA9 = 9;
    public static final int GE58_DATA10 = 10;
    public static final int GE58_DATA11 = 11;
    public static final int GE58_DATA12 = 12;
    public static final int GE58_DATA13 = 13;
    public static final int GE58_DATA14 = 14;
    public static final int GE58_DATA15 = 15;
    public static final int GE58_CLM_NAME = 16;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    public RFIDPrintRequest(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.LANG = string4;
        this.FGRUN = string5;
        this.PRTID = string6;
        this.PRGDIR = string7;
        this.PRGFILE = string8;
        this.OUTDIR = string9;
        this.DEBUG = bl;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ReportConverter", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean initialDataSet() {
        String string;
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE54_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][2])) continue;
            n = i;
            break;
        }
        this.fgLOCAL = (string = stringArray2[n][1]) != null && "1".equals(string.trim());
        String[] stringArray3 = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray4 = DBUtil.dbExecute((String)GE58_SELECT, (String[])stringArray3, (ApplicationInfo)this.appInfo);
        if (stringArray4 == null || stringArray4.length == 0) {
            this.errMsg.append("Data does not exist in GE58 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("LISTID=[").append(this.LISTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        for (int i = 0; i < stringArray4.length; ++i) {
            this.rfidLayout.put(stringArray4[i][16], stringArray4[i]);
        }
        String[] stringArray5 = new String[]{this.SYSTEM_ID, this.PRTID};
        String[][] stringArray6 = DBUtil.dbExecute((String)GE55_SELECT, (String[])stringArray5, (ApplicationInfo)this.appInfo);
        if (stringArray6 == null || stringArray6.length == 0) {
            this.errMsg.append("Data does not exist in GE55 table.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("PRTID=[").append(this.PRTID).append("]");
            this.errMsg.append(CR);
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.SYSTEM_ID.equalsIgnoreCase(stringArray2[i][2])) continue;
            n2 = i;
            break;
        }
        this.prtName = stringArray6[n2][0];
        this.hostName = stringArray6[n2][1];
        this.portnm = stringArray6[n2][3];
        return true;
    }

    public boolean execute() {
        System.out.print("RRID RequestData Creating ... ");
        this.resource = this.fgLOCAL ? ResourceFactory.newInstance(this.SYSTEM_ID, this.LANG, false) : ResourceFactory.newInstance(this.LANG);
        String[] stringArray = new String[]{this.SYSTEM_ID, this.YKNO};
        QueueManager_DB.DBTableModelCreator dBTableModelCreator = new QueueManager_DB.DBTableModelCreator(this.SYSTEM_ID, this.LISTID, this.YKNO, "B", this.resource);
        DBTableModel dBTableModel = dBTableModelCreator.getTable();
        if (dBTableModel.getRowCount() <= 0) {
            this.errMsg.append("Database Body row count is Zero.").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append(this.bSQL);
            this.errMsg.append(CR);
            return false;
        }
        if (dBTableModel.isOverflow()) {
            this.errMsg.append("Database is Overflow. [");
            this.errMsg.append(dBTableModel.getRowCount());
            this.errMsg.append("]").append(CR).append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("Check SystemParameter Data in DB_MAX_ROW_COUNT Overflow");
            this.errMsg.append(CR);
            return false;
        }
        RFIDPrintPointService rFIDPrintPointService = null;
        try {
            rFIDPrintPointService = (RFIDPrintPointService)StringUtil.newInstance((String)HybsSystem.sys("REPORT_RFID_SERVICE_CLASS"));
            rFIDPrintPointService.setYkno(this.YKNO);
            rFIDPrintPointService.setSystemId(this.SYSTEM_ID);
            rFIDPrintPointService.setFgrun(this.FGRUN);
            rFIDPrintPointService.setHostName(this.hostName);
            rFIDPrintPointService.setPrinterName(this.prtName);
            rFIDPrintPointService.setTable(dBTableModel);
            rFIDPrintPointService.setLayout(this.rfidLayout);
            rFIDPrintPointService.setPrgDir(this.PRGDIR);
            rFIDPrintPointService.setPrgFile(this.PRGFILE);
            rFIDPrintPointService.setOutDir(this.OUTDIR);
            rFIDPrintPointService.setPrtId(this.PRTID);
            rFIDPrintPointService.setPortnm(this.portnm);
            boolean bl = rFIDPrintPointService.execute();
            this.fgkan = rFIDPrintPointService.getFgkan();
            if (this.DEBUG) {
                System.out.println(rFIDPrintPointService);
            }
            if (!bl) {
                this.errMsg.append(rFIDPrintPointService.getErrMsg());
                return false;
            }
        }
        catch (Throwable throwable) {
            this.fgkan = "8";
            this.errMsg.append("RFID Print Request Execution Error. ").append(CR);
            this.errMsg.append("==============================").append(CR);
            this.errMsg.append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , ");
            this.errMsg.append("YKNO=[").append(this.YKNO).append("]").append(CR);
            this.errMsg.append(HybsSystem.sys("REPORT_RFID_SERVICE_CLASS")).append(CR);
            this.errMsg.append(throwable.toString());
            this.errMsg.append(CR);
            this.errMsg.append(rFIDPrintPointService.getErrMsg());
            return false;
        }
        System.out.println("End.");
        return true;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }

    public String getFgkan() {
        return this.fgkan;
    }
}

