/**************************************************************************/
/* GE38 ( ファイル種別マスタ )                                            */
/*                                                                        */
/* Created : 2012/01/20 11:41:09                                          */
/**************************************************************************/
CREATE TABLE GE38 (
   SYSTEM_ID   VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , SYFILE      VARCHAR2(100)                 NOT NULL      /* 20  ファイル種別 */
 , SYNAME      VARCHAR2(200)                               /* 30  種別名称     */
 , DESCRIPTION VARCHAR2(4000)                              /* 40  概要説明     */
 , HINAGATA    VARCHAR2(300)                               /* 50  雛形ファイル */
 , SAVE_FOLDER VARCHAR2(300)                               /* 60  保管フォルダ */
 , FILE_URL    VARCHAR2(300)                               /* 70  ファイルURL  */
 , ICON_URL    VARCHAR2(300)                               /* 80  アイコンURL  */
 , ROLES       VARCHAR2(500)                               /* 90  ロールズ     */
 , SU_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 100 閲覧制限数   */
 , DY_LMT      NUMBER(5)         DEFAULT 0   NOT NULL      /* 110 閲覧期日     */
 , SIZE_LMT    NUMBER(9)         DEFAULT 0   NOT NULL      /* 120 サイズ制限   */
 , SUFFIX_LMT  VARCHAR2(200)                               /* 130 拡張子制限   */
 , FGANGO      VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 140 暗号化FG     */
 , FGZIP       VARCHAR2(1)       DEFAULT '0' NOT NULL      /* 150 圧縮FG       */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 160 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 170 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 180 登録日時     */
 , PGSET       VARCHAR2(10)                                /* 190 作成PG       */
 , PGPSET      VARCHAR2(10)                                /* 200 作成親PG     */
 , USRSET      VARCHAR2(10)                                /* 210 作成社員     */
 , DYUPD       VARCHAR2(14)                                /* 220 更新日時     */
 , PGUPD       VARCHAR2(10)                                /* 230 更新PG       */
 , PGPUPD      VARCHAR2(10)                                /* 240 更新親PG     */
 , USRUPD      VARCHAR2(10)                                /* 250 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE38S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE38T00 
BEFORE INSERT ON GE38
FOR EACH ROW 
BEGIN 
SELECT GE38S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

