/**************************************************************************/
/* GE31 ( 定型文マスタ )                                                  */
/*                                                                        */
/* Created : 2012/01/25 19:01:58                                          */
/**************************************************************************/
CREATE TABLE GE31 (
   SYSTEM_ID VARCHAR2(10)                  NOT NULL      /* 10  システムID   */
 , PTN_ID    VARCHAR2(20)                  NOT NULL      /* 20  定型文ID     */
 , FROM_ID   VARCHAR2(50)                                /* 30  送信者ID     */
 , TO_ID     VARCHAR2(4000)                              /* 40  宛先（TO）   */
 , CC_ID     VARCHAR2(4000)                              /* 50  宛先（CC）   */
 , BCC_ID    VARCHAR2(4000)                              /* 60  宛先（BCC）  */
 , TITLE     VARCHAR2(300)                 NOT NULL      /* 70  タイトル     */
 , CONTENTS  VARCHAR2(4000)                              /* 80  内容         */
 , UNIQ      NUMBER(9)         DEFAULT 0   NOT NULL      /* 90  ユニークキー */
 , FGJ       VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 100 状態フラグ   */
 , DYSET     VARCHAR2(14)                                /* 110 登録日時     */
 , PGSET     VARCHAR2(10)                                /* 120 作成PG       */
 , PGPSET    VARCHAR2(10)                                /* 130 作成親PG     */
 , USRSET    VARCHAR2(10)                                /* 140 作成社員     */
 , DYUPD     VARCHAR2(14)                                /* 150 更新日時     */
 , PGUPD     VARCHAR2(10)                                /* 160 更新PG       */
 , PGPUPD    VARCHAR2(10)                                /* 170 更新親PG     */
 , USRUPD    VARCHAR2(10)                                /* 180 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GE31S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE31T00 
BEFORE INSERT ON GE31
FOR EACH ROW 
BEGIN 
SELECT GE31S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

