<?xml version="1.0"  encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" useRealTimeCheck="false"/>
<og:localResource systemId="GE" initLoad="false" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheckはcolumnEditorでmust指定したカラムをチェックします。-->
<!-- カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck	command   = "{@command}"/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- FAQ登録時	-->
<og:equals val1="{@UPDFLG}" val2="0">
	<og:dataCheck command="{@command}">
			SELECT	COUNT(*)
			FROM	GE80
			WHERE	SYSTEM_ID=[SYSTEM_ID]
			AND		QANO	=[QANO]
			AND		SYSCODE	=[SYSCODE]
	</og:dataCheck>

	<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
	<!-- 通常は変更する必要はありません。 -->
	<og:tableUpdate command="{@command}" 
					queryType="JDBCTableUpdate" 
					debug="false">
		<og:tableUpdateParam
				sqlType  = "{@sqlType}"
				table  = "GE80"
				where  = "UNIQ = [UNIQ]"
				names = "SYSTEM_ID,SYSCODE,QANO,CDBNRUI,KNRNGUI,TITLE,NAIYO,SEQNO,FGJ,KBFAQ,TAG"
				logicalDelete	=  "true"
		/>
	</og:tableUpdate>

	<!-- SEQNOの再セット -->
	<og:query
		command		= "NEW" >
			SELECT A.SEQNO,A.SYSTEM_ID,A.UNIQ
			FROM   GE80 A LEFT OUTER JOIN GE80 B
				ON A.SYSTEM_ID = B.SYSTEM_ID
				AND		A.SYSCODE = B.SYSCODE
				AND		B.KBFAQ != '0'
				AND		B.CDBNRUI = A.CDBNRUI
			WHERE	A.SYSTEM_ID =  '{@MEM.SYSTEM_ID}'
			AND		A.SYSCODE = '{@SYSCODE1}'
			AND    A.FGJ       IN ( '0','1' )
			AND		A.KBFAQ = '0'
			ORDER BY B.SEQNO,A.SEQNO
	</og:query>

	<og:tableFilter classId="SEQRESET" keys="SEQ_CLM" vals="SEQNO" selectedAll="true" />
	<og:tableUpdate
		command		= "{@command}"
		selectedAll = "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GE80 SET
				SEQNO  = [SEQNO]
			WHERE UNIQ = [UNIQ]
			AND SEQNO != [SEQNO]
	</og:tableUpdate>

	<og:forward page="result1.jsp" keys="command" vals="RENEW" />
</og:equals>

<!-- 分類登録時	-->
<og:equals val1="{@UPDFLG}" val2="1">
	<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
	<og:entry command="{@command}" />
	<!-- 重複ﾁｪｯｸ	-->
	<og:dataCheck command="{@command}">
			SELECT	COUNT(*)
			FROM	GE80
			WHERE	SYSTEM_ID=[SYSTEM_ID]
			AND		SYSCODE	=[SYSCODE]
			AND		CDBNRUI	=[CDBNRUI]
			AND		FGJ IN ('1','0')
	</og:dataCheck>
	<!-- 大分類存在ﾁｪｯｸ	-->
	<og:dataCheck command="{@command}" exist="true" sqlType="{@sqlType}" execType="INSERT|COPY" lbl="GFE0007" lblParamKeys="[CDBNRUI]" conditionKey="KBFAQ" conditionList="2" >
		SELECT	COUNT(*)
		FROM	GE80
		WHERE	SYSTEM_ID=[SYSTEM_ID]
		AND		SYSCODE=[SYSCODE]
		AND		[CDBNRUI]	LIKE	CDBNRUI{@DBF.CON}'%'
		AND		KBFAQ='1'
		AND		FGJ	IN	('0','1')
	</og:dataCheck>
	<!-- 対応大分類が2つ以上はNG -->
	<og:dataCheck command="{@command}" exist="true" sqlType="{@sqlType}" execType="INSERT|COPY" lbl="GFE0008" lblParamKeys="[CDBNRUI]" conditionKey="KBFAQ" conditionList="2" >
		SELECT	CASE WHEN COUNT(*) > 1 THEN 0
				ELSE 1 END COUNT
		FROM	GE80
		WHERE	SYSTEM_ID=[SYSTEM_ID]
		AND		SYSCODE=[SYSCODE]
		AND		[CDBNRUI]	LIKE	CDBNRUI{@DBF.CON}'%'
		AND		KBFAQ='1'
		AND		FGJ	IN	('0','1')
	</og:dataCheck>
	<!-- 大分類時、大分類でLIKE検索できたらNG -->
	<og:dataCheck command="{@command}" exist="false" sqlType="{@sqlType}" execType="INSERT|COPY" lbl="GFE0008" lblParamKeys="[CDBNRUI]" conditionKey="KBFAQ" conditionList="1" >
		SELECT	COUNT(*)
		FROM	GE80
		WHERE	SYSTEM_ID=[SYSTEM_ID]
		AND		SYSCODE=[SYSCODE]
		AND		([CDBNRUI]	LIKE	CDBNRUI{@DBF.CON}'%' OR CDBNRUI	LIKE	[CDBNRUI]{@DBF.CON}'%')
		AND		KBFAQ='1'
		AND		FGJ	IN	('0','1')
	</og:dataCheck>
	
	<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
	<!-- 通常は変更する必要はありません。 -->
	<og:tableUpdate command="{@command}" 
					queryType="JDBCTableUpdate" 
					debug="false">
		<og:tableUpdateParam
				sqlType  = "{@sqlType}"
				table  = "GE80"
				where  = "UNIQ = [UNIQ]"
				names = "SYSTEM_ID,SYSCODE,KBFAQ,CDBNRUI,TITLE,SEQNO,FGJ,QANO"
				logicalDelete	=  "true"
		/>
	</og:tableUpdate>

	<!-- SEQNOの再セット -->
	<og:query
		command		= "NEW" >
			SELECT A.SEQNO SEQA,A.CDBNRUI BUNRUIA,B.KBFAQ,B.SEQNO,B.CDBNRUI,B.UNIQ
			FROM   GE80 A LEFT OUTER JOIN GE80 B 
				ON	A.SYSTEM_ID = B.SYSTEM_ID
				AND	A.SYSCODE = B.SYSCODE
				AND	B.FGJ IN ('0','1')
				AND	B.KBFAQ != '0'
				AND	B.CDBNRUI LIKE A.CDBNRUI{@DBF.CON}'%'
			WHERE	A.SYSTEM_ID =  '{@MEM.SYSTEM_ID}'
			AND		A.SYSCODE = '{@SYSCODE1}'
			AND		A.KBFAQ = '1'
			AND		A.FGJ IN ( '0','1' )
			ORDER BY A.SEQNO,B.KBFAQ,B.SEQNO
	</og:query>

	<og:tableFilter classId="SEQRESET" keys="SEQ_CLM,BREAK_CLM" vals="SEQNO,DAIBNRUI" selectedAll="true" />
	<og:tableUpdate
		command		= "{@command}"
		selectedAll = "true"
		queryType	= "JDBCTableUpdate" >
			UPDATE GE80 SET
				SEQNO  = [SEQNO]
			WHERE UNIQ = [UNIQ]
			AND SEQNO != [SEQNO]
	</og:tableUpdate>
	<og:forward page="result2.jsp" keys="command" vals="RENEW" />
</og:equals>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
