<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:og="mis-taglib.tld"
	exclude-result-prefixes="xsl jsp java og" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="MODIFIED"  select="" />
  <xsl:param name="PRE_FIX"   select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <ADDRESS   ><xsl:value-of select="$ADDRESS"   /></ADDRESS>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
     <PRE_FIX   ><xsl:value-of select="$PRE_FIX"   /></PRE_FIX>
  </xsl:param>

  <xsl:template match="jsp:root">
    <xsl:apply-templates select="//og:column[@name]" />
    <xsl:apply-templates select="//og:input[@name]"  />
    <xsl:apply-templates select="//og:select[@name]"   />
    <xsl:apply-templates select="//og:hidden[@name]"   />
    <xsl:apply-templates select="//og:textarea[@name]" />
  </xsl:template>

  <xsl:template match="og:*[@name]">
     <xsl:if test="@name = translate( @name,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"      /></TAGNAME>
           <FORM_TYPE   ><xsl:value-of select="@type"       /></FORM_TYPE>
           <FORM_NAME   ><xsl:value-of select="@name"       /></FORM_NAME>
           <FORM_VAL    ><xsl:value-of select="@value"      /></FORM_VAL>
           <DEFAULT_VAL ><xsl:value-of select="@defaultVal" /></DEFAULT_VAL>
           <LBLCD       ><xsl:value-of select="@lbl"        /></LBLCD>
           <MSGCD       ><xsl:value-of select="@message"    /></MSGCD>
           <MUST        ><xsl:value-of select="@must"       /></MUST>
           <VIEW_SIZE   ><xsl:value-of select="@size"       /></VIEW_SIZE>
           <MAX_SIZE    ><xsl:value-of select="@maxlength"  /></MAX_SIZE>
           <CODE_CLM    ><xsl:value-of select="@codeName"   /></CODE_CLM>
           <READONLY    ><xsl:value-of select="@readonly"   /></READONLY>
           <DISABLED    ><xsl:value-of select="@disabled"   /></DISABLED>
           <ROLES       ><xsl:value-of select="@roles"      /></ROLES>
           <TEXT_DATA   ><xsl:copy-of select="."            /></TEXT_DATA>
         </ROW>
    </xsl:if>
  </xsl:template>
  

</xsl:stylesheet>
