/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.report2.QueueManager_DB;

/**
 * TableFilter_REPORTLAYOUT は、TableFilter インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。
 *
 * ここでは、指定された要求NOに対してGE51(帳票明細データ)をGE52(帳票レイアウトテーブル)の定義に従って、
 * 分割し、DBTableModelを生成します。
 *
 * @see org.opengion.hayabusa.report2.QueueManager_DB.DBTableModelCreator
 * @og.rev 5.1.2.0 (2010/01/01) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_REPORTDATA extends AbstractTableFilter {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.2.0 (2010/01/01)" ;

	/**
	 * DBTableModel処理を実行します。
	 *
	 * @og.rev 5.5.2.6 (2012/05/25) protected変数を、private化したため、getterメソッドで取得するように変更
	 *
	 * @return 処理結果のDBTableModel
	 */
	public DBTableModel execute() {
		String systemId	= getValue( "SYSTEM_ID" );
		String listId = getValue( "LISTID" );
		String ykno = getValue( "YKNO" );
		String kbtext = getValue( "KBTEXT" );

		if( systemId == null || systemId.length() == 0
			|| listId == null || listId.length() == 0
			|| ykno == null || ykno.length() == 0
			|| kbtext == null || kbtext.length() == 0 ) {
			String errMsg = "SYSTEM_ID,LISTID,YKNO,KBTEXTを全て指定して下さい。";
			throw new HybsSystemException( errMsg );
		}

		if( kbtext.length() > 1 || "HFB".indexOf( kbtext ) < 0 ) {
			String errMsg = "KBTEXTは、H(ヘッダー),F(フッター),B(ボディー)のいずれかを指定して下さい";
			throw new HybsSystemException( errMsg );
		}

		QueueManager_DB.DBTableModelCreator creator
//			= new QueueManager_DB.DBTableModelCreator( systemId, listId, ykno, kbtext, resource );
			= new QueueManager_DB.DBTableModelCreator( systemId, listId, ykno, kbtext, getResource() );		// 5.5.2.6 (2012/05/25)

		return creator.getTable();
	}
}
