/**************************************************************************/
/* GFW41 ( GFW41 )                                                        */
/*                                                                        */
/* Created : 2012/07/28 16:35:01                                          */
/**************************************************************************/
CREATE TABLE GFW41 (
   SYSTEM_ID  VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , LANG       VARCHAR2(2)                  NOT NULL      /* 20  言語         */
 , CLM        VARCHAR2(30)                 NOT NULL      /* 30  項目         */
 , NAME_JA    VARCHAR2(200)                              /* 40  名称         */
 , LABEL_NAME VARCHAR2(60)                               /* 50  表示名称     */
 , KBSAKU     VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 60  作成区分     */
 , URL        VARCHAR2(200)                              /* 70  URL          */
 , COMMENTS   VARCHAR2(500)                              /* 80  コメント     */
 , CDTAN      VARCHAR2(10)                               /* 90  担当者       */
 , UNIQ       NUMBER(9)        DEFAULT 0   NOT NULL      /* 800 ユニークキー */
 , FGJ        VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 810 状態フラグ   */
 , DYSET      VARCHAR2(14)                 NOT NULL      /* 820 登録日時     */
 , PGSET      VARCHAR2(10)                               /* 830 作成PG       */
 , PGPSET     VARCHAR2(10)                               /* 840 作成親PG     */
 , USRSET     VARCHAR2(10)                               /* 850 作成社員     */
 , DYUPD      VARCHAR2(14)                 NOT NULL      /* 860 更新日時     */
 , PGUPD      VARCHAR2(10)                               /* 870 更新PG       */
 , PGPUPD     VARCHAR2(10)                               /* 880 更新親PG     */
 , USRUPD     VARCHAR2(10)                               /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );


CREATE SEQUENCE GFW41S00 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GFW41T00 
BEFORE INSERT ON GFW41
FOR EACH ROW 
BEGIN 
SELECT GFW41S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

