<!-- PostgreSQL  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="POSTGRES">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select TABLE_NAME,COLUMN_NAME AS CLM,ORDINAL_POSITION AS SEQNO,COLUMN_NAME AS NAME_JA,
		( CASE UDT_NAME
				WHEN 'int4'    THEN 'NUMBER'
				WHEN 'int8'    THEN 'NUMBER'
				WHEN 'numeric' THEN 'NUMBER'
				WHEN 'text'    THEN 'CLOB'
				ELSE 'VARCHAR2'
				END ) AS CLS_NAME ,
		( CASE WHEN CHARACTER_MAXIMUM_LENGTH IS NULL 
					THEN NUMERIC_PRECISION
					ELSE CHARACTER_MAXIMUM_LENGTH
				END ) AS USE_LENGTH ,
		COLUMN_DEFAULT AS DATA_DEFAULT,
		( CASE IS_NULLABLE WHEN 'YES' THEN null WHEN 'NO' THEN '1' END) AS NOT_NULL,
		'0' AS FGCOM, '' AS BIKO,'' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
		'{@SYSTEM_ID}' AS SYSTEM_ID,
		'{@TBLSYU}' AS TBLSYU
		from information_schema.columns
		<og:where>
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value = "table_schema = 'public'" />
		</og:where>
		order by TABLE_NAME,ORDINAL_POSITION
  </og:query>
</og:equals>

<!-- ORACLE  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select TABLE_NAME,COLUMN_NAME AS CLM,COLUMN_ID AS SEQNO,COLUMN_NAME AS NAME_JA,
			DATA_TYPE AS CLS_NAME,
			( CASE WHEN DATA_PRECISION IS NULL 
						THEN to_char(DATA_LENGTH)
						ELSE (	CASE WHEN DATA_SCALE = 0 
									THEN to_char(DATA_PRECISION)
									ELSE DATA_PRECISION || ',' || DATA_SCALE
							  	END )
					 END ) AS USE_LENGTH ,
			DATA_DEFAULT ,
		    (CASE NULLABLE WHEN 'Y' THEN null WHEN 'N' THEN '1' END) AS NOT_NULL,
			'0' AS FGCOM, '' AS BIKO,'' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
		from USER_TAB_COLUMNS
		where exists ( select 'X' from USER_TABLES
						where USER_TABLES.TABLE_NAME = USER_TAB_COLUMNS.TABLE_NAME
					)
		<og:where startKey="and">
			<og:and value = "TABLE_NAME like '{@TABLE_NAME}%'" />
			<og:and value = "INSTR(TABLE_NAME,'$') < 1" />
		</og:where>
		order by TABLE_NAME,COLUMN_ID
  </og:query>
</og:equals>

<!-- FIREBIRD  -->
<og:equals val1="{@DBF.NAME @DBID}" val2="FIREBIRD">
  <og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
		select r.RDB$RELATION_NAME	AS TABLE_NAME,
			r.RDB$FIELD_NAME		AS CLM,
			r.RDB$FIELD_POSITION	AS SEQNO,
			r.RDB$FIELD_NAME		AS NAME_JA,
			CASE f.RDB$FIELD_TYPE
				WHEN   7 THEN 'SMALLINT'
				WHEN   8 THEN 'INTEGER'
				WHEN   9 THEN 'QUAD'
				WHEN  10 THEN 'FLOAT'
				WHEN  11 THEN 'D_FLOAT'
				WHEN  12 THEN 'DATE'
				WHEN  13 THEN 'TIME'
				WHEN  14 THEN 'CHAR'
				WHEN  16 THEN 'INT64'
				WHEN  27 THEN 'DOUBLE'
				WHEN  35 THEN 'TIMESTAMP'
				WHEN  37 THEN 'VARCHAR'
				WHEN  40 THEN 'CSTRING'
				WHEN 261 THEN 'BLOB'
				ELSE 'UNKNOWN'
				END AS CLS_NAME ,
			f.RDB$FIELD_LENGTH		AS USE_LENGTH ,
			replace(r.RDB$DEFAULT_SOURCE,'Default ','') AS DATA_DEFAULT ,
		    r.RDB$NULL_FLAG			AS NOT_NULL,
			'0' AS FGCOM,'' AS BIKO,'' AS RENDERER,'' AS EDITOR,'' AS DBTYPE,
			'{@SYSTEM_ID}' AS SYSTEM_ID,
			'{@TBLSYU}' AS TBLSYU
		from RDB$RELATION_FIELDS r LEFT JOIN RDB$FIELDS f
		ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
		where r.RDB$SYSTEM_FLAG = 0
		<og:where startKey="and">
			<og:and value = "r.RDB$RELATION_NAME like '{@TABLE_NAME}%'" />
		</og:where>
		order by r.RDB$RELATION_NAME,r.RDB$FIELD_POSITION
  </og:query>
</og:equals>
