<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page errorPage="/jsp/common/error.jsp" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:columnCheck
	command   = "NEW"
/>

<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		DELETE FROM GF81
		WHERE SYSTEM_ID = '{@SYSTEM_ID}'
		AND   TBLSYU    = '{@TBLSYU}'
	</jsp:text>
	<og:where startKey="and">
		<og:and value = "OBJ_NAME like '{@OBJ_NAME}%'" />
	</og:where>
</og:query>

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000">
	<jsp:text>
		select A.OBJECT_NAME AS OBJ_NAME,B.LINE AS SEQNO,'' AS CLM ,
				'' AS CLS_NAME,'' AS USE_LENGTH,'' AS CLM_NAME,
				'' AS TABLE_NAME ,'' AS MAX_LENGTH,
				B.TEXT , '{@SYSTEM_ID}' AS SYSTEM_ID,'{@TBLSYU}' AS TBLSYU
		from USER_OBJECTS A inner join USER_SOURCE B
		on    A.OBJECT_NAME = B.NAME
		where A.OBJECT_TYPE = 'TYPE'
		and   B.TYPE        = 'TYPE'
		and   not A.OBJECT_NAME like '%ARRAY'
	</jsp:text>
		<og:where startKey="and">
			<og:and value = "A.OBJECT_NAME like '{@OBJ_NAME}%'" />
		</og:where>
	<jsp:text>
		order by A.OBJECT_NAME,B.LINE
	</jsp:text>
</og:query>

<og:tableFilter classId="DBARG"
		keys="TEXT,SEQNO,CLM,CLS_NAME,USE_LENGTH,CLM_NAME,MAX_LENGTH"
		vals="TEXT,SEQNO,CLM,CLS_NAME,USE_LENGTH,CLM_NAME,MAX_LENGTH" />

<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="100000" scope="request">
	<jsp:text>
		select CLM,MAX(USE_LENGTH) AS MAX_LENGTH
		from (
			select COLUMN_NAME AS CLM,
				( CASE WHEN DATA_PRECISION IS NULL 
							THEN to_char(DATA_LENGTH)
							ELSE (	CASE WHEN DATA_SCALE = 0 
										THEN to_char(DATA_PRECISION)
										ELSE DATA_PRECISION || ',' || DATA_SCALE
								  	END )
						 END ) AS USE_LENGTH
			from USER_TAB_COLUMNS
			where INSTR(TABLE_NAME,'$') &lt; 1 
		)
		group by CLM
	</jsp:text>
</og:query>

<og:tableMerge
	action     = "UNION_CLM"
	slaveKeys  = "CLM"
	unionClms  = "MAX_LENGTH"
/>

<og:query command="NEW" debug="{@debug}" maxRowCount="100000" scope="request">
	<jsp:text>
		select CLM,CLM_NAME
		from GF80
		where FGJ		in  ('0','1')
		and   SYSTEM_ID	=  '{@SYSTEM_ID}'
		and   TBLSYU	=  '3'
		group by CLM,CLM_NAME
	</jsp:text>
</og:query>

<og:tableMerge
	action     = "UNION_CLM"
	slaveKeys  = "CLM"
	unionClms  = "CLM_NAME"
/>

<og:tableUpdate
	command		= "ENTRY"
	queryType	= "JDBCTableUpdate"
	selectedAll = "true"
>
<jsp:text>
	INSERT INTO GF81
		(SYSTEM_ID,TBLSYU,OBJ_NAME,SEQNO,CLM ,CLS_NAME,USE_LENGTH,
		 TABLE_NAME,MAX_LENGTH,CLM_NAME,
		 CDKH,FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD)
	VALUES
		([SYSTEM_ID],[TBLSYU],[OBJ_NAME],[SEQNO],[CLM],[CLS_NAME],[USE_LENGTH],
		 [TABLE_NAME],[MAX_LENGTH],[CLM_NAME],
		 NULL,'1','{@USER.YMDH}','{@USER.YMDH}','{@USER.ID}','{@USER.ID}','{@GUI.KEY}')
</jsp:text>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
