<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useGantt="false" useScrollBar="false">
	<link rel="stylesheet" type="text/css"  href="../common/option/adjustGantTable.css?v={@USER.YMDH}" />
	<script type="text/javascript" language="JavaScript" src="../common/option/adjustGantTable.js?v={@USER.YMDH}" ><!-- --></script>
</og:head>
<script lang="javaScript">
	addEvent( this, "load", adjustGant ); //ガント処理
</script>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<og:comment
	system	= "エンジンサンプル"
	pgid	= "GF7216"
	title	= "特殊ガント"
	date	= "2012/08/17"
	author	= "S.Li"
	text	= "システム、プログラムＩＤ、処理名、作成日、作成者を修正して下さい。"
	version	= "001">
	adjustGantTable.jsを利用したガント表示です。
	ガントの表示処理をクライアント側で行います。
</og:comment>

<!--製番未入力の場合 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	SELECT	 A.PN																	PN		
			,A.NOORDER																NOORDER		
			,A.SUORDER																SUORDER
			,A.DYORDER																DYJYU
			,TO_CHAR( CAST(A.DYORDER AS DATE) ,'YYYYMMDD' )							MARK_DAY1
			,TO_CHAR( CAST(A.DYORDER AS DATE) + 3 ,'YYYYMMDD' )						MARK_DAY2
			,A.DYORDER																DYJYU1
			,A.DYNOKI																DYNOKI
			,A.DYNOKI																DYNOKI2
			,DECODE( MOD(ROWNUM ,10) 
				,0 ,'black'
				,1 ,'lightblue' 
				,2 ,'blue' 
				,3 ,'lightgreen' 
				,4 ,'green' 
				,5 ,'orange' 
				,6 ,'pink' 
				,7 ,'red' 
				,8 ,'brown' 
				,9 ,'purple' 
			 ) COLOR
	FROM GF45 A
	<og:where>
		<og:and value="NOORDER = '{@NOORDER}'" />
	</og:where>
	<og:appear startKey="ORDER BY" value="{@ORDER_BY}" defaultVal="PN" />
</og:query>
<og:value command="SQL">
	SELECT	 min( A.DYORDER  )														MIN_DATE
			,TO_CHAR(ADD_MONTHS( TO_DATE( MIN( A.DYORDER )) ,3) ,'YYYYMMDD' )		MAX_DATE
	FROM GF45 A
</og:value>

<og:view
	viewFormType = "HTMLCustomTable"
	command		 = "{@command}"
	writable	 = "false"
	useScrollBar = "false"
>
<og:thead rowspan="2">
	<tr>
		<td>					[NOORDER]			</td>
		<td>					[SUORDER]			</td>
		<td>					[DYJYU1]			</td>
		<td rowspan="2" class="gantt zoom{@VZOOM}" style="text-align:left;background-image: url('../image/ganttBG{@VZOOM}.gif');" >
            <div style="position:relative;left:0px;z-index:101; " height="100%" width="100%" >
                <og:ganttHeader
                    startDate      = "{@MIN_DATE}"
                    endDate        = "{@MAX_DATE}"
                    zoom           = "{@VZOOM}"
                    daySpan        = "0700-2000"
                    calDB          = "GE13"
					arg1		   = "A"
                    breakTimes     = "1200-1300"
                    breakTimeStyle = "top:30px;background-color:gray;"
					skipHoliday    = "true"
                />
			</div>
		</td>
	</tr>
	<tr>
		<td colspan="2">[PN]</td>
		<td>					[DYNOKI]			</td>
	</tr>
</og:thead>
<og:tbody rowspan="2">
	<tr>
		<td>					[NOORDER]			</td>
		<td>					[SUORDER]			</td>
		<td>					[DYJYU1]			</td>
		<td rowspan="2" class="gantt zoom{@VZOOM}" style="text-align:left;background-image: url('../image/ganttBG{@VZOOM}.gif');" >
			<iGantBar type="1" color="[COLOR]" start="[DYJYU]" end="[DYNOKI2]" msg="[PN]" />
			<iGantBar type="0" src="../image/dia_blue.gif" start="[MARK_DAY1]"     msg="開始"  />
			<iGantBar type="0" src="../image/dia_red.gif"  start="[DYNOKI2]"       msg="終了"  />
		</td>
	</tr>
	<tr>
		<td colspan="2">		[PN]			</td>
		<td>					[DYNOKI]		</td>
	</tr>
</og:tbody>
</og:view>

<og:text>
	<iGant 
		margeRows	= "{@MARGEROWS}"
		fixedCols   = "6"
	/>
</og:text>
<!-- ガント描画の利用方法 
	【属性説明】
		type		: ガント要素のタイプ（0:マイルストーン 1:バー ）
		color		: バーの色（マイルストーンの場合は不要）
		src			: マイルストーンのアイコン画像(URIより設定)
		start	 	: 開始日(YYYYMMDD)、または開始時間(YYYYMMDDHH24MM)
		end			: 終了日(YYYYMMDD)、または終了時間(YYYYMMDDHH24MM)（マイルストーンの場合は不要）
		msg			: ガント要素の注釈メッセージ
	【使用例１：バー】
		<iGantBar 
			type		= "1" 
			color		= "[COLOR]" 
			start		= "[DYJYU]" 
			end			= "[DYNOKI2]" 
			msg			= "[PN]" 
		/>
	【使用例２：バー】
		<iGantBar 
			type		= "0" 
			src			= "../image/dia_red.gif"
			start		= "[DYJYU]" 
			msg			= "[PN]" 
		/>
-->
<!--ガント全体の属性設定（必須）
	【属性説明】
		margeRows		: 複数行のマージ、前後の行データが一致している場合はマージする。
		fixedCols		: 左の固定列の列数（テーブル２分割機能）
		viewNumberType 	: viewタグの出力に番号列が出力されるか(出力されていない場合:delete)
	【使用例】
		<iGant 
			margeRows	= "{@MARGEROWS}"
			fixedCols   = "6"
		/>
-->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
