/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.html;

/**
 * スタックガントチャート(テーブル形式)表示クラス用のパラメータ定数定義クラスです。
 *
 * パラメータのキーとなる値と、初期値を設定しています。
 * すべて、public static final で定義されている為、設定値はドキュメント等で
 * 確認することが可能です。
 * ただし、キー値などを、直書きすることを前提に公開していませんので、
 * 必要であれば、定数として、このクラス経由で使用してください。
 *
 * @og.rev 5.5.7.0 (2012/10/01) 新規作成
 * @og.group その他
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class ViewStackTableParam {
	/** パラメータキー {@value} */
	public static final String STACK_COLUMNS_KEY   = "h_stackColumns"   ;

	/** パラメータ初期値:{@value} */
	public static final String STACK_COLUMNS_VALUE   = ""  ;
	
	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_MONTH = "MONTH" ;
	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_WEEK = "WEEK" ;
	/** Zoom設定値:{@value} */
	public static final String STACK_ZOOM_DAY = "DAY" ;
}
