/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.html.ViewStackTableParam;

import static org.opengion.fukurou.util.StringUtil.nval ;

import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;

/**
 * viewタグの viewFormType が HTMLGanttTable の場合にパラメータを設定します。
 *
 * ガントチャートを表示する、ViewForm_HTMLGanttTable クラスに対して、各種パラメータを
 * 設定します。
 * パラメータが設定されていない場合は、ViewStackTableParam の初期値が
 * 使用されます。
 * (パラメータを使用するには、viewタグのuseParam 属性をtrueに設定する必要があります。)
 *
 * @og.formSample
 * ●形式：&lt;og:stackParam stackColumns="PRJCODE,RESOURCE_ID" /&gt;
 * ●body：なし
 *
 * ●Tag定義：
 *   &lt;og:stackParam
 *       stackColumns       【TAG】積上単位とするカラム名(カンマ区切り)をセットします (必須)
 *       debug              【TAG】デバッグ情報を出力するかどうか[true/false]を指定します(初期値:false)
 *   /&gt;
 *
 * @og.rev 5.5.7.0 (2012/10/01) 新規作成
 * @og.group 画面表示
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class ViewStackParamTag extends ViewParamTag {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.0.0 (2012/10/01)" ;

	private static final long serialVersionUID = 4000 ;	// 4.0.0 (2005/01/31)

	/**
	 * 【TAG】積上単位とするカラム名(カンマ区切り)をセットします
	 *
	 * @og.tag
	 * 工数積上げのキーとなるカラム名を指定します。
	 * 
	 * 複数ある場合は、カンマ区切りで指定できます。
	 * テーブルモデルは積上単位＋タスク単位でOrderByがかかっている必要があります。<br/>
	 *
	 * @param	stackColumns タスク（ガント）のカラム名(カンマ区切り)
	 */
	public void setStackColumns( final String stackColumns ) {
		putParam( ViewStackTableParam.STACK_COLUMNS_KEY ,
				  nval( getRequestParameter( stackColumns ),null ) );
	}
	
	/**
	 * タグの名称を、返します。
	 * 自分自身のクラス名より、自動的に取り出せないため、このメソッドをオーバーライドします。
	 *
	 *
	 * @return  タグの名称
	 */
	@Override
	protected String getTagName() {
		return "ganttParam" ;
	}

	/**
	 * シリアライズ用のカスタムシリアライズ書き込みメソッド
	 *
	 * @serialData
	 *
	 * @param	strm	ObjectOutputStreamオブジェクト
	 */
	private void writeObject( final ObjectOutputStream strm ) throws IOException {
		strm.defaultWriteObject();
	}

	/**
	 * シリアライズ用のカスタムシリアライズ読み込みメソッド
	 *
	 * ここでは、transient 宣言された内部変数の内、初期化が必要なフィールドのみ設定します。
	 *
	 * @serialData
	 *
	 * @param	strm	ObjectInputStreamオブジェクト
	 * @see #release2()
	 */
	private void readObject( final ObjectInputStream strm ) throws IOException , ClassNotFoundException {
		strm.defaultReadObject();
	}
}
