/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.FirstProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.SystemParameter;

public class Process_DBReader
extends AbstractProcess
implements FirstProcess {
    private static final String SQL_KEY = "sql_";
    private Connection connection = null;
    private Statement stmt = null;
    private ResultSet resultSet = null;
    private LineModel newData = null;
    private int count = 0;
    private int fetchSize = 100;
    private String dbid = null;
    private boolean display = false;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty = new LinkedHashMap<String, String>();

    public Process_DBReader() {
        super("org.opengion.fukurou.process.Process_DBReader", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        String string = argument.getFileProparty("sql", "sqlFile", true);
        String string2 = argument.getProparty("fetchSize");
        this.display = argument.getProparty("display", this.display);
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
        HybsEntry[] hybsEntryArray = argument.getEntrys(SQL_KEY);
        SystemParameter systemParameter = new SystemParameter(string);
        string = systemParameter.replace(hybsEntryArray);
        if (string2 != null) {
            this.fetchSize = Integer.parseInt(string2);
        }
        try {
            this.stmt = this.connection.createStatement();
            if (this.fetchSize > 0) {
                this.stmt.setFetchSize(this.fetchSize);
            }
            this.resultSet = this.stmt.executeQuery(string);
            this.newData = this.createLineModel(this.resultSet);
            if (this.display) {
                this.println(this.newData.nameLine());
            }
        }
        catch (SQLException sQLException) {
            String string3 = "Query \u306e\u5b9f\u884c\u306b\u554f\u984c\u304c\u3042\u308a\u307e\u3059\u3002[" + string + "]";
            throw new RuntimeException(string3, sQLException);
        }
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.resultClose(this.resultSet);
        this.resultSet = null;
        boolean bl3 = Closer.stmtClose(this.stmt);
        this.stmt = null;
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2 || !bl3) {
            String string = "\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string);
        }
    }

    @Override
    public boolean next() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException sQLException) {
            String string = "\u30cd\u30af\u30b9\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002";
            throw new RuntimeException(string, sQLException);
        }
    }

    @Override
    public LineModel makeLineModel(int n) {
        ++this.count;
        try {
            for (int i = 0; i < this.newData.size(); ++i) {
                Object object = this.resultSet.getObject(i + 1);
                if (object == null) {
                    this.newData.setValue(i, null);
                    continue;
                }
                this.newData.setValue(i, object);
            }
            this.newData.setRowNo(n);
            if (this.display) {
                this.println(this.newData.dataLine());
            }
        }
        catch (SQLException sQLException) {
            String string = "\u30c7\u30fc\u30bf\u3092\u51e6\u7406\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + n + "]\u4ef6\u76ee " + this.newData.toString();
            throw new RuntimeException(string, sQLException);
        }
        return this.newData;
    }

    private LineModel createLineModel(ResultSet resultSet) {
        LineModel lineModel = new LineModel();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            lineModel.init(n);
            for (int i = 0; i < n; ++i) {
                String string = resultSetMetaData.getColumnLabel(i + 1).toUpperCase(Locale.JAPAN);
                lineModel.setName(i, string);
            }
        }
        catch (SQLException sQLException) {
            String string = "ResultSetMetaData \u304b\u3089\u3001\u30ab\u30e9\u30e0\u540d\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002";
            throw new RuntimeException(string, sQLException);
        }
        return lineModel;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "DBID        : " + this.dbid + CR + "\t" + "Input Count : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_DBReader\u306f\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3092\u3001LineModel \u306b\u8a2d\u5b9a\u5f8c\u3001").append(CR);
        stringBuilder.append("\u4e0b\u6d41\u306b\u6e21\u3059\u3001FirstProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u304b\u3089\u8aad\u307f\u53d6\u3063\u305f\u5185\u5bb9\u3088\u308a\u3001LineModel\u3092\u4f5c\u6210\u3057\u3001\u4e0b\u6d41(\u30d7\u30ed\u30bb\u30b9").append(CR);
        stringBuilder.append("\u30c1\u30a7\u30a4\u30f3\u306f\u3001\u30c1\u30a7\u30a4\u30f3\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)").append(CR);
        stringBuilder.append("\u306b\u6e21\u3057\u307e\u3059\u3002\u3053\u3053\u3067\u6307\u5b9a\u3067\u304d\u308b\u306e\u306f\u3001\u691c\u7d22\u7cfbSQL \u306e\u307f\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR);
        stringBuilder.append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("SQL\u6587\u306b\u306f\u3001{@DATE.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBReader().usage());
    }

    static {
        usableProparty.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        usableProparty.put("sql", "\u691c\u7d22SQL\u6587(sql or sqlFile \u5fc5\u9808)\u4f8b: \"select * from GEA08\"");
        usableProparty.put("sqlFile", "\u691c\u7d22SQL\u30d5\u30a1\u30a4\u30eb(sql or sqlFile \u5fc5\u9808)\u4f8b: select.sql");
        usableProparty.put(SQL_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put("fetchSize", "\u30d5\u30a7\u30c3\u30c1\u3059\u308b\u884c\u6570 (\u521d\u671f\u5024:100)");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

