<jsp:directive.page pageEncoding="UTF-8" />
<og:query command="{@command}" debug="{@debug}" dbid="{@DBID_R}" maxRowCount="0">
	select '1' WRITABLE, '' TABLE_NAME,A.CLM,COALESCE(B.LNAME,B.NAME_JA,A.NAME_JA) as NAME_JA,
			A.CLS_NAME,A.RENDERER,A.EDITOR,A.DBTYPE,
			A.USE_LENGTH,A.UNIQ,A.SYSTEM_ID,0 SEQ
	from GEA03 A left outer join GEA08 B
		on	A.SYSTEM_ID = B.SYSTEM_ID
		and A.CLM	    = B.CLM
		and B.LANG		= 'ja'
		and A.FGJ		= B.FGJ
	where A.SYSTEM_ID in ( '{@SYSTEM_ID_R}','**' )
	<og:where startKey="and">
		<og:and value="A.CLM like '{@CLM_R}%'"	/>
	</og:where>
	and   A.FGJ       = '1'
	ORDER BY A.SYSTEM_ID DESC, A.KBSAKU DESC, A.CLM
</og:query>

<og:query command="{@command}" debug="{@debug}" maxRowCount="0" scope="request">
	select	'0' WRITABLE, UPPER(TABLE_NAME) AS TABLE_NAME,UPPER(CLM) AS CLM,NAME_JA,CLS_NAME,
			RENDERER,EDITOR,DBTYPE,
			USE_LENGTH,UNIQ,SYSTEM_ID,0 SEQ
	from GF05
	where SYSTEM_ID = '{@SYSTEM_ID_D}'
	and   TBLSYU    = '{@TBLSYU_D}'
	<og:where startKey="and">
		<og:and value="TABLE_NAME like '{@TABLE_NAME_D}%'"	/>
		<og:and value="CLM        like '{@CLM_D}%'"			/>
	</og:where>
	and   FGCOM		<= '5'
	and   FGJ		= '1'
	order by CLM,TABLE_NAME
</og:query>

<og:tableMerge
	action        = "DIFFERENCE"
	masterScope   = "session"
	masterKeys    = "CLM"
	diffKeys      = "CLS_NAME,RENDERER,EDITOR,DBTYPE,USE_LENGTH"
	modifyClms    = "UNIQ"
	slaveScope    = "request"
	display       = "true"
/>

<og:value key="lblKey" value="C" />

<!-- UNIQ のみでユニークになるが、安全のため、SYSTEM_IDとTBLSYU_D,TABLE_NAME,CLM だけは条件に加えておく -->
<og:hidden name="SQL">
	UPDATE GF05 SET
			CLS_NAME	= [CLS_NAME],
			RENDERER	= [RENDERER],
			EDITOR		= [EDITOR],
			DBTYPE		= [DBTYPE],
			USE_LENGTH	= [USE_LENGTH],
			DYUPD		= '{@USER.YMDH}',
			USRUPD		= '{@USER.ID}',
			PGUPD		= '{@GUI.KEY}'
	WHERE	UNIQ		= [UNIQ]
	AND		SYSTEM_ID	= '{@SYSTEM_ID_D}'
	AND		TBLSYU		= '{@TBLSYU_D}'
	AND		UPPER(TABLE_NAME)	= [TABLE_NAME]
	AND		UPPER(CLM)			= [CLM]
</og:hidden>
