<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useRealTimeCheck="false"/>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジン標準"
	pgid	= "FAQRGST"
	title	= "標準(FAQ登録)"
	date	= "2012/01/10"
	author	= "Son.I"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- DB登録時に使用する USRSET カラムを、DBTableModel に設定しておきます。-->
	<!-- <jsp:text>は不要です。-->
		SELECT	CASE WHEN '{@USER.ROLES}' = 'root' THEN '1'
					WHEN A.SYSTEM_ID = '**' THEN '0'
					ELSE '1' END WRITABLE
				,A.FGJ													<!-- 状況 -->
				,A.QANO													<!-- 質問番号 -->
				,A.CDBNRUI												<!-- 分類名 -->
				,A.KNRNGUI												<!-- 関連画面ID -->
				,A.TITLE												<!-- ﾀｲﾄﾙ -->
				,A.NAIYO												<!-- 内容 -->
				,A.SEQNO												<!-- 表示順 -->
				,A.SYSTEM_ID											<!-- ｼｽﾃﾑID -->
				,A.SYSCODE												<!-- ｼｽﾃﾑｺｰﾄﾞ -->
				,A.TAG													<!-- (非表示)ﾀｸﾞ-->
				,A.UNIQ													<!-- (非表示)ﾕﾆｰｸ -->
				,CASE WHEN A.SYSTEM_ID = '**' THEN '1'
					ELSE '0' END SYS_SEQNO								<!-- (非表示)表示順_ｼｽﾃﾑID -->
				,A.KBFAQ												<!-- (非表示)FAQ区分	-->
		FROM	GE80 A
		WHERE	A.SYSTEM_ID	IN	('{@SYSTEM_ID}','{@AST}')
	<og:where startKey="and">
		<og:equals val1="{@CHECK}" val2="1">
			<og:and value = "A.FGJ			IN		('0','1')"		/>	<!-- GE80(FAQ)》状態ﾌﾗｸﾞ IN ('0','1')-->
		</og:equals>
		<og:and value = "A.KBFAQ			=		'0'"			/>	<!-- GE80(FAQ)》FAQ区分 = '1'		-->
		<og:and value = "A.SYSCODE			=		'{@SYSCODE}'"	/>	<!-- GE80(FAQ)》ｼｽﾃﾑｺｰﾄﾞ = 画面》ｼｽﾃﾑｺｰﾄﾞ	-->
		<og:and value = "A.QANO			LIKE	'{@QANO}%'"			/>	<!-- GE80(FAQ)》質問番号 LIKE 画面》質問番号%-->
		<og:and value = "A.CDBNRUI		LIKE	'{@CDBNRUI}%'"		/>	<!-- GE80(FAQ)》分類 LIKE 画面》分類%-->
		<og:and value = "A.KNRNGUI		LIKE	'%{@KNRNGUI}%'"		/>	<!-- GE80(FAQ)》関連画面ID LIKE %画面》関連画面ID%-->
		<og:and value = "(A.TITLE		LIKE	'%{@KEYWORD}%'	OR
						  A.NAIYO		LIKE	'%{@KEYWORD}%'	OR
						  A.TAG			LIKE	'%{@KEYWORD}%')"	/>	<!-- GE80(FAQ)》ﾀｲﾄﾙ､内容､ﾀｸﾞｷｰﾜｰﾄﾞ LIKE '%画面》ｷｰﾜｰﾄﾞ%'-->
	</og:where>
	<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,SYSCODE,A.SEQNO" />		<!-- ｼｽﾃﾑID､ｼｽﾃﾑｺｰﾄﾞ､表示順	-->
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:equals val1="{@USER.ROLES}" val2="root" notEquals="true">	
	<og:columnEditor columns="SYSTEM_ID" defaultVal="{@SYS.SYSTEM_ID}" must="true" optionAttributes="readonly" style="border-style:solid;border:0px;background:transparent;" />
</og:equals>
<og:equals val1="{@USER.ROLES}" val2="root" >	
	<og:columnEditor columns="SYSTEM_ID" must="true"/>
</og:equals>
<og:columnEditor columns="QANO" must="true" />
<og:columnEditor columns="TITLE" renderer="SLABEL" parameter="20"/>
<og:columnEditor columns="NAIYO" renderer="SLABEL" parameter="20" />
<og:columnEditor columns="CDBNRUI" editor="DBMENU" eventColumn="SYSTEM_ID,SYSCODE">
	SELECT CDBNRUI,TITLE
	FROM GE80 WHERE KBFAQ != '0' 
	AND SYSTEM_ID = '{@SYSTEM_ID}'
	AND ( ('{@SYSCODE}' is null AND SYSCODE='*') OR SYSCODE = '{@SYSCODE}')
	ORDER BY SEQNO
</og:columnEditor>
<og:columnEditor columns="TAG" editor="INDBMENU" parameter="SELECT TAG,TAG NAME_A FROM GE80 WHERE FGJ IN ('0','1') AND TAG IS NOT NULL AND KBFAQ = '0' GROUP BY TAG"/>


<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<!-- ここでは、すべてを、update.jsp に転送している為、command属性を設定しています。-->
<og:writeCheck>
	<og:submit value="update" command="INSERT" lbl="INSERT" accesskey="I"
			keys="lblKey,noWritable" vals="MSG0044,UNIQ" />
	<og:submit value="update" command="COPY"   lbl="COPY"   accesskey="C"  
			keys="lblKey,noWritable" vals="MSG0045,UNIQ" />
	<og:submit value="update" command="MODIFY" lbl="MODIFY" accesskey="M" 
			keys="noWritable" vals='"QANO,SYSTEM_ID,SYSCODE,UNIQ"' />
	<og:submit  value="update" command="DELETE" lbl="DELETE" accesskey="Z" 
			keys="noWritable" vals='"SYSTEM_ID,SYSCODE,FGJ,QANO,CDBNRUI,KNRNGUI,TITLE,NAIYO,SEQNO,TAG"'/>
<br />
</og:writeCheck>


<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable" 
	command      = "{@command}" 
	noDisplay    = "UNIQ,SYS_SEQNO,KBFAQ,TAG"
	selectedType = "radio"  />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
