/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.util;

// import java.text.DateFormat;
// import java.text.SimpleDateFormat;
// import java.util.Locale;
// import java.util.Calendar;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * SystemParameter は、{&#064;XXXX} 文字列を処理するクラスです。
 * このクラスでは、{&#064;XXXX} 文字列を別の文字列と置き換えることや、
 * 予め予約されている予約語 {&#064;SYS.XXXX} 文字列を置き換えます。
 * 通常の {&#064;XXXX} 文字列の置き換えは、キーと値のペアを、HybsEntry オブジェクトに
 * セットして、その配列を受け取って処理します。
 *
 * 以下の値はあらかじめ、動的に作成されます。
 * ・SYS.YMD       ８byte の今日のシステム日付(yyyyMMdd)
 * ・SYS.YMDH    １４byte の今日のシステム日時(yyyyMMddHHmmss)
 * ・SYS.HMS       ６byte の今日のシステム時間(HHmmss)
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public final class SystemParameter {

//	private final Map<String,String> sysMap = new HashMap<String,String>();
	/** 改行コード */
	public static final String CR = System.getProperty("line.separator");	// 5.1.9.0 (2010/08/01) 追加

	// 	5.5.7.2 (2012/10/09) HybsDateUtil を利用するため、削除します。
// 	private static final Map<String,String>	DATE_FORMAT = new HashMap<String,String>();	// 5.3.4.0 (2011/04/01)
// 	static {
// 		DATE_FORMAT.put( "SYS.YMD"		,"yyyyMMdd"				);
// 		DATE_FORMAT.put( "SYS.YMDH" 	,"yyyyMMddHHmmss"		);
// 		DATE_FORMAT.put( "SYS.HMS"		,"HHmmss"				);
// 		DATE_FORMAT.put( "DATE.YMD" 	,"yyyyMMdd" 			);
// 		DATE_FORMAT.put( "DATE.Y2MD"	,"yyMMdd"				);
// 		DATE_FORMAT.put( "DATE.YM"		,"yyyyMM"				);
// 		DATE_FORMAT.put( "DATE.HMS" 	,"HHmmss"				);
// 		DATE_FORMAT.put( "DATE.YMDHMS"	,"yyyyMMddHHmmss"		);
// 		DATE_FORMAT.put( "DATE.YMDF"	,"yyyy/MM/dd"			);
// 		DATE_FORMAT.put( "DATE.Y2MDF"	,"yy/MM/dd" 			);
// 		DATE_FORMAT.put( "DATE.YMF" 	,"yyyy/MM"				);
// 		DATE_FORMAT.put( "DATE.HMSF"	,"HH:mm:ss" 			);
// 		DATE_FORMAT.put( "DATE.YMDHMSF" ,"yyyy/MM/dd/ HH:mm:ss" );
// 		DATE_FORMAT.put( "DATE.EEE" 	,"EEE"					);
// 	}

	private final String	original ;
	// 5.5.7.2 (2012/10/09) Calendarオブジェクトから、String時刻に変更。
//	private final Calendar	rightNow;									// 5.3.4.0 (2011/04/01)
	private final String	RIGHT_NOW = HybsDateUtil.getDate( "yyyyMMdd" );

	private final String[] clms;
	private final String[] formats;

	/**
	 *  {&#064;XXXX} の特殊文字を含む文字列を、置き換えます。
	 * 対象外の文字列は、そのまま、残されます。
	 *
	 * @og.rev 5.1.8.0 (2010/07/01) パース方法見直し(StringTokenizerでは、{&#064;XXXX}が連続してある場合に対応できない)
	 * @og.rev 5.3.2.0 (2011/02/01) original データを、パース結果を利用するように修正する。
	 * @og.rev 5.3.4.0 (2011/04/01) {&#064;DATE.XXXX} を処理できるように機能追加
	 * @og.rev 5.3.5.0 (2011/05/01) {&#064;SYS.XXXX} は、廃止
	 * @og.rev 5.5.7.2 (2012/10/09) rightNow をCalendarオブジェクト ではなく、String時刻とします。
	 * @og.rev 5.5.7.2 (2012/10/09) HybsDateUtil を利用するように修正します。
	 *
	 * @param	orig	変換する文字列(オリジナル)
	 */
	public SystemParameter( final String orig ) {
//		rightNow = Calendar.getInstance();

		if( orig == null || orig.length() == 0 || orig.indexOf( "{@" ) < 0 ) {
			clms     = null;
			formats  = null;
			original = orig;		// 5.3.2.0 (2011/02/01)
		}
		else {
			StringBuilder buf = new StringBuilder(orig.length());		// 5.3.2.0 (2011/02/01)

			ArrayList<String> fmtList = new ArrayList<String>();
			ArrayList<String> clmList = new ArrayList<String>();

			// 5.1.8.0 (2010/07/01) パース方法見直し
			int start = 0;
			int index = orig.indexOf( "{@" );
			String val ;
			while( index >= 0 ) {
//				buf.append(  orig.substring( start, index ) );		// 5.3.2.0 (2011/02/01)
//				fmtList.add( orig.substring( start, index ) );
				val = orig.substring( start, index );					// 5.3.4.0 (2011/04/01)
				buf.append(  val );
				fmtList.add( val );
				int end = orig.indexOf( '}',index );
				if( end < 0 ) {
					String errMsg = "{@ と } との対応関係がずれています。" + CR
								+ "str=[" + orig + "] : index=" + index ;
					throw new RuntimeException( errMsg );
				}
				String param = orig.substring( index+2,end );
//				if( param.startsWith( "SYS." ) || param.startsWith( "DATE." ) ) {
				if( param.startsWith( "DATE." ) ) {		// 5.3.5.0 (2011/05/01) {&#064;SYS.XXXX} は、廃止
//					val = getDateFormat( param );
					val = getDateFormat( param.substring( 5 ) );	// 5.5.7.2 (2012/10/09) HybsDateUtil を利用時に "DATE." は不要
					clmList.add( null );		// パース下場合は、clmList は、使用しない。
					buf.append( val );
				}
				else {
					clmList.add( param );
					buf.append( "{@" ).append( param ).append( "}" );		// 元のままの文字列を生成
				}
				start = end+1;
				index = orig.indexOf( "{@",start );
			}
//			buf.append(  orig.substring( start, orig.length() ) );		// 5.3.2.0 (2011/02/01)
//			fmtList.add( orig.substring( start, orig.length() ) );
			val = orig.substring( start, orig.length() );				// 5.3.4.0 (2011/04/01)
			buf.append(  val );
			fmtList.add( val );

			original = buf.toString();		// 5.3.2.0 (2011/02/01)
			if( original.indexOf( "{@" ) < 0 ) {
				clms     = null;
				formats  = null;
			}
			else {
				clms	= clmList.toArray( new String[clmList.size()] );
				formats = fmtList.toArray( new String[fmtList.size()] );
			}
		}
	}

	/**
	 * 日付関係の情報を簡易的に取り出す処理を行います。
	 *
	 * これは、{&#064;DATE.XXXX AA BB} 引数処理をおこなうための、サポートメソッドです。
	 * 引数は、"DATE.XXXX AA BB" という状態で受け取ります。
	 * "XXXX" は、日付処理を行うキー文字列で予約語になっています。
	 * ・YMD　　：８文字の日付データ(200X年XX月XX日)を扱います。
	 * ・Y2MD　 ：６文字の日付データ(0X年XX月XX日)を扱います。
	 * ・YM　　 ：６文字の日付データ(200X年XX月)を扱います。
	 * ・HMS　　：６文字の時刻データ(XX時XX分XX秒)を扱います。
	 * ・YMDHMS ：１４文字の日付データ(200X年XX月XX日XX時XX分XX秒)を扱います。
	 * ・EEE　　：曜日をデフォルトロケールで表示します。
	 *
	 * F付きは、フォーマットされた日付を返します。
	 * ・YMDF　 ：１０文字の日付表現(yyyy/MM/dd)を扱います。
	 * ・Y2MDF　：８文字の日付表現(yy/MM/dd)を扱います。
	 * ・YMF　　：７文字の日付表現(yyyy/MM)を扱います。
	 * ・HMSF　 ：８文字の時刻表現(HH:mm:ss)を扱います。
	 * ・YMDHMSF：１９文字の日付表現(yyyy/MM/dd HH:mm:ss)を扱います。
	 * ・MDF　　：５文字の月日表現(MM/dd)を扱います。
	 * ・MDEF　 ：５文字＋曜日の月日表現(MM/dd(EEE))を扱います。
	 * ・MD2F　 ：和暦の月日表現(MM月dd日)を扱います。(5.5.5.2 追加)
	 * ・GYMDF　：和暦の年月日表現(GGGGyyyy年MM月dd日)を扱います。
	 * ・G2YMDF ：和暦の日付表現(Gyyyy/MM/dd)を扱います。
	 * ・GYMF　 ：和暦の年月表現(GGGGyyyy年MM月)を扱います。
	 * ・GYF　　：和暦の年表現(GGGGyyyy)を扱います。
	 *
	 * AA 引数は、基準となる日付を、YYYYMMDD形式で指定します。無指定の場合は、
	 * 処理時刻を基準にした、同一タグ内での同一日付(年月日時分秒)を使用して値を取得します。
	 * 指定できる日付は、必ず、YYYYMMDD形式とし、時分秒は ゼロにリセットされた状態になります。
	 * AA には、数字で始まる(20050701など)実日付と@で始まるパラメータが使用できます。
	 * このパラメータの値は、YYYYMMDD形式の数字か、null(またはゼロストリング)です。nullの
	 * 場合は、なにも指定されていないと判断して、処理時刻を使用します。
	 * 第２引数は、(数字か、@)以外の場合は、省略されたと判断されます。
	 *
	 * BB 引数は、日付についての加減算処理を行います。
	 * 省略すると、なにも加減算処理を行いません。
	 * ・SD ：当月の最初の日付にセットします。(当月１日)
	 * ・ED ：当月の最後の日付にセットします。(当月月末)
	 * ・SW ：日付処理の週初め(月曜日)にセットします。日付は当日より前に移動します。
	 * ・EW ：日付処理の週末(日曜日)にセットします。日付は当日より後ろに移動します。
	 * ・H1 ～ HXXX ：時を指定の分だけ進めます。H1なら１時間後、H24 なら２４時間後(5.5.5.6 (2012/08/31) 追加)
	 * ・D1 ～ DXXX ：日を指定の分だけ進めます。D1なら翌日、D200 なら200日後
	 * ・M1 ～ MXXX ：月を指定の分だけ進めます。M1なら翌月、M6 なら半年後
	 * ・BSD ：先月の最初の日付にセットします。(先月１日)(5.5.5.2 追加)
	 * ・BED ：先月の最後の日付にセットします。(先月月末)(5.5.5.2 追加)
	 * ・ASD ：翌月の最初の日付にセットします。(翌月１日)(5.5.5.2 追加)
	 * ・AED ：翌月の最後の日付にセットします。(翌月月末)(5.5.5.2 追加)
	 *
	 * @og.rev 5.3.4.0 (2011/04/01) 新規追加
	 * @og.rev 5.5.7.2 (2012/10/09) HybsDateUtil を利用するように修正します。
	 * @og.rev 5.5.8.2 (2012/11/09) prmA の判定に、null と ゼロ文字列を判定する。
	 *
	 * @param   value パラメータ(引数は、"DATE.XXXX AA BB" などという状態)
	 *
	 * @return   メッセージ情報
	 */
	private String getDateFormat( final String value ) {
//		Calendar now = (Calendar)rightNow.clone();

		String[] vals = StringUtil.csv2Array( value,' ' );

		String key = vals[0].trim() ;

		String prmA = null;				// 5.5.7.2 (2012/10/09) 引数として渡すので上位で初期化しておく。
		String prmB = null;
		if( vals.length == 3 ) { prmB = vals[2].trim(); }

		if( vals.length > 1 ) {
//			String prmA = vals[1].trim();
			prmA = vals[1].trim();
			if( prmA.startsWith( "@" ) ) {
				prmA = getDateFormat( prmA.substring(1) );
			}

			// prmA の@解析後、８ケタ以下の場合は、コマンドとみなし、prmB にセットし、自身は、null をセットする。
			if( prmA != null && prmA.length() < 8 ) {
				prmB = prmA;
				prmA = null;
			}
// 			if( prmA != null && prmA.length() > 0 ) {
// 				if( prmA.length() == 8 && prmA.charAt(0) >= '0' && prmA.charAt(0) <= '9' ) {
// 					int yy  = Integer.parseInt( prmA.substring( 0,4 ) );
// 					int mm  = Integer.parseInt( prmA.substring( 4,6 ) ) - 1;
// 					int dd  = Integer.parseInt( prmA.substring( 6,8 ) );
// 					now.clear();
// 					now.set( yy,mm,dd );
// 				}
// 				else {
// 					prmB = prmA;
// 				}
// 			}
		}

//		if( prmA == null ) { prmA = RIGHT_NOW; }						// 5.5.7.2 (2012/10/09) 初期値として、設定する。
		if( prmA == null || prmA.isEmpty() ) { prmA = RIGHT_NOW; }		// 5.5.8.2 (2012/11/09) null と ゼロ文字列を判定する。
		return HybsDateUtil.getDateFormat( key,prmA,prmB );				// 5.5.7.2 (2012/10/09) HybsDateUtil を利用する

// 		if( prmB != null ) {
// 			if( "SD".equals( prmB ) ) { now.set( Calendar.DATE,1 ); }
// 			else if( "ED".equals( prmB ) ) { now.set( Calendar.DATE,now.getActualMaximum( Calendar.DATE ) ); }
// 			else if( "SM".equals( prmB ) ) { now.set( Calendar.MONTH,Calendar.JANUARY  ); }
// 			else if( "EM".equals( prmB ) ) { now.set( Calendar.MONTH,Calendar.DECEMBER  ); }
// 			else if( "SW".equals( prmB ) ) {
// 				// 日付型文字列入力データの開始日を月曜日にセットします。
// 				// SUNDAY=1 , MONDAY=2 になります。月曜日との差だけ、前に戻します。
// 				// 指定日が日曜日の場合は、月曜日まで戻します。
// 				int shu = now.get( Calendar.DAY_OF_WEEK ) - Calendar.MONDAY ;
// 
// 				if(      shu > 0 ) { now.add( Calendar.DATE, -shu ); }
// 				else if( shu < 0 ) { now.add( Calendar.DATE, -6 );   }	// 日曜日の処理
// 
// 			}
// 			else if( "EW".equals( prmB ) ) {
// 				// 日付型文字列入力データの終了日を日曜日にセットします。
// 				// SUNDAY=1 , MONDAY=2 になります。日曜日になるように、先に進めます。
// 				int shu = now.get( Calendar.DAY_OF_WEEK ) ;
// 
// 				if( shu != Calendar.SUNDAY ) { now.add( Calendar.DATE, 8-shu ); }
// 			}
// 			else if( prmB.startsWith( "D" ) && prmB.length() > 1 ) {
// 				int day = Integer.parseInt( prmB.substring( 1 ) );
// 				now.add( Calendar.DATE, day );
// 			}
// 			else if( prmB.startsWith( "M" ) && prmB.length() > 1 ) {
// 				int month = Integer.parseInt( prmB.substring( 1 ) );
// 				now.add( Calendar.MONTH , month );
// 			}
// 			else {
// 				String errMsg = "日付変数パラメータに、不正な値が指定されました。以下の中から指定しなおしてください。"
// 							+ "指定可能：[SD,ED,SM,EM,SW,EW,D1～DXXX,M1～MXXX]"
// 							+ " value=[" + prmB + "]" ;
// 				throw new RuntimeException( errMsg );
// 			}
// 		}
// 
// 		String format = DATE_FORMAT.get( key );
// 		if( format == null ) {
// 			String errMsg = "日付変数キーに、不正な値が指定されました。以下の中から指定しなおしてください。"
// 						+ "指定可能：[" + DATE_FORMAT.keySet().toString() + "] , "
// 						+ " key=[" + value + "]" ;
// 			throw new RuntimeException( errMsg );
// 		}
// 
// 		DateFormat formatter = new SimpleDateFormat( format,Locale.JAPAN );
// 
// 		return formatter.format( now.getTime() );
	}

	/**
	 *  {&#064;XXXX} の特殊文字を含む文字列を、置き換えます。
	 * 対象外の文字列は、そのまま、残されます。
	 *
	 * @og.rev 5.3.4.0 (2011/04/01) 判定方法 修正
	 *
	 * @param	entry	置換文字列のキーと値のペアを管理しているEntryオブジェクトの配列
	 *
	 * @return	置換後の文字列
	 */
	public String replace( final HybsEntry[] entry ) {
//		if( orginal == null ) { return null; }
//		int index = orginal.indexOf( "{@" );
//		if( index < 0 ) { return orginal; }
//		if( formats == null || clms == null ) { return original; }
		if( formats == null ) { return original; }		// 5.3.4.0 (2011/04/01) 判定方法 修正
		if( entry == null || entry.length == 0 ) { return original; }

		// HybsEntry[] データを、Mapにマッピングします。
		Map<String, String> sysMap = new HashMap<String, String>();
//		if( entry != null ) {
			int size = entry.length;
			for( int i=0; i<size; i++ ) {
				sysMap.put( entry[i].getKey(),entry[i].getValue() );
			}
//		}
		return replace( sysMap );
	}

	/**
	 *  {&#064;XXXX} の特殊文字を含む文字列を、置き換えます。
	 * 対象外の文字列は、そのまま、残されます。
	 *
	 * @param  map  置換文字列のキーと値のペアを管理しているMapオブジェクト
	 *
	 * @return	置換後の文字列
	 */
	public String replace( final Map<String,String> map ) {
//		if( formats == null || clms == null ) { return original; }
		if( formats == null ) { return original; }		// 5.3.4.0 (2011/04/01) 判定方法 修正
//		if( map == null || map.size() == 0 ) { return original; }
		if( map == null || map.isEmpty() ) { return original; }

		StringBuilder sb = new StringBuilder();
		for( int i=0; i<formats.length; i++ ) {
			sb.append( formats[i] );
			if( i < clms.length && clms[i] != null ) {		// 5.3.4.0 (2011/04/01) nullチェック追加
				sb.append(  StringUtil.nval( map.get( clms[i] ), "" ) );
			}
		}

		return sb.toString();
	}

	/**
	 * フォーマットをパースした結果から、カラム一覧を配列形式で返します。
	 *
	 * @og.rev 5.1.7.0 (2010/06/01) 新規作成
	 *
	 * @return カラム配列
	 */
	public String[] getColumns() {
		if( clms == null ) { return new String[0]; }
		return clms.clone();
	}

	/**
	 * フォーマットをパースした結果から、フォーマット一覧を配列形式で返します。
	 *
	 * @og.rev 5.1.7.0 (2010/06/01) 新規作成
	 *
	 * @return フォーマット配列
	 */
	public String[] getFormats() {
		if( formats == null ) { return new String[0]; }
		return formats.clone();
	}
}
