/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.develop;

import java.util.List;
import java.util.Map;

import org.opengion.hayabusa.develop.AbstractJspCreate;
import org.opengion.hayabusa.develop.JspConvertEntity;
import org.opengion.fukurou.xml.OGElement;
import org.opengion.fukurou.xml.OGNode;

/**
 * query.jspの&lt;og:select&gt;タグを利用した ORDER BYパラメータを作成します。
 *
 * 検索条件のプルダウンは、通常、queryButtonタグ内に記載します。
 * ただし、場合によっては、表に出すこともある為、name="ORDER_BY" で置き換えを実行します。
 *
 * ●使用例
 *      <og:select name="ORDER_BY">
 *          <option value = column.getRemarks() lbls = column.getRemarks() selected = "selected" />
 *          <option value = column.getRemarks() lbls = column.getRemarks() />
 *             ・・・・
 *      </og:select>
 *
 * @author Takeshi.Takada
 *
 */
public class JspCreate_ORDER_BY extends AbstractJspCreate {
	private List<JspConvertEntity> ORDER_ROWS ;
	private boolean IS_NULL ;

	/**
	 * 初期化メソッド
	 *
	 * 内部で使用する JspConvertEntity の リスト のマップを受け取り、初期化を行います。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、名前空間指定無しに変更します。
	 *
	 * @param	master	JspConvertEntityのリストのマップ
	 */
	@Override
	protected void init( final Map<String,List<JspConvertEntity>> master ) {
		ORDER_ROWS = master.get("ORDER");
//		IS_NULL = (ORDER_ROWS == null || ORDER_ROWS.isEmpty() );
		IS_NULL = !isNotEmpty( ORDER_ROWS );
//		KEY  = "og:select";
		KEY  = ":select";		// 5.2.1.0 (2010/10/01) 名前空間指定無し
		NAME = "query";
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
	@Override
	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
		if( IS_NULL ) { return ""; }

		// name="ORDER_BY" 以外は、そのまま返す。
		if( !"ORDER_BY".equalsIgnoreCase( ele.getVal( "name" ) ) ) {
			return ele.toString();
		}

		String ns = (nameSpace.length() == 0) ? "" : nameSpace + ":" ;		// 名前空間

		ele.clearNode();	// 一旦すべてのノードを削除します。

		boolean isFirst = true;
		for ( JspConvertEntity column : ORDER_ROWS ){
			OGElement opt = new OGElement( ns + "option" );
			String remks = column.getRemarks();			// 属性。ここに、A1.AA,A1.BB,A1.CC,B1.DD desc などのカラム列が入る。
			String[] clms = remks.split( "," );			// カンマで分解
			StringBuilder buf = new StringBuilder();	// ラベル用に、別名を取り除く
			for( int i=0; i<clms.length; i++ ) {
				if( i>0 ) { buf.append( ',' ); }		// 最初以外は、カンマを追加していく。

				String clm = clms[i].trim();
				int idx = clm.indexOf( '.' );
				if( idx >= 0 ) { buf.append( clm.substring( idx+1 ) ); }
				else           { buf.append( clm ); }
			}

//			opt.addAttr( "value" , column.getRemarks() );
//			opt.addAttr( "lbls"  , column.getRemarks() );
			opt.addAttr( "value" , remks  );
			opt.addAttr( "lbls"  , buf.toString() );
			if ( isFirst ){
				opt.addAttr( "selected"  , "selected" );
				isFirst = false;
			}
			ele.addNode( opt );
		}

		return ele.getText( 1 );
	}

	/**
	 * JSPに出力するタグの内容を作成します。
	 * 引数より作成前のタグの属性内容を確認するする事が出来ます。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) メソッドの引数を、OGAttributes から OGElement に変更します。
	 * @og.rev 5.2.1.0 (2010/10/01) 名前空間を、og 決め打ちから、引数を使用するように変更します。
	 *
	 * @param ele OGElementエレメントオブジェクト
	 * @param	nameSpace	このドキュメントのnameSpace( og とか mis とか )
	 *
	 * @return	変換された文字列
	 * @throws Throwable 変換時のエラー
	 */
//	@Override
//	protected String execute( final OGElement ele , final String nameSpace )  throws Throwable {
//		if( IS_NULL ) { return ""; }
//
//		String ns = (nameSpace.length() == 0) ? "" : nameSpace + ":" ;	// 5.2.1.0 (2010/10/01) 名前空間
//
//		// TODO Auto-generated method stub
//		//書き出す文字列を作成開始。
//		StringBuilder sbTub = new StringBuilder();
//
//		//JOIN情報から<og:select>タグの検索句を生成する準備をします。
////		sbTub.append( "\t\t<og:select name=\"ORDER_BY\" lbl=\"ORDER_BY\">").append( CR );
//		sbTub.append( "\t\t<" ).append( ns ).append( "select name=\"ORDER_BY\" lbl=\"ORDER_BY\">").append( CR );
//		boolean isFirst = true;
//
//		for ( JspConvertEntity column : ORDER_ROWS ){
////			sbTub.append( "\t\t\t<og:option value=\"" );
//			sbTub.append( "\t\t\t<" ).append( ns ).append( "option value=\"" );
//			sbTub.append( column.getRemarks() );
//			sbTub.append( "\"\t\t" );
//			sbTub.append( " lbls=\"");
//			sbTub.append( column.getRemarks() );
//			sbTub.append( "\" ");
//			if ( isFirst ){
//				sbTub.append( "selected=\"selected\"");
//				isFirst = false;
//			}
//			sbTub.append( " />" ).append( CR );
//		}
////		sbTub.append( "\t\t</og:select>").append( CR );
//		sbTub.append( "\t\t</" ).append( ns ).append( "select>").append( CR );
//
//		return sbTub.toString();
//	}
}
