/*********************/
/* UTILITY FUNCTIONS */
/*********************/
// day of week of month's first day
function getFirstDay(theYear, theMonth){
	var firstDate = new Date(theYear,theMonth,1);
	return firstDate.getDay();
}

// number of days in the month
function getMonthLen(theYear, theMonth) {
	var nextMonth = new Date(theYear, theMonth + 1, 1);
	nextMonth.setHours(nextMonth.getHours() - 3);
	return nextMonth.getDate();
}

/************************************************************/
/* DRAW CALENDAR CONTENTS									*/
/*  3.8.5.1 (2006/04/28) today parameter add				*/
/*  5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加	*/
/************************************************************/
// clear and re-populate table based on form's selections
// function populateTable(form,today) {
function populateTable(form,today,isFmt) {
	var theMonth , theYear , ymd , firstDay , howMany , header , tmpMonth , dayCounter , tBody , newR , newC , done , i ;

	theMonth = form.chooseMonth.selectedIndex;
	theYear = parseInt(form.chooseYear.options[form.chooseYear.selectedIndex].text,10);
//	var today = new Date();
	//   3.8.5.1 (2006/04/28) today parameter get value
	if( today == null ) {
//		var ymd = window.opener.document.getElementById( window.name ).value;
		ymd = window.dialogArguments;
		if( isFmt ) { ymd = ymd.replace(/\//g,''); }	// 5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加
		today = new Date( ymd.substring(0,4),ymd.substring(4,6)-1,ymd.substring(6,8));
	}

	// pick up date form choices
	// initialize date-dependent variables
	firstDay = getFirstDay(theYear, theMonth);
	howMany  = getMonthLen(theYear, theMonth);

	// fill in month/year in table header
//	document.getElementById("tableHeader").innerHTML =
//		form.chooseMonth.options[theMonth].text + " " + theYear ;

//	document.getElementById("tableHeader").innerHTML = theYear + " / " + (theMonth+1);
	// 4.1.1.2 (2008/03/07) カレンダーポップアップに先月、来月に移動のボタンを追加。
	header = "";
	if( ( form.chooseYear.selectedIndex != 0 ) || 
		( form.chooseMonth.selectedIndex != 0 ) ) {
		header = "<input type='button' value='<<' onClick='changeMonth( " + theYear + "," + ( theMonth + 1 ) + "," + today.getDate() + ",-1 );' />  ";
	}
	tmpMonth = "0" + ( theMonth + 1 );
	header = header + theYear + " / " + tmpMonth.slice( tmpMonth.length - 2 );
	if( ( form.chooseYear.selectedIndex != ( form.chooseYear.length - 1 ) ) || 
		( form.chooseMonth.selectedIndex != ( form.chooseMonth.length - 1 ) ) ) {
		header = header + "  <input type='button' value='>>' onClick='changeMonth( " + theYear + "," + ( theMonth + 1 ) + "," + today.getDate() + ",1 );' />";
	}
	document.getElementById("tableHeader").innerHTML =  header;

	// initialize vars for table creation
	dayCounter = 1;
	tBody = document.getElementById("tableBody");
	// clear any existing rows
	while (tBody.rows.length > 0) {
		tBody.deleteRow(0);
	}
	done=false;
	while (!done) {
		// create new row at end
		newR = tBody.insertRow(tBody.rows.length);
		if (newR) {
			for ( i = 0; i < 7; i++) {
				// create new cell at end of row
				newC = newR.insertCell(newR.cells.length);
				if (tBody.rows.length == 1 && i < firstDay) {
					// empty boxes before first day
					newC.innerHTML = "&nbsp;";
					continue;
				}
				if (dayCounter == howMany) {
					// no more rows after this one
					done = true;
				}
				// plug in link/date (or empty for boxes after last day)
				if (dayCounter <= howMany) {
					if (today != null && today.getFullYear() == theYear &&
						today.getMonth() == theMonth &&
						today.getDate() == dayCounter) {
						newC.id = "today";
					}
					newC.innerHTML = "<a href='#'onclick='chooseDate(" +
//						dayCounter + "," + theMonth + "," + theYear + 
						dayCounter + "," + theMonth + "," + theYear + "," + isFmt +		// 5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加
						"); return false;'>" + dayCounter + "</a>";
					 dayCounter++;
			   } else {
					newC.innerHTML = "&nbsp;";
				}
			}
		} else {
			done = true;
		}
	}
	//3.8.1.3 (2006/01/30) Set Window Size
	setWinSize();
}

/************************************************/
/*  INITIALIZATIONS								*/
/*  3.8.5.1 (2006/04/28) today parameter add	*/
/************************************************/
// create dynamic list of year choices
function fillYears( today ) {
	var thisYear , yearChooser , i ;
//	var today = new Date();

	thisYear = today.getFullYear();
	yearChooser = document.dateChooser.chooseYear;

	for ( i = thisYear-1; i < thisYear + 5; i++) {
		yearChooser.options[yearChooser.options.length] = new Option(i, i);
	}
	setCurrMonth(today);
}

// set month choice to current month
function setCurrMonth(today) {
	document.dateChooser.chooseYear.selectedIndex  = 1;		// The second item
	document.dateChooser.chooseMonth.selectedIndex = today.getMonth();
}

/************************************************************/
/*   PROCESS CHOICE											*/
/*  5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加	*/
/************************************************************/
// function chooseDate(date, month, year) {
function chooseDate(date, month, year,isFmt ) {
	var sYear , sMonth , sDate ;

	sYear = year.toString();
	sMonth = (month>=9) ? (month + 1).toString() : "0" + (month + 1).toString() ;
	sDate =  (date>=10) ? date.toString() : "0" + date.toString();

//	window.opener.document.getElementById( window.name ).value = sYear + sMonth + sDate;

	// 5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加
//	window.returnValue = sYear + sMonth + sDate;
	if( isFmt ) { window.returnValue = sYear + "/" + sMonth + "/" + sDate; }
	else        { window.returnValue = sYear + sMonth + sDate; }
	window.close();
}

function initCalendar() {
	var ymd , today , calObj ;
	//   3.8.5.1 (2006/04/28) today parameter get value
//	var ymd = window.opener.document.getElementById( window.name ).value;
	ymd = window.dialogArguments;

	// 5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加
	var isFmt = (ymd.indexOf( "/" ) >= 0);

	if( isFmt ) { ymd = ymd.replace(/\//g,''); }

//	var today ;
	if( ymd == null || ymd.length != 8 ) {
		today = new Date();
	}
	else {
		today = new Date( ymd.substring(0,4),ymd.substring(4,6)-1,ymd.substring(6,8));
	}
	window.returnValue = ymd;
	fillYears(today);
//	populateTable(document.dateChooser,today);
	populateTable(document.dateChooser,today,isFmt);	// 5.6.3.4 (2013/04/26) "/" 付の日付欄の場合の処理を追加
	calObj = document.getElementById("calendar") ;
	calObj.style.visibility = "visible";

//	window.resizeTo( calObj.offsetWidth,calObj.offsetHeight );

	window.focus();
}

function setWinSize() {
	var calObj , ver , adjusted_height , adjusted_width ;

	calObj = document.getElementById("calendarTable") ;

	if( calObj ) {
		adjusted_height = 0;
		adjusted_width = 0;
		if(document.all) { // IE
			ver = getInternetExplorerVersion();
			if ( ver < 7.0 ) {
				adjusted_width = 6 ;
				adjusted_height = 52 ;
			}

		//if( document.readyState=="complete" ) {
			window.dialogWidth = calObj.offsetWidth + adjusted_width + "px"; 
			window.dialogHeight = calObj.offsetHeight + adjusted_height + "px";
		//}
		}
		else { // Firefox
			do {
				adjusted_width  = calObj.offsetWidth - (document.documentElement["clientWidth" ] || document.body["clientWidth" ]);
				adjusted_height = calObj.offsetHeight - (document.documentElement["clientHeight"] || document.body["clientHeight"]);
				window.resizeBy(adjusted_width, adjusted_height);
			} while(adjusted_width > 0 || adjusted_width > 0);
		}
	}
}

/****************************************/
/* 4.1.1.2 (2008/03/07) 新規追加.		*/
/* year : 年							*/
/* month: 月							*/
/* day  : 日							*/
/* diff : 先月（-1）、来月（1）			*/
/****************************************/
function changeMonth( year,month,day,diff ) {
	var newMonth , newYear , newDate ;

	newMonth = Number( month ) + diff;
	newYear = year;
	if ( newMonth == 0 ) {
		newMonth = 12;
		newYear = Number( year ) - 1;
		document.dateChooser.chooseYear.selectedIndex = document.dateChooser.chooseYear.selectedIndex - 1;
	}
	else if ( newMonth == 13 ) {
		newMonth = 1;
		newYear = Number( year ) + 1;
		document.dateChooser.chooseYear.selectedIndex = document.dateChooser.chooseYear.selectedIndex + 1;
	}

	newDate = new Date( newYear,newMonth-1, day );
	document.dateChooser.chooseMonth.selectedIndex = newMonth - 1;
	populateTable( document.dateChooser, newDate );
}
