/************************************************************************************/
/* 旧 focusHilight.js の内容を移植 5.2.1.0 (2010/10/01)                             */
/*                                                                                  */
/* フォーカスが当っているアクティブフィールドの色を変更します                       */
/* 色はfocusFieldクラスで指定しています                                             */
/*                                                                                  */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離・イベントにJQuery利用                */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* @og.rev 5.5.9.0 (2010/12/03) IE9対応。selectはstyleを直接変更する                */
/* @og.rev 5.6.4.2 (2013/05/17) エラー表示の alertメッセージ修正                    */
/* Revision: $Id$                                                                   */
/************************************************************************************/

var orgFldCls = null;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusin( function(){ doFocus2( this ); } );
//	$('textarea,select,input[type="text"]').focusout( function(){ doBlur2( this ); } );
	if(USE_FOCUS_HILIGHT){ //5.4.5.0 flag add
		setEvent( "textarea,select,input[type=\"text\"]", "focusin", function(){ doFocus2( this ); } );
		setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ doBlur2( this ); } );
	}
});

function doFocus2( obj ) {
	// 入力中のフォームの色
	if( obj != null  ) { 
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 4.3.2.2 (2008/09/16) 入力中のフォームの色をcustom.cssに指定するように変更
			// 5.5.9.0 (2012/12/03) selectタグの場合は直接背景色変更 
			if( obj.tagName == "SELECT" ){ // 5.5.9.1(2012/12/07) 小文字を大文字に
				obj.orgBgColor    = obj.style.backgroundColor;
				obj.style.backgroundColor = '#ffcccc';
			}
			else{
				orgFldCls    = obj.className;
				obj.className = 'focusField ' + orgFldCls;
			}
		}
	}
}

function doBlur2( obj ) {
	if( obj != null ) {
		if( obj.className == null || obj.className.indexOf( "must" ) < 0 ) {
			// 元のフォームの色
			// 5.5.9.0 (2012/12/03) selectタグの場合は直接背景色変更
			if( obj.tagName == "SELECT" ){
				obj.style.backgroundColor = obj.orgBgColor;
			}
			else{
				if( orgFldCls != null ) {
					obj.className = orgFldCls;
				}
				else {
					obj.className = 'notFocusField';
				}
			}
		}
	}
}

/* 旧関数を呼び出した場合はアラートを出す（旧の*_inof.jsp対策） */
oldDoFocusFlag = true;
function doFocus( obj ) {
	if(oldDoFocusFlag){
		oldDoFocusFlag = false;
//		setTimeout(alert("custom/query_info.jsp及びcustom/result_info.jspで次の部分を削除して下さい。\n<script>タグ（ヘッダ固定とフォーカス）、BODYのonLoadとoncontextmenu属性"),100);
		setTimeout(alert("Old Script Error!!\ncustom/query_info.jsp,custom/result_info.jsp Please delete the following part.\n<script>Tag(Header fix and Focus) , BODY onLoad and oncontextmenu Attribute"),100);
	}
}
/*エラー対策の空関数 */
function doBlur( obj ) {}

/************************************************************************************/
/* 旧 autoConvert.js の内容を移植 5.2.1.0 (2010/10/01)                              */
/*                                                                                  */
/* 入力値自動変換機能 4.3.0.0 (2008/07/25) 追加                                     */
/* dbType XL及びXUについて、大文字・小文字の自動変換を行います                      */
/*                                                                                  */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)                      */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* Revision: $Id$                                                                   */
/************************************************************************************/
$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ convert( this ); } );
	setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ convert( this ); } );
});

function convert( obj ) {
	var val , cls ;

	val = obj.value;
	cls = obj.className;
	if( val != null && cls != null ) {
		if( cls.match( /XL/ ) && !(cls.match( /XLU/ )) ) {
			obj.value = val.toLowerCase();
		}
		else if( cls.match( /XU/ ) && !(cls.match( /XUL/ )) ) {
			obj.value = val.toUpperCase();
		}
	}
	return true;
}

/************************************************************************************/
/* 旧 eventColumn.js の内容を移植 5.2.1.0 (2010/10/01)                              */
/*                                                                                  */
/* 動的プルダウンを実行するためのJavaScriptです。                                   */
/*                                                                                  */
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる        */
/* Revision: $Id$                                                                   */
/************************************************************************************/
var colMap;
var notFireCols;
var jH_evElm;

$(function(){
	if( ! ( typeof( EC_NAME ) == "undefined" ) ) {
		// 初期化処理だけは、予め要素オブジェクトを取得しておき、ここから子カラムを取得する。
		jH_evElm = $( ".h_evElm" );

		makeColMapping();

		setEvent( "textarea,select,input[type=\"text\"]", "change", function(){ makeColumn( this ); }, ".h_evCol", true, addEvColCls );
		setEvent( "input[type=checkbox],input[type=radio]", "click", function(){ makeColumn( this ); }, ".h_evCol", true );
	}
});

/**
 * 親カラムをキーにしたイベントカラムの一覧を作成します。
 *
 * 親カラムを連想配列のキーとして、子カラムの一覧を配列として保持します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
**/
function makeColMapping() {
	var i , j , evCols , evc , cCols ;

	if( colMap ){ return; }

	colMap = new Object();
	for(  i=0; i<EC_EVCOL.length; i++ ) {
		evCols = EC_EVCOL[i].split(",");
		for( j=0; j<evCols.length; j++ ) {
			evc = evCols[j];
			if( evc.charAt(0) == "_" ) {
				evc = evc.substring(1);
				if( notFireCols ) { notFireCols += ","; }
				notFireCols += evc;
			}
			cCols = colMap[evc];
			if( !cCols ) { cCols = new Array(); }
			cCols[cCols.length] = EC_NAME[i];
			colMap[evc] = cCols;
		}
	}
}

/**
 * 親カラムに対してクラスを付加します。
 *
 * @og.rev 5.2.0.0 (2010/09/01) 新規作成
 *
**/
function addEvColCls() {
	for( var evCol in colMap ) {
		$("#"+evCol+",[id^="+evCol+"__]").addClass("h_evCol");
	}
}

/**
 * イベントカラムが設定されたタグ(spanタグ)を検索し、親カラムにイベントを登録します。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 新規作成(動的プルダウン実装見直し)
 *
 * @param evCol	イベントが発生した親カラムのオブジェクト
**/
function makeColumn( evCol ) {
	var jEvCol , evColId , evColName , cColNameArr , i , suffix , cid , cname , jTag , writable ;

	if( jH_evElm && isEndInitEvent() ) { jH_evElm = null; }

	jEvCol = $( evCol );
	evColId = jEvCol.attr("id");
	evColName = evColId.split("__")[0];

	cColNameArr = colMap[evColName];
	if( !cColNameArr ) { return; }

	// イベントカラムでカラム名の頭文字が'_'で始まっている場合、初回イベント発行を行わない。
	if( !isEndInitEvent() && notFireCols && notFireCols.indexOf( evColName ) >= 0 ) { return; }

	for( i=0; i<cColNameArr.length; i++ ) {
		suffix = ( evColId == evColName ? "" : "__" + evColId.split("__")[1] );
		cid = cColNameArr[i]+suffix;
		cname = cid.split("__")[0];
		jTag = isEndInitEvent() ? $( ".h_evElm[h_evCid="+cid+"]" ) : jH_evElm.filter( "[h_evCid="+cid+"]" );
		writable = jTag.attr("h_evWrtbl");
		eventColumn( jEvCol, jTag, cid, cname, suffix, writable );
	}
}

/**
 * Ajax動的カラム変更用の共通JavaScript
 * 
 * カラムにeventColumnをセットした時に親側にID指定でChangeイベントとして登録されます。
 * ※イベント処理用のJSP用に送られるパラメーターに関しては、jsp/common/eventColumnMaker.jspの
 *   コメントを参照して下さい。
 *
 * @og.rev 5.1.7.0 (2010/06/01) 動的プルダウン実装見直し
 * @og.rev 5.5.4.0 (2012/07/02) suffixが存在すればSLABEL利用を標準にする。eventCallbackの動作追加
 * @og.rev 5.6.2.0 (2013/03/01) jQueryのval()がリセット後のプルダウンから取得できないのでvlaueで取る
 * @og.rev 5.6.4.2 (2013/05/17) エラー表示の alertメッセージに、発生元が分かるように、 cname を追加します。
 *
 * @param jEvCol	イベントが発生した親カラムのjQueryオブジェクト
 * @param jTag		置き換え要素をラップしたspanタグのjQueryオブジェクト
 * @param cid		変更対象の子要素(inputタグなど)のID
 * @param cname		子のカラム名
 * @param suffix	__ + 行番号(一覧表示の場合のみ)
 * @param writable	書き込み可能かどうか
**/
function eventColumn( jEvCol, jTag, cid, cname, suffix, writable ){
	var evVal , url , param , _pos1 , _pos2 , _repClm, _rep, _clm , noVal , columnFocus , jCol , val , renderer , editor , ATTRS , optAttrs , i , optAtt , vtype , isAdd ;
	var callback; // 5.5.4.0 (2012/07/02)
	
	if( !jTag || jTag.length == 0 ) {
//		alert( "[SYSTEM_ERROR] : イベントカラムで置き換え対象の要素が存在しません" );
		alert( "[SYSTEM_ERROR] : jTag is null. The element of the replacement object doesn't exist. [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}

//	if( cid == null || cid == "" || cname == null || cname == "" ) {
//		alert( "[SYSTEM_ERROR] : 子要素のIDまたはNAMEがセットされていません" );
//		return;
//	}

	if( !isEndInitEvent() ) {
//		evVal = jEvCol.val();
		evVal = jEvCol.get(0).value; //2013/03/01
		if( !evVal || evVal == null || evVal == "" ) { return; }
	}

	try {
		url = eval( "EC_" + cname + "_URL" );
	}
	catch( e ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。(変数未定義)" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified. (variable undefinition). [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}
	if( !url || url == "" ) {
//		alert( "[SYSTEM_ERROR] : イベントを処理するURLが指定されていません。" );
		alert( "[SYSTEM_ERROR] : URL that processes the event is not specified. [" + cname + "]" );		// 5.6.4.2 (2013/05/17) cname 追加
		return;
	}

	// SQL文をパースして{@xxx}をxxxのvalue値に変更する。一覧での利用では同一行のカラムになる。
	//（リクエスト変数はテキストボックスで一度受ける必要がある）
	// 又、パースして得られたvalue値をJSPのリクエスト変数としてURLの後ろに付ける
	param = "";
	try { param = ( writable ? eval( "EC_" + cname + "_EDITPARAM" ) : eval( "EC_" + cname + "_RENDPARAM" ) ); } catch( e ) {}
	if( param != null && param != "" ) {
		url += "?";
		_pos1 = 0;
		_pos2 = 0;
		while( (_pos1 = param.indexOf("{@",_pos2)) != -1){
			_pos2 = param.indexOf("}",_pos1);
			_clm = param.substring(_pos1+2,_pos2);
			if( _clm.indexOf(".") < 0 ) {
				_repClm = "{@"+_clm+"}";
//				_rep = suffix == "" ? $('#'+_clm).val() : $('#'+_clm+suffix).val();
				_rep = suffix == "" ? $('#'+_clm).get(0).value : $('#'+_clm+suffix).get(0).value;  // 2013/03/01
				_rep = ( _rep == null ? "" : _rep );
				param = param.replace(_repClm,_rep);
				url += _clm + "=" +  encodeURIComponent(_rep) +"&";
			}
			_pos2 = _pos1+1; // 4.3.6.2 (2009/04/15)
		}
	}

	// 子がSelectタグの場合、最上部に空のoptionが存在すればEC_NOVALUEをtrueで送る
	noVal = function(){
		_firstOption = jCol.children('option').get(0);
		if( _firstOption == null || _firstOption.value != "" ){ return false; }
		return true;
	};

	// 4.3.6.5 (2009/05/08) must,mustAnyを引数でJSPに送る。
//	var mustOrMustAny = function(){
//		var _haveClasses = jCol.attr("class");
//		if( _haveClasses && _haveClasses.indexOf("must") >= 0 ){
//			if( _haveClasses.indexOf("mustAny") >= 0 )	{ return "mustAny"; }
//			else										{ return "must"; }
//			return "";
//		}
//	}

	columnFocus = function() {
		jCol.attr("isfocus","true");
	};

//	var jCol;
	if( cid != null && cid != "" ) {
		jCol = jTag.find( "#"+cid );
	}
	else {
		jCol = new Array(0);
	}

	if( jCol.length > 0 && isEndInitEvent() ) {
		jCol.bind("focus",columnFocus);
	}

	val = "";
	if( jCol.length > 0 ) {
		if( isEndInitEvent() )	{ val = ( jCol.val() == null ? "" : jCol.val() ); }
		else					{ val = ( jTag.attr( "h_evVal" ) == null ? "" : jTag.attr( "h_evVal" ) ); }
	}

	renderer = "";
	try { renderer = eval( "EC_" + cname + "_RENDERER" ); } catch( e ) {}

	editor = "";
	try { editor = eval( "EC_" + cname + "_EDITOR" ); } catch( e ) {}

	// 5.2.0.0 (2010/09/01) 属性値が正しく引き継がれないバグを修正
	ATTRS = [ "title", "style", "tabindex", "readonly", "disabled"
				, "onClick", "onChange", "onBlur", "onFocus", "ondblClick", "onMouseDown", "onMouseUp"
				, "onMouseMove", "onMouseOut", "onMouseOver", "onSelect", "onKeydown", "onKeypress", "onKeyup"
				, "eventCallBack" // 5.5.4.0 (2012/07/02)
			 ];
	optAttrs = "";
	if( jCol.length > 0 ) {
		for( i=0; i<ATTRS.length; i++ ) {
			optAtt = jCol.attr(ATTRS[i]);
			if( optAtt != null ) {
				vtype = typeof( optAtt );
				isAdd = false;
				if( vtype == "function" ) {
					optAtt = optAtt.toString();
					isAdd = optAtt.length > 0 ? true : false;
					// 関数の場合は、文字列表現として"function anonymous(){...}"という関数定義が返るため、
					// ( FUNCTION )(); 形式で関数を実行するように変更
					optAtt = "(" + optAtt + ")()";
				}
				else if( vtype == "boolean" ) {
					isAdd = optAtt;
				}
				else {
					isAdd = optAtt.length > 0 ? true : false;
				}

				if( isAdd ) {
					optAttrs += ATTRS[i] + "='" + optAtt + "' ";
				}
			}
		}
	}

	// JSPを呼び出して処理する
	$.ajax({
		url: url,
		data: {
			"EC_CID"		: ( cid == null ? "" : cid ),
			"EC_CNAME"		: ( cname == null ? "" : cname ),
			"EC_RENDERER"	:renderer,
			"EC_EDITOR"		: editor,
			"EC_PARAM"		: param,
			"EC_SQL"		: param,
			"EC_WRITABLE"	: ( writable == null ? "" : writable ),
			"EC_CVALUE"		: val,
			"EC_NOVALUE"	: ( jCol.length == 0 ? "" : noVal() ),
//			"EC_MUST"		: ( jCol.length == 0 ? "" : mustOrMustAny() ),
			"EC_CLASS"		: ( jCol.length == 0 ? "" : jCol.attr("class") ),
			"EC_SIZE"		: ( jCol.length == 0 ? "" : jCol.attr("size") ),
			"EC_MAXLENGTH"	: ( jCol.length == 0 ? "" : jCol.attr("maxlength") ),
			"EC_OPTATTRS"	: optAttrs,
			"EC_PNAME"		: jEvCol.attr("id") == null ? "" : jEvCol.attr("id").split("__")[0],
//			"EC_PVALUE"		: jEvCol.val() == null ? "" : jEvCol.val(),
			"EC_PVALUE"		: jEvCol.get(0).value == null ? "" : jEvCol.get(0).value, // 5.6.2.0 (2013/03/01)
			"EC_USESLBL"	: (suffix == null || suffix == "") ? "false" : "true" // 5.5.4.0 (2012/07/02)
		},
		type: 'POST',
		dataType: 'html',
		async : isEndInitEvent(),
		error: function(r,s,e){
			// 5.6.4.2 (2013/05/17) 紙芝居作成時は、url が存在しないエラーが発生するので、無視する。(htm呼び出し時は無視)
			if( url.indexOf( ".htm" ) < 0 ) {
				alert('EventColumnError:'+r+':'+s+':'+e+':'+cname);
			}
		},
		success: function(data,status){
			var jNewCol = $(data);

			if( jCol.length > 0 ) {
				if( isEndInitEvent() ) {
					jCol.unbind("focus",columnFocus);
				}
				bindOldEvents( jNewCol.get(0), jQuery.data( jCol.clone(true).get(0),"events" ) );
			}

			jTag.empty().append( jNewCol );

			if( jCol.length > 0 ) {
				jTag.find("input,select,textarea").attr( "name", cid ).attr( "id", cid );

				if( isEndInitEvent() ) {
					// 置き換え先の要素にフォーカスが当たっていた場合は、フォーカスを復活
					if( jCol.attr("isfocus") ) {
//						jNewCol.focus();
						jNewCol.get(0).focus();
						// IEの場合、置き換え先の要素がテキストボックスの場合は、もう１度フォーカスする必要がある。
						if( $.browser.msie ) {
							jNewCol.get(0).focus();
						}
					}
				}
				// 初回読み込み時に置き換えられた要素はchangeイベントを発行
				if( !isEndInitEvent() ) {
					jNewCol.change();
				}
				// 5.5.4.0 (2012/07/02) callBack処理
				// 置き換え先にeventCallback属性が存在した場合にevalして関数評価した上で、子idと値を引数に渡す。
				if( jCol.attr("eventCallback") ){
					callback = function(){ eval(jCol.attr("eventCallback") + "(arguments);") };
//					callback(cid,jNewCol.val(),jCol.val());
					callback(cid,jNewCol.val(),jCol.get(0).value); // 2013/03/01
				}
			}

			// ヘッダー固定再計算
			if( suffix != null && suffix != "" ) {
				if( isEndInitEvent() ) {
					$('table#viewTable').resizeView();
				}
			}
		}
	});
}

function bindOldEvents( newCol, oldEvents ) {
	var type , handler ;
	for ( type in oldEvents ) {
		for ( handler in oldEvents[type] ) {
			jQuery.event.add( newCol, type, oldEvents[type][handler], oldEvents[type][handler].data );
		}
	}
}

/********************************************************************************************/
/* 旧 realTimeCheck.js の内容を移植 5.2.1.0 (2010/10/01)                                    */
/*                                                                                          */
/* 入力欄の簡易チェック(リアルタイム)                                                       */
/* DBTYPE に応じた簡易チェックを行います。あくまで簡易的なチェックです。                    */
/* 大文字小文字などは、JavaScriptで変換できる為、チェックは行いません。                     */
/*                                                                                          */
/* @og.rev 4.3.3.0 (2008/10/01) サーバーサイドのリアルタイムチェック対応                    */
/* @og.rev 4.3.5.0 (2009/02/01) JavaScript分離(inputFocusより)								*/
/* @og.rev 4.3.6.6 (2009/05/15) bodyに追加し、いつも上に表示                                */
/* @og.rev 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。*/
/* @og.rev 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる                */
/* @og.rev 5.2.1.0 (2010/10/01) h_ で始まる内部設定フィールドはチェックしない。             */
/* @og.rev 5.3.7.0 (2011/07/01) 入力項目が上方にある場合は、下にチェックチップを表示する。  */
/* @og.rev 5.4.4.0 (2012/02/01) rtOption対応												*/
/* Revision: $Id$                                                                           */
/********************************************************************************************/
var isShowTip = false;

$(function(){
	// 5.2.0.0 (2010/09/01) Javaスクリプトで登録したイベントを発動させる
//	$('textarea,select,input[type="text"]').focusout( function(){ check( this, '../common/realtimecheck.jsp' ); } );
	if(USE_REAL_TIME_CHECK){ //5.4.5.0 flag add
		setEvent( "textarea,select,input[type=\"text\"]", "focusout", function(){ check( this, '../common/realtimecheck.jsp' ); } );

		// 5.2.0.0 (2010/09/01) ヘッダー固定でスクロールした場合は、エラーメッセージを消す。
		$('table#viewTable').parent().parent().scroll( function () {
			if( isShowTip ) { isShowTip = false; $(".tipErr").remove(); }
		});
	}
});

function check( obj, sUrl ) {
	var sFullFN , val , arrFName , bTMCheck , sParam , ajaxSettings , tipId, rtoption ;

	sFullFN = obj.name;
//	var cls = obj.className;
//	var msg = null;

	if (typeof jQuery != "undefined" && sFullFN.indexOf( "h_" ) != 0 ) {
		val = obj.value;
		if( obj.rtOption != "null" && obj.rtOption != "undefined"){
			rtoption = obj.rtOption; // 5.4.4.0
		}
		arrFName = sFullFN.split('__');
		bTMCheck = (2 == arrFName.length);
//		var sParam = "command=RTCHECK&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" );
		sParam = "command=RENEW&checkType=" + ( bTMCheck ? "ENTRY" : "NEW" ) // 4.3.4.0 (2008/12/01)
				   + ( bTMCheck ? "&h_rowSel=" + arrFName[1] : "" )
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + val;
//				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURI( val ); // 4.3.4.0 (2008/12/01)
				   + "&column=" + arrFName[0] + "&" + sFullFN + "=" + encodeURIComponent( val ) // 5.2.0.0 (2010/09/01)
				   + (rtoption ? "&" + rtoption : ""); // 5.4.4.0 (2012/02/01)
		ajaxSettings = {   
				dataType : 'html',
				type	 : 'POST',
				url		 : sUrl,
				data	 : sParam
		};

		ajaxSettings.error = function() {};
		ajaxSettings.success = function(data) {
			//Remove old msg
//			var sOutId = getTipId(obj);
//			$("#" + sOutId).remove();
			tipId = $(obj).data( "tipId" );
			$("#" + tipId).remove();

			if( $.trim(data).indexOf("row_error") >= 0 ) {
				showCheckTip( obj, data );
				isShowTip = true;
			}
		};
		$.ajax(ajaxSettings);
	}

	return true;
}

/* Revised From jTip Plug-in of jQuery */
function showCheckTip( oEditOut, content ) {
//	var jEditOut , hEditOffset , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;
	var jEditOut , hEditOffset , iTipOffset , sArrowId , sJtDiv , jJtDiv , clickElementx , clickElementy , tipId ;

	jEditOut = $(oEditOut);
	hEditOffset = jEditOut.offset();

	// 5.3.7.0 (2011/07/01) 上に表示する場合
	if( hEditOffset.top >= 30 ) {
		sJtDiv = "<div class='tipErr'><div id='tipArrowBottom'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + (-11 - jJtDiv[0].offsetHeight);
	}
	// 5.3.7.0 (2011/07/01) 下に表示する場合
	else {
		sJtDiv = "<div class='tipErr'><div id='tipArrowTop'></div><div>" + content + "</div></div>";
		jJtDiv = $(sJtDiv).appendTo(document.body);
		//set x position
		clickElementx = hEditOffset.left;
		//set y position
		clickElementy = hEditOffset.top + 11 + jJtDiv[0].offsetHeight;
	}

	tipId = (new Date()).getTime();
	$(oEditOut).data( "tipId", tipId );

	jJtDiv.css( { left: clickElementx+"px", top: clickElementy+"px" } )
			.attr( 'id', tipId )
			.click( function() { $(this).remove(); } )
			.show();
}

//function getTipId(oEdit) {
//	return "JT" + $.data(oEdit);
//}

/********************************************************************************************/
/* 旧 bindEvents.js の内容を移植 5.2.1.0 (2010/10/01)                                       */
/*                                                                                          */
/* 各JavaScriptで登録されたイベント(主にカラムに割り当てられたイベント)を                   */
/* 実際のイベントハンドラにバインドします。                                                 */
/*                                                                                          */
/* @og.rev 5.2.0.0 (2010/09/01) 新規作成                                                    */
/* Revision: $Id$                                                                           */
/********************************************************************************************/
$(function(){
	bindEvents();
});


/********************************************************************************************/
/* カラーピッカー 5.5.4.0 (2012/07/02)                                                      */
/*                                                                                          */
/* カラーピッカーです。                                                                     */
/* input.colorPickerに対して実行させます                                                    */
/*                                                                                          */
/* @og.rev 5.5.4.0 (2012/07/02) 新規作成                                                    */
/* @og.rev 5.5.6.1 (2013/01/11) 名称変更(Og付加)                                            */
/* Revision: $Id$                                                                           */
/********************************************************************************************/
$.fn.simpleColorPickerOg = function(options) {
    var defaults = {
        colorsPerLine: 8,
        colors: ['#000000', '#444444', '#666666', '#999999', '#cccccc', '#eeeeee', '#f3f3f3', '#ffffff'
				, '#ff0000', '#ff9900', '#ffff00', '#00ff00', '#00ffff', '#0000ff', '#9900ff', '#ff00ff'
				, '#f4cccc', '#fce5cd', '#fff2cc', '#d9ead3', '#d0e0e3', '#cfe2f3', '#d9d2e9', '#ead1dc'
				, '#ea9999', '#f9cb9c', '#ffe599', '#b6d7a8', '#a2c4c9', '#9fc5e8', '#b4a7d6', '#d5a6bd'
				, '#e06666', '#f6b26b', '#ffd966', '#93c47d', '#76a5af', '#6fa8dc', '#8e7cc3', '#c27ba0'
				, '#cc0000', '#e69138', '#f1c232', '#6aa84f', '#45818e', '#3d85c6', '#674ea7', '#a64d79'
				, '#990000', '#b45f06', '#bf9000', '#38761d', '#134f5c', '#0b5394', '#351c75', '#741b47'
				, '#660000', '#783f04', '#7f6000', '#274e13', '#0c343d', '#073763', '#20124d', '#4C1130'],
        showEffect: '',
        hideEffect: '',
        onChangeColor: false
    };

    var opts = $.extend(defaults, options);

    return this.each(function() {
        var txt = $(this);

        var colorsMarkup = '';

        var prefix = txt.attr('id').replace(/-/g, '') + '_';

        for(var i = 0; i < opts.colors.length; i++){
            var item = opts.colors[i];

            var breakLine = '';
            if (i % opts.colorsPerLine == 0)
                breakLine = 'clear: both; ';

            if (i > 0 && breakLine && $.browser && $.browser.msie && $.browser.version <= 7) {
                breakLine = '';
                colorsMarkup += '<li style="float: none; clear: both; overflow: hidden; background-color: #fff; display: block; height: 1px; line-height: 1px; font-size: 1px; margin-bottom: -2px;"></li>';
            }

            colorsMarkup += '<li id="' + prefix + 'color-' + i + '" class="color-box" style="' + breakLine + 'background-color: ' + item + '" title="' + item + '"></li>';
        }

        var box = $('<div id="' + prefix + 'color-picker" class="color-picker" style="position: absolute; left: 0px; top: 0px;"><ul>' + colorsMarkup + '</ul><div style="clear: both;"></div></div>');
        $('body').append(box);
        box.hide();

        box.find('li.color-box').click(function() {
            if (!txt.is('input')) {
              txt.val(opts.colors[this.id.substr(this.id.indexOf('-') + 1)]);
              txt.blur();
            }
            if ($.isFunction(defaults.onChangeColor)) {
              defaults.onChangeColor.call(txt, opts.colors[this.id.substr(this.id.indexOf('-') + 1)]);
            }
            hideBox(box);
        });

        $('body').live('click', function() {
            hideBox(box);
        });

        box.click(function(event) {
            event.stopPropagation();
        });

        var positionAndShowBox = function(box) {
          var pos = txt.offset();
          var left = pos.left + txt.outerWidth() - box.outerWidth();
          if (left < pos.left) left = pos.left;
          box.css({ left: left, top: (pos.top + txt.outerHeight()) });
          showBox(box);
        }

        txt.click(function(event) {
          event.stopPropagation();
          if (!txt.is('input')) {
            // element is not an input so probably a link or div which requires the color box to be shown
            positionAndShowBox(box);
          }
        });

        txt.focus(function() {
          positionAndShowBox(box);
        });

        function hideBox(box) {
            if (opts.hideEffect == 'fade')
                box.fadeOut();
            else if (opts.hideEffect == 'slide')
                box.slideUp();
            else
                box.hide();
        }

        function showBox(box) {
            if (opts.showEffect == 'fade')
                box.fadeIn();
            else if (opts.showEffect == 'slide')
                box.slideDown();
            else
                box.show();
        }
    });
};

// カラーピッカーの対象はinput.colorPicker
$(function(){
	// 5.5.6.1 (2013/01/11) jQueryの上書き時エラー対策にif文挿入（上書きされると動作しない）
	if($.fn.simpleColorPickerOg){
		$('input.colorPicker').simpleColorPickerOg({ onChangeColor: function(color) { $(this).val(color).css('background',color).css('color',color); } });
	}
});

