/****************************************************************************/
/* GE12 ( システムパラメータ定義 )                                          */
/*                                                                          */
/* Created : 2013/07/24 18:56:00                                            */
/****************************************************************************/
CREATE TABLE GE12 (
   SYSTEM_ID    VARCHAR (   10 )                        NOT NULL            /*  10 システムID       */
 , PARAM_ID     VARCHAR (   50 )                        NOT NULL            /*  20 パラメータID     */
 , SEQNO        INTEGER                 DEFAULT 0       NOT NULL            /*  30 表示順           */
 , TITLE        VARCHAR (  300 )                                            /*  40 タイトル         */
 , PARAM        VARCHAR (  500 )                                            /*  50 設定値           */
 , CONTENTS     VARCHAR ( 4000 )                                            /*  60 内容             */
 , PARAM_LVL    VARCHAR (    1 )        DEFAULT '5'     NOT NULL            /*  70 設定レベル       */
 , KBSAKU       VARCHAR (    1 )        DEFAULT '1'     NOT NULL            /*  80 作成区分         */
 , FGCRYPT      VARCHAR (    1 )        DEFAULT '0'     NOT NULL            /*  90 要再起動フラグ   */
 , CONTXT_PATH  VARCHAR (   50 )        DEFAULT '**'    NOT NULL            /* 100 コンテキストパス */
 , FGREBOOT     VARCHAR (    1 )        DEFAULT '0'                         /* 110 要再起動フラグ   */
 , UNIQ         BIGINT                                  NOT NULL            /* 120 ユニークキー     */
 , FGJ          VARCHAR (    1 )        DEFAULT '1'     NOT NULL            /* 130 状態フラグ       */
 , DYSET        VARCHAR (   14 )                                            /* 140 登録日時         */
 , PGSET        VARCHAR (   10 )                                            /* 150 作成PG           */
 , PGPSET       VARCHAR (   10 )                                            /* 160 作成親PG         */
 , USRSET       VARCHAR (   10 )                                            /* 170 作成社員         */
 , DYUPD        VARCHAR (   14 )                                            /* 180 更新日時         */
 , PGUPD        VARCHAR (   10 )                                            /* 190 更新PG           */
 , PGPUPD       VARCHAR (   10 )                                            /* 200 更新親PG         */
 , USRUPD       VARCHAR (   10 )                                            /* 210 更新者           */
);

CREATE SEQUENCE GE12S00 ;

CREATE TRIGGER GE12T00 FOR GE12
  BEFORE INSERT AS 
  BEGIN 
    NEW.UNIQ = GEN_ID( GE12S00,1 );
  END; 
