/****************************************************************************/
/* GE20 ( ユーザーロール設定値テーブル )                                    */
/*                                                                          */
/* Created : 2013/07/24 18:55:50                                            */
/****************************************************************************/
CREATE TABLE GE20 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 システムID   */
 , USERID       VARCHAR2 (   10 )                   NOT NULL            /*  20 ユーザーID   */
 , ROLES        VARCHAR2 (  500 )                   NOT NULL            /*  30 ロールズ     */
 , PARAM_ID     VARCHAR2 (   50 )                   NOT NULL            /*  40 パラメータID */
 , PARAM        VARCHAR2 ( 4000 )                                       /*  50 設定値       */
 , KBSET        VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /*  60 設定区分     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  70 ユニークキー */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /*  80 状態フラグ   */
 , DYSET        VARCHAR2 (   14 )                                       /*  90 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 100 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 110 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 120 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 130 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 140 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 150 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 160 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GE20S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GE20T00 
  BEFORE INSERT ON GE20
  FOR EACH ROW 
  BEGIN 
    SELECT GE20S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
