/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GE54_TRIG ( TRIGGER )                                                    */
/* Created : 2013/07/24 18:55:50                                            */
/****************************************************************************/
CREATE OR REPLACE 
TRIGGER GE54_TRIG
/***************** GE54 帳票定義マスタ トリガー ***************/
/* システム名：                                               */
/* 作成日    ：2003/01/16                作成者：K.Hasegawa   */
/**************************************************************/
    BEFORE INSERT OR UPDATE OF FGJ ON GE54
    FOR EACH ROW WHEN ( new.FGJ = '0' )
	DECLARE
		wkSYSTEM_ID GE54.SYSTEM_ID%TYPE ;
		wkLISTID    GE54.LISTID%TYPE ;
    BEGIN
		wkSYSTEM_ID := nvl( :old.SYSTEM_ID,:new.SYSTEM_ID );
		wkLISTID    := nvl( :old.LISTID   ,:new.LISTID    );

		GE52POS_SET( wkSYSTEM_ID,wkLISTID,'H' );
		GE52POS_SET( wkSYSTEM_ID,wkLISTID,'F' );
		GE52POS_SET( wkSYSTEM_ID,wkLISTID,'B' );

		:new.HSQL := GE54SQL_SET( wkSYSTEM_ID,wkLISTID,'H' ) ;
		:new.FSQL := GE54SQL_SET( wkSYSTEM_ID,wkLISTID,'F' ) ;
		:new.BSQL := GE54SQL_SET( wkSYSTEM_ID,wkLISTID,'B' ) ;
		:new.FGJ  := '1';
    END ;
/
