/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.SystemParameter;

public class Process_DBMerge
extends AbstractProcess
implements ChainProcess {
    private static final String UPDATE_KEY = "update_";
    private static final String INSERT_KEY = "insert_";
    private static final String CNST_KEY = "const_";
    private Connection connection = null;
    private PreparedStatement insPstmt = null;
    private PreparedStatement updPstmt = null;
    private ParameterMetaData insPmeta = null;
    private ParameterMetaData updPmeta = null;
    private boolean useParamMetaData = false;
    private String dbid = null;
    private String insert = null;
    private String update = null;
    private String insertTable = null;
    private int[] insClmNos = null;
    private int[] updClmNos = null;
    private int commitCnt = 0;
    private boolean display = false;
    private String[] cnstClm = null;
    private int[] cnstClmNos = null;
    private String[] constVal = null;
    private boolean firstRow = true;
    private int count = 0;
    private int insCount = 0;
    private int updCount = 0;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty = new LinkedHashMap<String, String>();

    public Process_DBMerge() {
        super("org.opengion.fukurou.process.Process_DBMerge", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.insertTable = argument.getProparty("insertTable");
        this.update = argument.getFileProparty("update", "updateFile", false);
        this.insert = argument.getFileProparty("insert", "insertFile", false);
        this.commitCnt = argument.getProparty("commitCnt", this.commitCnt);
        this.display = argument.getProparty("display", this.display);
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.dbid);
        if (this.insert == null && this.insertTable == null) {
            String string = "insert \u307e\u305f\u306f\u3001insertFile \u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001insertTable \u3092\u5fc5\u305a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            throw new RuntimeException(string);
        }
        if (this.insert != null && this.insertTable != null) {
            String string = "insert \u307e\u305f\u306f\u3001insertFile \u3068\u3001insertTable \u306f\u3001\u4e21\u65b9\u540c\u6642\u306b\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002[" + this.insert + "],[" + this.insertTable + "]";
            throw new RuntimeException(string);
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys(UPDATE_KEY);
        SystemParameter systemParameter = new SystemParameter(this.update);
        this.update = systemParameter.replace(hybsEntryArray);
        if (this.insert != null) {
            hybsEntryArray = argument.getEntrys(INSERT_KEY);
            systemParameter = new SystemParameter(this.insert);
            this.insert = systemParameter.replace(hybsEntryArray);
        }
        HybsEntry[] hybsEntryArray2 = argument.getEntrys(CNST_KEY);
        int n = hybsEntryArray2.length;
        this.cnstClm = new String[n];
        this.constVal = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cnstClm[i] = hybsEntryArray2[i].getKey();
            this.constVal[i] = hybsEntryArray2[i].getValue();
        }
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.stmtClose(this.updPstmt);
        this.updPstmt = null;
        boolean bl3 = Closer.stmtClose(this.insPstmt);
        this.insPstmt = null;
        this.insPmeta = null;
        this.updPmeta = null;
        if (bl) {
            Closer.commit(this.connection);
        } else {
            Closer.rollback(this.connection);
        }
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2) {
            String string = "update \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + " update=[" + this.update + "] , commit=[" + bl + "]";
            throw new RuntimeException(string);
        }
        if (!bl3) {
            String string = "insert \u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + " insert=[" + this.insert + "] , commit=[" + bl + "]";
            throw new RuntimeException(string);
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.count;
        int n = 0;
        try {
            Object object;
            int n2;
            int n3;
            if (this.firstRow) {
                this.makePrepareStatement(this.insertTable, lineModel);
                n3 = this.cnstClm.length;
                this.cnstClmNos = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    this.cnstClmNos[n2] = lineModel.getColumnNo(this.cnstClm[n2]);
                }
                this.firstRow = false;
            }
            for (n3 = 0; n3 < this.cnstClmNos.length; ++n3) {
                lineModel.setValue(this.cnstClmNos[n3], this.constVal[n3]);
            }
            if (this.useParamMetaData) {
                for (n3 = 0; n3 < this.updClmNos.length; ++n3) {
                    n2 = this.updPmeta.getParameterType(n3 + 1);
                    object = lineModel.getValue(this.updClmNos[n3]);
                    if (object == null || object instanceof String && ((String)object).isEmpty()) {
                        this.updPstmt.setNull(n3 + 1, n2);
                        continue;
                    }
                    this.updPstmt.setObject(n3 + 1, object, n2);
                }
            } else {
                for (n3 = 0; n3 < this.updClmNos.length; ++n3) {
                    this.updPstmt.setObject(n3 + 1, lineModel.getValue(this.updClmNos[n3]));
                }
            }
            if ((n = this.updPstmt.executeUpdate()) == 0) {
                if (this.useParamMetaData) {
                    for (n3 = 0; n3 < this.insClmNos.length; ++n3) {
                        n2 = this.insPmeta.getParameterType(n3 + 1);
                        object = lineModel.getValue(this.insClmNos[n3]);
                        if (object == null || object instanceof String && ((String)object).isEmpty()) {
                            this.insPstmt.setNull(n3 + 1, n2);
                            continue;
                        }
                        this.insPstmt.setObject(n3 + 1, object, n2);
                    }
                } else {
                    for (n3 = 0; n3 < this.insClmNos.length; ++n3) {
                        this.insPstmt.setObject(n3 + 1, lineModel.getValue(this.insClmNos[n3]));
                    }
                }
                if ((n3 = this.insPstmt.executeUpdate()) == 0) {
                    String string = "\uff11\u4ef6\u3082\u8ffd\u52a0\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " insert=[" + this.insert + "]" + CR + " data=[" + lineModel.dataLine() + "]" + CR;
                    throw new RuntimeException(string);
                }
                ++this.insCount;
            } else {
                if (n > 1) {
                    String string = "\u8907\u6570\u884c(" + n + ")\u304c\u540c\u6642\u306b\u66f4\u65b0\u3055\u308c\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " update=[" + this.update + "]" + CR + " data=[" + lineModel.dataLine() + "]" + CR;
                    throw new RuntimeException(string);
                }
                ++this.updCount;
            }
            if (this.commitCnt > 0 && this.count % this.commitCnt == 0) {
                Closer.commit(this.connection);
            }
            if (this.display) {
                this.printKey(this.count, n, lineModel);
            }
        }
        catch (SQLException sQLException) {
            String string = "\u767b\u9332\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + (n == 1 ? " update=[" + this.update + "]" : " insert=[" + this.insert + "]" + CR + " insertTable=[" + this.insertTable + "]") + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            throw new RuntimeException(string, sQLException);
        }
        return lineModel;
    }

    private void makePrepareStatement(String string, LineModel lineModel) {
        Object object;
        if (this.insert == null) {
            int n;
            object = new StringBuilder();
            String[] stringArray = lineModel.getNames();
            int n2 = stringArray.length;
            ((StringBuilder)object).append("INSERT INTO ").append(string).append(" (");
            ((StringBuilder)object).append(stringArray[0]);
            for (n = 1; n < n2; ++n) {
                ((StringBuilder)object).append(",").append(stringArray[n]);
            }
            ((StringBuilder)object).append(" ) VALUES ( ?");
            for (n = 1; n < n2; ++n) {
                ((StringBuilder)object).append(",?");
            }
            ((StringBuilder)object).append(" )");
            this.insert = ((StringBuilder)object).toString();
            this.insClmNos = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.insClmNos[n] = n;
            }
        } else {
            object = new Formatter(lineModel);
            ((Formatter)object).setFormat(this.insert);
            this.insert = ((Formatter)object).getQueryFormatString();
            this.insClmNos = ((Formatter)object).getClmNos();
        }
        object = new Formatter(lineModel);
        ((Formatter)object).setFormat(this.update);
        this.update = ((Formatter)object).getQueryFormatString();
        this.updClmNos = ((Formatter)object).getClmNos();
        try {
            this.insPstmt = this.connection.prepareStatement(this.insert);
            this.updPstmt = this.connection.prepareStatement(this.update);
            if (this.useParamMetaData) {
                this.insPmeta = this.insPstmt.getParameterMetaData();
                this.updPmeta = this.updPstmt.getParameterMetaData();
            }
        }
        catch (SQLException sQLException) {
            String string2 = "PreparedStatement \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "errMsg=[" + sQLException.getMessage() + "]" + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "insert=[" + this.insert + "]" + CR + "update=[" + this.update + "]" + CR + "table=[" + string + "]" + CR + "nameLine=[" + lineModel.nameLine() + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            throw new RuntimeException(string2, sQLException);
        }
    }

    private void printKey(int n, int n2, LineModel lineModel) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            stringBuilder.append("UPDATE ");
        } else {
            stringBuilder.append("INSERT ");
        }
        stringBuilder.append("row=[").append(n).append("] : ");
        for (int i = 0; i < this.updClmNos.length; ++i) {
            if (i == 0) {
                stringBuilder.append("key: ");
            } else {
                stringBuilder.append(" and ");
            }
            stringBuilder.append(lineModel.getName(this.updClmNos[i]));
            stringBuilder.append(" = ");
            stringBuilder.append(lineModel.getValue(this.updClmNos[i]));
        }
        this.println(stringBuilder.toString());
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "DBID         : " + this.dbid + CR + "\t" + "Input  Count : " + this.count + CR + "\t" + "Update Count : " + this.updCount + CR + "\t" + "Insert Count : " + this.insCount;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_DBMerge \u306f\u3001UPDATE \u3068 INSERT \u3092\u6307\u5b9a\u3057 \u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3092\u8ffd\u52a0\u66f4\u65b0").append(CR);
        stringBuilder.append("\u3059\u308b\u3001ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR);
        stringBuilder.append("\u53d7\u3051\u53d6\u3063\u305f LineModel \u3092\u5143\u306b\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306e\u5b58\u5728\u30c1\u30a7\u30c3\u30af\u3092\u884c\u3044\u3001").append(CR);
        stringBuilder.append("\u4e0b\u6d41\u3078\u306e\u51e6\u7406\u3092\u632f\u308a\u5206\u3051\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR);
        stringBuilder.append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("SQL\u6587\u306b\u306f\u3001{@DATE.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBMerge().usage());
    }

    static {
        usableProparty.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        usableProparty.put("update", "\u66f4\u65b0SQL\u6587(sql or sqlFile \u5fc5\u9808)" + CR + "\u4f8b: \"UPDATE GE41 " + CR + "SET NAME_JA = [NAME_JA],LABEL_NAME = [LABEL_NAME] " + CR + "WHERE SYSTEM_ID = [SYSTEM_ID] AND CLM = [CLM]\"");
        usableProparty.put("updateFile", "\u66f4\u65b0SQL\u30d5\u30a1\u30a4\u30eb(sql or sqlFile \u5fc5\u9808)\u4f8b: update.sql");
        usableProparty.put(UPDATE_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put("insert", "\u767b\u9332SQL\u6587(sql or sqlFile \u5fc5\u9808)" + CR + "\u4f8b: \"INSERT INTO GE41 " + CR + "(SYSTEM_ID,CLM,NAME_JA,LABEL_NAME) " + CR + "VALUES ([SYSTEM_ID],[CLM],[NAME_JA],[LABEL_NAME])\"");
        usableProparty.put("insertFile", "\u767b\u9332SQL\u30d5\u30a1\u30a4\u30eb(sql or sqlFile \u5fc5\u9808)\u4f8b: insert.sql");
        usableProparty.put("insertTable", "INSERT \u3059\u308b\u5834\u5408\u306e\u30c6\u30fc\u30d6\u30ebID SQL\u6587\u3092\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u4e0d\u8981\u3002");
        usableProparty.put(INSERT_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        usableProparty.put(CNST_KEY, "LineModel \u306e\u30ad\u30fc(const_ \u306b\u7d9a\u304f\u6587\u5b57\u5217)\u306e\u5024\u306b\u3001\u56fa\u5b9a\u5024\u3092" + CR + "\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30ab\u30e9\u30e0\u540d\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -sql_SYSTEM_ID=GE");
        usableProparty.put("commitCnt", "\u6307\u5b9a\u6570\u6bce\u306b\u30b3\u30df\u30c3\u30c8\u3092\u767a\u884c\u3057\u307e\u3059\u3002" + CR + "0 \u306e\u5834\u5408\u306f\u3001\u7d42\u4e86\u307e\u3067\u30b3\u30df\u30c3\u30c8\u3057\u307e\u305b\u3093(\u521d\u671f\u5024: 0)");
        usableProparty.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

