<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6050"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<!-- データベースに対して、exist属性の、｢true:存在する｣、｢false:存在しない｣、｢one:ひとつのみ｣ -->
<!-- にしたがってチェックします。INSERT時はfalseを、UPDATE,DELETE時はtrueをセットします。 -->
<!-- names属性の並び順と、where属性の?の並び順は、対応させてください。-->
<og:tableExist
	dbid    = "{@MEM.DBID}"
	command = "{@command}"
	names   = "SYSTEM_ID,LANG,CLM"
	from    = "GF41"
	where   = "SYSTEM_ID=? AND LANG=? AND CLM=? AND FGJ IN ('0','1')"
	exist   = "{@exist}"  />


<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate" >
{@SQL}
</og:tableUpdate>

<!-- 前画面で指定のSQL文を削除します。(scope="session"なので削除が必要。) -->
<og:value scope="session" key="names" command="REMOVE" />
<og:value scope="session" key="SQL"   command="REMOVE" />

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
