/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.db.Selection;
import org.opengion.hayabusa.html.CrossMap;
import org.opengion.hayabusa.html.ViewForm;
import org.opengion.hayabusa.resource.ResourceManager;
import org.opengion.plugin.view.ViewForm_HTMLTable;

public class ViewForm_HTMLCrossTable
extends ViewForm_HTMLTable {
    private static final String VERSION = "5.5.5.0 (2012/07/28)";
    private String[] groupByData = null;
    private String[] groupByCls = null;
    private int rowClmNo = -1;
    private int colClmNo = -1;
    private int headCount = 0;
    private int sumCount = 1;
    private int breakClmNo = -1;
    private boolean[] noGroupClm = null;
    private String shokeiLabel = "\u5c0f\u8a08";
    private String gokeiLabel = "\u5408\u8a08";
    private String gokeiSortDir = null;
    private String cubeSortType = "LOAD";
    private DBTableModel table2 = null;
    private boolean firstStep = true;
    private String[] clmKeys = null;
    private String[] clsAdd = null;
    private String noDisplayKeys = null;
    private String columnDisplayKeys = null;
    private boolean firstClmGokei = false;
    private boolean useHeaderColumn = false;
    private boolean useClassAdd = false;
    private boolean useHeaderResource = false;
    private String headerCode = null;
    private static final Comparator<String> numberSort = new NumberComparator();

    public void init(DBTableModel dBTableModel) {
        this.table2 = dBTableModel;
        this.firstStep = true;
    }

    @Override
    public void clear() {
        super.clear();
        this.groupByData = null;
        this.groupByCls = null;
        this.rowClmNo = -1;
        this.colClmNo = -1;
        this.headCount = 0;
        this.sumCount = 1;
        this.breakClmNo = -1;
        this.noGroupClm = null;
        this.table2 = null;
        this.firstStep = true;
        this.clmKeys = null;
        this.clsAdd = null;
        this.shokeiLabel = "\u5c0f\u8a08";
        this.gokeiLabel = "\u5408\u8a08";
        this.cubeSortType = "LOAD";
        this.gokeiSortDir = null;
        this.noDisplayKeys = null;
        this.columnDisplayKeys = null;
        this.firstClmGokei = false;
        this.useHeaderColumn = false;
        this.useClassAdd = false;
        this.useHeaderResource = false;
        this.headerCode = null;
    }

    @Override
    public String create(int n, int n2) {
        if (this.firstStep) {
            this.paramInit(this.table2);
            super.init(this.makeCrossTable(this.table2));
            super.setNoDisplay(this.noDisplayKeys);
            super.setColumnDisplay(this.columnDisplayKeys);
            this.markerSet((ViewForm)this);
            this.firstStep = false;
        }
        if (this.getRowCount() == 0) {
            return "";
        }
        int n3 = this.getColumnCount();
        this.headerLine = null;
        int n4 = this.getLastNo(n, n2);
        int n5 = this.getBackLinkCount();
        String string = null;
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(this.getCountForm(n, n2));
        stringBuilder.append(this.getHeader());
        String string2 = "  <td class=\"row_h1\">";
        stringBuilder.append("<tbody>").append(HybsSystem.CR);
        int n6 = 0;
        for (int i = n; i < n4; ++i) {
            boolean bl;
            String string3;
            if (this.isSkip(i) || this.isSkipNoEdit(i)) continue;
            if (this.breakClmNo >= 0) {
                string3 = this.getValue(i, this.breakClmNo);
                if (string == null) {
                    string = string3;
                } else if (!string.equals(string3)) {
                    string = string3;
                    stringBuilder.append(this.getHeadLine());
                }
            }
            if ((string3 = this.getValue(i, this.rowClmNo)).length() == 0) {
                bl = true;
                stringBuilder.append("<tr class=\"").append("row_hs").append("\">");
            } else {
                bl = false;
                stringBuilder.append("<tr").append(this.getBgColorCycleClass(n6++)).append(">");
            }
            stringBuilder.append(HybsSystem.CR);
            if (this.isNumberDisplay()) {
                stringBuilder.append(this.makeCheckbox(string2, i, n5)).append(HybsSystem.CR);
            }
            for (int j = 0; j < n3; ++j) {
                if (!this.isColumnDisplay(j)) continue;
                if (j < this.headCount - 1) {
                    String string4 = this.getGroupData(j, this.getRendererValue(i, j));
                    stringBuilder.append("  <td class=\"").append(this.groupByCls[j]).append("\">");
                    stringBuilder.append(string4);
                } else if (j == this.headCount - 1) {
                    if (bl) {
                        stringBuilder.append("  <td class=\"").append("row_hs").append("\">");
                        stringBuilder.append(this.shokeiLabel);
                    } else {
                        if (this.breakClmNo > 0) {
                            stringBuilder.append("  <td class=\"").append(this.groupByCls[j - 1]).append("\">");
                        } else {
                            stringBuilder.append("  <td class=\"").append("row_h1").append("\">");
                        }
                        stringBuilder.append(this.getRendererValue(i, j));
                    }
                } else if (j >= n3 - this.sumCount && !this.firstClmGokei) {
                    stringBuilder.append("  <td class=\"").append("row_hs").append("\">");
                    stringBuilder.append(this.getRendererValue(i, j));
                } else if (j >= this.headCount && j < this.headCount + this.sumCount && this.firstClmGokei) {
                    stringBuilder.append("  <td class=\"").append("row_hs").append("\">");
                    stringBuilder.append(this.getRendererValue(i, n3 - this.sumCount + (j - this.headCount)));
                } else {
                    if (this.useClassAdd && this.clsAdd[j] != null) {
                        stringBuilder.append("  <td class=\"").append(this.clsAdd[j]).append("\">");
                    } else {
                        stringBuilder.append("  <td>");
                    }
                    if (this.firstClmGokei) {
                        stringBuilder.append(this.getRendererValue(i, j - this.sumCount));
                    } else {
                        stringBuilder.append(this.getRendererValue(i, j));
                    }
                }
                stringBuilder.append("</td>").append(HybsSystem.CR);
            }
            stringBuilder.append("</tr>").append(HybsSystem.CR);
        }
        stringBuilder.append("</tbody>").append(HybsSystem.CR);
        stringBuilder.append("</table>").append(HybsSystem.CR);
        stringBuilder.append(this.getScrollBarEndDiv());
        return stringBuilder.toString();
    }

    private void paramInit(DBTableModel dBTableModel) {
        String string = this.getParam("h_breakColumn", null);
        String string2 = this.getParam("h_noGroupColumns", null);
        String string3 = this.getParam("h_sumNumber", null);
        this.shokeiLabel = this.getParam("h_shokeiLabel", this.shokeiLabel);
        this.gokeiLabel = this.getParam("h_gokeiLabel", this.gokeiLabel);
        String string4 = this.getParam("h_cubeXColumn", null);
        String string5 = this.getParam("h_cubeYColumn", null);
        this.cubeSortType = this.getParam("h_cubeSortType", "LOAD");
        this.gokeiSortDir = this.getParam("h_gokeiSortDir", null);
        this.firstClmGokei = StringUtil.nval((String)this.getParam("h_firstClmGokei", null), (boolean)false);
        this.useHeaderColumn = StringUtil.nval((String)this.getParam("h_useHeaderColumn", null), (boolean)false);
        this.useClassAdd = StringUtil.nval((String)this.getParam("h_useClassAdd", null), (boolean)false);
        this.useHeaderResource = StringUtil.nval((String)this.getParam("h_useHeaderResource", null), (boolean)false);
        this.headerCode = this.getParam("h_headerCode", null);
        if (string3 != null) {
            this.sumCount = Integer.parseInt(string3);
        }
        this.headCount = dBTableModel.getColumnCount() - this.sumCount - 1;
        this.rowClmNo = string4 != null ? dBTableModel.getColumnNo(string4) : this.headCount - 1;
        this.colClmNo = string5 != null ? dBTableModel.getColumnNo(string5) : this.headCount;
        if (string != null) {
            this.breakClmNo = dBTableModel.getColumnNo(string);
        }
        this.groupByData = new String[this.headCount];
        this.groupByCls = new String[this.headCount];
        Arrays.fill(this.groupByCls, "row_h2");
        this.noGroupClm = new boolean[this.headCount];
        Arrays.fill(this.noGroupClm, false);
        if (string2 != null) {
            String[] stringArray = StringUtil.csv2Array((String)string2);
            for (int i = 0; i < stringArray.length; ++i) {
                this.noGroupClm[dBTableModel.getColumnNo((String)stringArray[i])] = true;
            }
        }
        if (!"true".equalsIgnoreCase(this.gokeiSortDir) && !"false".equalsIgnoreCase(this.gokeiSortDir)) {
            this.gokeiSortDir = null;
        }
    }

    private String getGroupData(int n, String string) {
        if (this.noGroupClm[n]) {
            return string;
        }
        if (string.equals(this.groupByData[n])) {
            return "";
        }
        this.groupByData[n] = string;
        this.groupByCls[n] = this.groupByCls[n].equals("row_h1") ? "row_h2" : "row_h1";
        return string;
    }

    @Override
    protected String makeCheckbox(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(string).append("</td>");
        stringBuilder.append(string).append("</td>");
        stringBuilder.append(string);
        if (n2 != 0 && (n + 1) % n2 == 0) {
            stringBuilder.append("<a href=\"#top\">").append(n + 1).append("</a>");
        } else {
            stringBuilder.append(n + 1);
        }
        stringBuilder.append("</td>");
        return stringBuilder.toString();
    }

    @Override
    protected String getHeadLine() {
        int n;
        DBColumn dBColumn;
        Object object;
        if (this.headerLine != null) {
            return this.headerLine;
        }
        String string = "";
        if (this.sumCount > 1) {
            string = " rowspan=\"2\"";
        }
        String string2 = "<th" + string;
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("<tr").append(string).append(" class=\"row_h\"").append(" >").append(HybsSystem.CR);
        if (this.isNumberDisplay()) {
            stringBuilder.append(string2).append(" colspan='3'>").append(this.getNumberHeader()).append("</th>");
        }
        stringBuilder.append(HybsSystem.CR);
        for (int i = 0; i < this.headCount; ++i) {
            if (!this.isColumnDisplay(i)) continue;
            stringBuilder.append(string2).append(">");
            stringBuilder.append(this.getColumnLabel(i));
            stringBuilder.append("</th>").append(HybsSystem.CR);
        }
        String string3 = "";
        if (this.sumCount > 1) {
            string3 = " colspan='" + this.sumCount + "'";
        }
        String string4 = null;
        if (this.isColumnDisplay(this.headCount + (this.clmKeys.length - 1) * this.sumCount)) {
            object = this.clmKeys[this.clmKeys.length - 1];
            if (object == null || ((String)object).length() == 0) {
                object = this.gokeiLabel;
            }
            string4 = "<th" + string3 + ">" + (String)object + "</th>" + HybsSystem.CR;
        }
        if (this.firstClmGokei && string4 != null) {
            stringBuilder.append(string4);
        }
        object = this.getResourceManager();
        Selection selection = null;
        if (this.headerCode != null && this.headerCode.length() > 0 && object != null && (dBColumn = object.getDBColumn(this.headerCode)) != null) {
            selection = dBColumn.getSelection();
        }
        for (n = 0; n < this.clmKeys.length - 1; ++n) {
            if (!this.isColumnDisplay(this.headCount + n)) continue;
            stringBuilder.append("<th").append(string3).append(">");
            if (this.headerCode != null && this.headerCode.length() > 0 && selection != null) {
                stringBuilder.append(selection.getValueLabel(this.clmKeys[n]));
            } else if (this.useHeaderResource && this.useHeaderColumn) {
                stringBuilder.append(this.getColumnLabel(this.headCount + n));
            } else {
                stringBuilder.append(this.clmKeys[n]);
            }
            stringBuilder.append("</th>").append(HybsSystem.CR);
        }
        if (!this.firstClmGokei && string4 != null) {
            stringBuilder.append(string4);
        }
        stringBuilder.append("</tr>").append(HybsSystem.CR);
        if (this.sumCount > 1) {
            stringBuilder.append("<tr").append(" class=\"row_h\"").append(" >").append(HybsSystem.CR);
            n = this.getColumnCount();
            for (int i = this.headCount; i < n; ++i) {
                if (!this.isColumnDisplay(i)) continue;
                stringBuilder.append("<th>");
                stringBuilder.append(this.getColumnLabel(i));
                stringBuilder.append("</th>").append(HybsSystem.CR);
            }
            stringBuilder.append("</tr>").append(HybsSystem.CR);
        }
        this.headerLine = stringBuilder.toString();
        return this.headerLine;
    }

    private DBTableModel makeCrossTable(DBTableModel dBTableModel) {
        CharSequence charSequence;
        int n;
        StringBuilder stringBuilder;
        String[] stringArray;
        int n2;
        String string;
        int n3;
        Set<String> set = this.gatSortAlgorithmSet();
        int n4 = dBTableModel.getRowCount();
        for (n3 = 0; n3 < n4; ++n3) {
            string = (String)dBTableModel.getValue(n3, this.colClmNo);
            if (string.length() <= 0) continue;
            set.add(string);
        }
        this.clmKeys = set.toArray(new String[set.size() + 1]);
        this.clmKeys[this.clmKeys.length - 1] = "";
        n3 = this.headCount + this.clmKeys.length * this.sumCount;
        string = DBTableModelUtil.newDBTable();
        string.init(n3);
        for (int i = 0; i < this.headCount; ++i) {
            string.setDBColumn(i, dBTableModel.getDBColumn(i));
        }
        DBColumn[] dBColumnArray = new DBColumn[this.sumCount];
        for (n2 = 0; n2 < this.sumCount; ++n2) {
            dBColumnArray[n2] = dBTableModel.getDBColumn(this.headCount + 1 + n2);
        }
        n2 = 0;
        ResourceManager resourceManager = this.getResourceManager();
        this.useHeaderColumn = this.useHeaderColumn && resourceManager != null;
        this.clsAdd = new String[n3];
        for (int i = this.headCount; i < n3; ++i) {
            String string2;
            Object object = dBColumnArray[n2];
            stringArray = this.clmKeys[(i - this.headCount) / this.sumCount];
            if (this.useClassAdd) {
                stringBuilder = new StringBuilder();
                if (stringArray != null && stringArray.length() > 0) {
                    char c = stringArray.charAt(0);
                    if (c >= '0' && c <= '9') {
                        stringBuilder.append("x");
                    }
                    stringBuilder.append((String)stringArray);
                }
                if ((string2 = object.getName()) != null && string2.length() > 0) {
                    stringBuilder.append(" ");
                    char c = string2.charAt(0);
                    if (c >= '0' && c <= '9') {
                        stringBuilder.append("x");
                    }
                    stringBuilder.append(string2);
                }
                this.clsAdd[i] = stringBuilder.toString();
            }
            if (this.useHeaderColumn) {
                stringBuilder = resourceManager.getDBColumn((String)stringArray);
                if (stringBuilder == null) {
                    string2 = object.getConfig();
                    if (stringArray != null && stringArray.length() > 0) {
                        string2.setName((String)stringArray);
                        string2.setLabelData(resourceManager.getLabelData((String)stringArray));
                    } else {
                        string2.setLabelData(resourceManager.getLabelData(this.gokeiLabel));
                    }
                    object = new DBColumn((DBColumnConfig)string2);
                } else {
                    object = stringBuilder;
                }
            }
            string.setDBColumn(i, object);
            if (++n2 % this.sumCount != 0) continue;
            n2 = 0;
        }
        CrossMap crossMap = new CrossMap(this.clmKeys, this.headCount, this.sumCount);
        for (n = 0; n < n4; ++n) {
            stringArray = (String[])dBTableModel.getValues(n);
            crossMap.add(stringArray);
        }
        n = crossMap.getSize();
        for (int i = 0; i < n; ++i) {
            string.addValues(crossMap.get(i), i);
        }
        string.resetModify();
        if (this.gokeiSortDir != null) {
            stringBuilder = new DBTableModelSorter();
            stringBuilder.setModel((DBTableModel)string);
            boolean bl = Boolean.valueOf(this.gokeiSortDir);
            stringBuilder.sortByColumn(n3 - 1, bl);
            charSequence = stringBuilder;
        } else {
            charSequence = string;
        }
        return charSequence;
    }

    private Set<String> gatSortAlgorithmSet() {
        AbstractSet abstractSet;
        if ("LOAD".equalsIgnoreCase(this.cubeSortType)) {
            abstractSet = new LinkedHashSet<String>();
        } else if ("NUMBER".equalsIgnoreCase(this.cubeSortType)) {
            abstractSet = new TreeSet<String>(numberSort);
        } else if ("STRING".equalsIgnoreCase(this.cubeSortType)) {
            abstractSet = new TreeSet();
        } else {
            String string = "cubeSortType \u306f\u3001NUMBER,STRING,LOAD \u4ee5\u5916\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002  cubeSortType=[" + this.cubeSortType + "]";
            throw new HybsSystemException(string);
        }
        return abstractSet;
    }

    public void setNoDisplay(String string) {
        this.noDisplayKeys = string;
    }

    public void setColumnDisplay(String string) {
        this.columnDisplayKeys = string;
    }

    public boolean isEditable() {
        return false;
    }

    private static class NumberComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 4000L;

        private NumberComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string.length() > string2.length()) {
                return 1;
            }
            if (string.length() < string2.length()) {
                return -1;
            }
            return string.compareTo(string2);
        }
    }
}

