/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.apache.xerces.impl.dv.util.Base64;
import org.odftoolkit.odfdom.type.OdfDataType;
import org.odftoolkit.odfdom.type.W3CSchemaType;

public class Base64Binary
implements OdfDataType {
    private byte[] mByteList;

    public Base64Binary(byte[] bytes) throws NumberFormatException {
        if (bytes == null) {
            throw new NumberFormatException("parameter can not be null for Base64Binary");
        }
        if (!W3CSchemaType.isValid("base64Binary", Base64.encode((byte[])bytes))) {
            throw new NumberFormatException("parameter is invalidate for datatype base64Binary");
        }
        this.mByteList = bytes;
    }

    public String toString() {
        return Base64.encode((byte[])this.mByteList);
    }

    public static Base64Binary valueOf(String stringValue) throws NumberFormatException {
        if (stringValue == null) {
            throw new NumberFormatException("parameter can not be null for Base64Binary");
        }
        return new Base64Binary(Base64.decode((String)stringValue));
    }

    public byte[] getBytes() {
        return this.mByteList;
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null) {
            return false;
        }
        return W3CSchemaType.isValid("base64Binary", stringValue);
    }
}

