/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import org.firebirdsql.gds.GDSException;

public class DbAttachInfo {
    private String server = "localhost";
    private int port = 3050;
    private String fileName;

    public DbAttachInfo(String connectInfo) throws GDSException {
        char portSepChar;
        char hostSepChar;
        if (connectInfo == null) {
            throw new GDSException("Connection string missing");
        }
        if ((connectInfo = connectInfo.trim()).startsWith("//")) {
            connectInfo = connectInfo.substring(2);
            hostSepChar = '/';
            portSepChar = ':';
        } else {
            hostSepChar = ':';
            portSepChar = '/';
        }
        int sep = connectInfo.indexOf(hostSepChar);
        if (sep == 0 || sep == connectInfo.length() - 1) {
            throw new GDSException("Bad connection string: '" + hostSepChar + "' at beginning or end of:" + connectInfo + 335544323);
        }
        if (sep > 0) {
            this.server = connectInfo.substring(0, sep);
            this.fileName = connectInfo.substring(sep + 1);
            int portSep = this.server.indexOf(portSepChar);
            if (portSep == 0 || portSep == this.server.length() - 1) {
                throw new GDSException("Bad server string: '" + portSepChar + "' at beginning or end of: " + this.server + 335544323);
            }
            if (portSep > 0) {
                this.port = Integer.parseInt(this.server.substring(portSep + 1));
                this.server = this.server.substring(0, portSep);
            }
        } else if (sep == -1) {
            this.fileName = connectInfo;
        }
    }

    public DbAttachInfo(String server, Integer port, String fileName) throws GDSException {
        if (fileName == null || fileName.equals("")) {
            throw new GDSException("null or empty filename in DbAttachInfo");
        }
        if (server != null) {
            this.server = server;
        }
        if (port != null) {
            this.port = port;
        }
        this.fileName = fileName;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public String getFileName() {
        return this.fileName;
    }
}

