/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.gds.impl.GDSServerVersionException;

public class GDSServerVersion
implements Serializable {
    private static final long serialVersionUID = -153657557318248541L;
    public static final String TYPE_PRODUCTION = "V";
    public static final String TYPE_BETA = "T";
    public static final String TYPE_DEVELOPMENT = "X";
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\w{2})-(\\w)(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)) ([^-,]+)(?:[-,](.*))?");
    private static final int FULL_VERSION_IDX = 1;
    private static final int PLATFORM_IDX = 2;
    private static final int TYPE_IDX = 3;
    private static final int MAJOR_IDX = 4;
    private static final int MINOR_IDX = 5;
    private static final int VARIANT_IDX = 6;
    private static final int BUILD_IDX = 7;
    private static final int SERVER_NAME_IDX = 8;
    private static final int EXTENDED_INFO_IDX = 9;
    private String rawStr;
    private String platform;
    private String type;
    private String fullVersion;
    private int majorVersion;
    private int minorVersion;
    private int variant;
    private int buildNumber;
    private String serverName;
    private String extendedServerName;

    private GDSServerVersion() {
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getType() {
        return this.type;
    }

    public int getVariant() {
        return this.variant;
    }

    public String getExtendedServerName() {
        return this.extendedServerName;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public int hashCode() {
        return this.rawStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GDSServerVersion)) {
            return false;
        }
        GDSServerVersion that = (GDSServerVersion)obj;
        return this.rawStr.equals(that.rawStr);
    }

    public String toString() {
        return this.rawStr;
    }

    public static GDSServerVersion parseRawVersion(String versionString) throws GDSServerVersionException {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new GDSServerVersionException("Version string does not match expected format");
        }
        GDSServerVersion version = new GDSServerVersion();
        version.rawStr = versionString;
        version.serverName = matcher.group(8);
        version.extendedServerName = matcher.group(9);
        version.platform = matcher.group(2);
        version.type = matcher.group(3);
        version.fullVersion = matcher.group(1);
        version.majorVersion = Integer.parseInt(matcher.group(4));
        version.minorVersion = Integer.parseInt(matcher.group(5));
        version.variant = Integer.parseInt(matcher.group(6));
        version.buildNumber = Integer.parseInt(matcher.group(7));
        return version;
    }
}

