/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.attribute;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.poi.hmef.CompressedRTF;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.StringUtil;

public final class MAPIRtfAttribute
extends MAPIAttribute {
    private final byte[] decompressed;
    private final String data;

    public MAPIRtfAttribute(MAPIProperty property, int type, byte[] data) throws IOException {
        super(property, type, data);
        CompressedRTF rtf = new CompressedRTF();
        byte[] tmp = rtf.decompress(new ByteArrayInputStream(data));
        if (tmp.length > rtf.getDeCompressedSize()) {
            this.decompressed = new byte[rtf.getDeCompressedSize()];
            System.arraycopy(tmp, 0, this.decompressed, 0, this.decompressed.length);
        } else {
            this.decompressed = tmp;
        }
        this.data = StringUtil.getFromCompressedUnicode((byte[])this.decompressed, (int)0, (int)this.decompressed.length);
    }

    public byte[] getRawData() {
        return super.getData();
    }

    @Override
    public byte[] getData() {
        return this.decompressed;
    }

    public String getDataString() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.getProperty().toString() + " " + this.data;
    }
}

