/****************************************************************************/
/* GF84 ( 移行DB一覧 )                                                      */
/*                                                                          */
/* Created : 2014/12/16 09:05:43                                            */
/****************************************************************************/
CREATE TABLE GF84 (
   SYSTEM_ID    VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , TBLSYU       VARCHAR2 (    1 )                   NOT NULL            /*  20 ﾃｰﾌﾞﾙ種別    */
 , TABLE_NAME   VARCHAR2 (   50 )                   NOT NULL            /*  30 ﾃｰﾌﾞﾙ名      */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  40 名称         */
 , SUIKOU       NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  50 移行件数     */
 , NOJUN        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  60 対応順       */
 , CDIKOU       VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /*  70 移行方法     */
 , F_SYSTEM_ID  VARCHAR2 (   10 )                                       /*  80 元ｼｽﾃﾑID     */
 , F_TABLE_NAME VARCHAR2 (   50 )                                       /*  90 元ﾃｰﾌﾞﾙ名    */
 , F_NAME_JA    VARCHAR2 (  200 )                                       /* 100 元名称       */
 , F_FILEPATH   VARCHAR2 (  256 )                                       /* 110 元ﾌｧｲﾙﾊﾟｽ    */
 , F_SUIKOU     NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 120 元移行件数   */
 , DESCRIPTION  VARCHAR2 ( 4000 )                                       /* 130 概要説明     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET        VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET        VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET       VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET       VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD        VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD        VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD       VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF84S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF84T00 
  BEFORE INSERT ON GF84
  FOR EACH ROW 
  BEGIN 
    SELECT GF84S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
