<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GANTT10"
	title	= "オブジェクトマスタ登録"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "PRJCODE"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<!-- データベースに対して、exist属性の、｢true:存在する｣、｢false:存在しない｣、｢one:ひとつのみ｣ -->
<!-- にしたがってチェックします。INSERT時はfalseを、UPDATE,DELETE時はtrueをセットします。 -->
<!-- names属性の並び順と、where属性の?の並び順は、対応させてください。-->
<og:dataCheck
	command = "{@command}"
	from    = "GF60"
	where   = "ID=[ID] AND IDTYPE=[IDTYPE] AND SEQ=[SEQ] AND FGJ IN ('0','1')"
/>

<!-- 前画面のSQL文を実行する場合に、UpdateTag の queryType="JDBCPrepared"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" >
	<og:tableUpdateParam
		constObjKey = "null"
		sqlType		= "{@sqlType}"
		table		= "GF60"
		whereNames	= "WHERE ID,IDTYPE,SEQ"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
