<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:value key="h_clms" value="SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME" />
<og:head headType="result">
	<script type="text/javascript" src="external_script.js"><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "TYPESA"
	title    = "SQL検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
	nullCheck = "SYSTEM_ID"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ,
				(CASE KBSAKU WHEN '0' THEN 0 WHEN '3' THEN 3 ELSE 1 END) AS ONMARK
		from GF41
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   = '{@SYSTEM_ID}'"      />
		<og:and value = "LANG        = '{@LANG}'"           />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<!-- LinkTag で、画面遷移を行う場合は、gamenId属性を使用してください。-->
	<og:link column="CLM" gamenId="TYPE1A" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,[SYSTEM_ID],[LANG],[CLM],[KBSAKU],{@IMAGE}" />
	<!-- LinkTag のuseGamenId属性 を "false" に設定すると、GAMENID,BACK_GAMENIDなどのリクエスト情報が付加されません。-->
	<og:link column="LABEL_NAME" target="_blank" useGamenId="false" onLink="[KBSAKU]" markList="3"
			  href="{@SYS.JSP}/GF9120/image/[CLM].xv3"  />
</og:viewLink>

<!-- EqualTagを使用すると、val1 と val2 の値を比較して、trueの場合のみ、BODY部を実行します。-->
<!-- nullCheck="true"で、val1 が NULL のとき trueになり、notEquals="true"で結果を反転します -->
<og:equals val1="{@IMAGE}" val2="true">
  <script type="text/javascript" src="wheelEvent.js" ><!-- --></script>
  <!-- ColumnEditorTagを使用すると、カラム属性を設定しなおすことが出来ます。-->
  <og:columnEditor column="NAME_JA" label="IMAGE_VIEW" />
  <!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
  <og:viewMarker command="{@command}">
    <!-- 子要素の ColumnMarkerTag のBODY部と表示（レンデラー）を置き換えます。 -->
    <!-- onMark="true" または ="1" のときのみ、置き換えを行います。onMark=[カラム名] が使用できます。 -->
	<og:columnMarker column="NAME_JA" onMark="[ONMARK]" markList="1">
		<img name="CLM_IMAGE" src="{@SYS.JSP}/GF9120/image/[CLM].jpg" alt="[CLM]" width="20px" height="20px"/>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[ONMARK]" markList="3" >
	   <div id="[CLM]_DIV"></div>
	   <script type="text/javascript">
		 CreateControl( "[CLM]_DIV",
						"CLSID:C0975880-11DF-11D5-8084-0040B4116A31",
						"[CLM]_OBJ", "20px", "20px", "{@SYS.JSP}/GF9120/image/[CLM].xv3",
						"-1")
	   </script>
	</og:columnMarker>
  </og:viewMarker>
</og:equals>

<og:equals val1="{@IMAGE}" val2="false">
  <og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[ONMARK]" markList="3" >
	   <div onClick="alert('AA');">[NAME_JA]</div>
	</og:columnMarker>
  </og:viewMarker>
</og:equals>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	noDisplay  = "FGJ,ONMARK"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"  />

<div style="position:absolute; left:500px;" id="DISPLAY_DIV"></div>
<og:text>
<script type="text/javascript">
 CreateControl( "DISPLAY_DIV",
				"CLSID:C0975880-11DF-11D5-8084-0040B4116A31",
				"DISPLAY_OBJ", "200px", "200px", "{@SYS.JSP}/GF9120/image/PENGUIN.xv3",
				"-1")
</script>
</og:text>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
