/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.transfer;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.transfer.TransferConfig;
import org.opengion.fukurou.transfer.TransferExec;
import org.opengion.fukurou.transfer.TransferRead;
import org.opengion.fukurou.util.ApplicationInfo;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.util.StringUtil;

public class TransferProcess {
    private static final String READ_CLASS_BASE = "org.opengion.fukurou.transfer.TransferRead_";
    private static final String EXEC_CLASS_BASE = "org.opengion.fukurou.transfer.TransferExec_";
    private final Set<TransferConfig> configSet;
    private TransferConfig config = null;
    private String dmnName = null;
    private ApplicationInfo appInfo;
    private boolean isDebug = false;

    public TransferProcess(Set<TransferConfig> set) {
        this.configSet = set;
    }

    public void setDmnName(String string) {
        this.dmnName = string;
    }

    public void setAppInfo(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    public void setDebug() {
        this.isDebug = true;
    }

    public TransferConfig getLastConfig() {
        return this.config;
    }

    public void process() {
        TransactionReal transactionReal = new TransactionReal(this.appInfo);
        TransferRead transferRead = null;
        TransferExec transferExec = null;
        try {
            Iterator<TransferConfig> iterator = this.configSet.iterator();
            while (iterator.hasNext()) {
                TransferConfig transferConfig;
                this.config = transferConfig = iterator.next();
                if (this.isDebug) {
                    System.out.println();
                    System.out.print(" START = " + new Date());
                    System.out.print("[" + this.dmnName + "]:[" + this.config.toString() + "]");
                }
                transferRead = (TransferRead)StringUtil.newInstance(READ_CLASS_BASE + this.config.getKbRead());
                transferExec = (TransferExec)StringUtil.newInstance(EXEC_CLASS_BASE + this.config.getKbExec());
                String[] stringArray = transferRead.read(this.config, transactionReal);
                transferExec.execute(stringArray, this.config, transactionReal);
                transferRead.complete(this.config, transactionReal);
                if (!this.isDebug) continue;
                System.out.println();
                System.out.print(" END   = " + new Date());
                System.out.print("[" + this.dmnName + "]:[" + this.config.toString() + "]");
            }
        }
        catch (Throwable throwable) {
            if (transactionReal != null) {
                transactionReal.rollback();
                transactionReal.close();
                transactionReal = null;
            }
            if (transferRead != null) {
                transferRead.error(this.config, this.appInfo);
            }
            throw new RuntimeException(throwable);
        }
        finally {
            if (transactionReal != null) {
                transactionReal.close();
            }
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            Object object;
            if (stringArray.length < 5) {
                LogWriter.log("Usage: java org.opengion.hayabusa.transfer.TransferProcess");
                LogWriter.log("   -kbRead=\u8aad\u53d6\u65b9\u6cd5 -readObj=\u8aad\u53d6\u5bfe\u8c61 [-readPrm=\u8aad\u53d6\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc]");
                LogWriter.log("   -kbExec=\u5b9f\u884c\u65b9\u6cd5 -execObj=\u5b9f\u884c\u5bfe\u8c61 [-execPrm=\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc]");
                LogWriter.log("   -DBConfig=DBConfig.xml [-execDbid=\u5b9f\u884c\u63a5\u7d9a\u5148DBID] [-hfrom=\u9001\u308a\u5143\u30db\u30b9\u30c8\u30b3\u30fc\u30c9]");
                return;
            }
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                if (((String)object).startsWith("-kbRead=")) {
                    string = ((String)object).substring(8);
                    continue;
                }
                if (((String)object).startsWith("-readObj=")) {
                    string2 = ((String)object).substring(9);
                    continue;
                }
                if (((String)object).startsWith("-readPrm=")) {
                    string3 = ((String)object).substring(9);
                    continue;
                }
                if (((String)object).startsWith("-kbExec=")) {
                    string4 = ((String)object).substring(8);
                    continue;
                }
                if (((String)object).startsWith("-execObj=")) {
                    string5 = ((String)object).substring(9);
                    continue;
                }
                if (((String)object).startsWith("-execPrm=")) {
                    string6 = ((String)object).substring(9);
                    continue;
                }
                if (((String)object).startsWith("-DBConfig=")) {
                    string7 = ((String)object).substring(10);
                    continue;
                }
                if (((String)object).startsWith("-execDbid=")) {
                    string8 = ((String)object).substring(10);
                    continue;
                }
                if (((String)object).startsWith("-hfrom=")) {
                    string9 = ((String)object).substring(7);
                    continue;
                }
                if (!((String)object).startsWith("-debug=") || ((String)object).substring(8) != "true") continue;
                bl = true;
            }
            if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string4 == null || string4.length() == 0 || string5 == null || string5.length() == 0 || string7 == null || string7.length() == 0) {
                LogWriter.log("\u4ee5\u4e0b\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u30fc\u306f\u5fc5\u9808\u3067\u3059\u3002");
                LogWriter.log("-kbRead=\u8aad\u53d6\u65b9\u6cd5 -readObj=\u8aad\u53d6\u5bfe\u8c61");
                LogWriter.log("-kbExec=\u5b9f\u884c\u65b9\u6cd5 -execObj=\u5b9f\u884c\u5bfe\u8c61");
                LogWriter.log("-DBConfig=DBConfig.xml");
            }
            ConnectionFactory.init(null, string7);
            TransferConfig transferConfig = new TransferConfig(string, string2, string3, string4, string8, string5, string6, null, string9, null, -1);
            object = new HashSet();
            object.add(transferConfig);
            TransferProcess transferProcess = new TransferProcess((Set<TransferConfig>)object);
            if (bl) {
                transferProcess.setDebug();
            }
            System.out.println("EXEC START Config=[" + transferConfig.toString() + "]");
            transferProcess.process();
            System.out.println("EXEC END   Config=[" + transferConfig.toString() + "]");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (bl) {
                System.out.println(throwable.toString());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

