/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBEditConfig;
import org.opengion.hayabusa.db.DBSysArg;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.db.DBUserArg;
import org.opengion.hayabusa.db.Query;
import org.opengion.hayabusa.resource.ResourceManager;

public class AbstractQuery
implements Query {
    protected static final String CR = HybsConst.CR;
    protected static final int BUFFER_MIDDLE = 200;
    private Connection connection;
    private Transaction transaction;
    private int rtnCode = 0;
    private ErrorMessage errMessage;
    private ResourceManager resource;
    private DBTableModel table;
    private String connID;
    private String stmtString;
    private int executeCount = -1;
    private int skipRowCount;
    private int maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
    private boolean updateFlag = true;
    private DBEditConfig config;
    protected static final int DB_MAX_QUERY_TIMEOUT = HybsSystem.sysInt("DB_MAX_QUERY_TIMEOUT");
    public static final String ARG_ARRAY = "ARG_ARRAY";
    public static final String SYSARG_ARRAY = "SYSARG_ARRAY";
    public static final String ERR_MSG = "ERR_MSG";
    public static final String ERR_MSG_ARRAY = "ERR_MSG_ARRAY";

    @Override
    public void init() {
        this.close();
        this.rtnCode = 0;
        this.errMessage = null;
        this.resource = null;
        this.table = null;
        this.connID = null;
        this.stmtString = null;
        this.executeCount = -1;
        this.skipRowCount = 0;
        this.maxRowCount = HybsSystem.sysInt("DB_MAX_ROW_COUNT");
        this.updateFlag = true;
        this.connection = null;
        this.config = null;
    }

    @Override
    public void setStatement(String string) {
        this.stmtString = string.trim();
    }

    @Override
    public String getStatement() {
        return this.stmtString;
    }

    @Override
    public void execute() {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute()");
    }

    @Override
    public void execute(String[] stringArray) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String[] )");
    }

    @Override
    public void execute(String[] stringArray, String[] stringArray2) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String[],String[] )");
    }

    @Override
    public void execute(String string, String string2, DBSysArg[] dBSysArgArray, DBUserArg[] dBUserArgArray) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( String,String,DBSysArg[],DBUserArg[] )");
    }

    @Override
    public void execute(int[] nArray, DBTableModel dBTableModel) {
        throw new UnsupportedOperationException("\u3053\u306e\u30af\u30e9\u30b9\u3067\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002execute( final int[] rowNo, final DBTableModel table )");
    }

    @Override
    public void commit() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.commit()) {
            this.transaction.rollback();
            this.realClose();
            String string = "\u30b3\u30df\u30c3\u30c8\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + this.getStatement() + CR;
            throw new HybsSystemException(string);
        }
    }

    @Override
    public void rollback() {
        if (this.transaction == null) {
            return;
        }
        if (!this.transaction.rollback()) {
            this.realClose();
            String string = "\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u3059\u308b\u3053\u3068\u304c\u51fa\u6765\u307e\u305b\u3093\u3002" + CR + this.getStatement() + CR;
            throw new HybsSystemException(string);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void realClose() {
    }

    protected void setExecuteCount(int n) {
        this.executeCount = n;
    }

    @Override
    public int getExecuteCount() {
        return this.executeCount;
    }

    protected void setDBTableModel(DBTableModel dBTableModel) {
        this.table = dBTableModel;
    }

    @Override
    public DBTableModel getDBTableModel() {
        return this.table;
    }

    @Override
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRowCount(int n) {
        this.maxRowCount = n > 0 ? n : Integer.MAX_VALUE;
    }

    @Override
    public int getSkipRowCount() {
        return this.skipRowCount;
    }

    @Override
    public void setSkipRowCount(int n) {
        this.skipRowCount = n;
    }

    protected void setUpdateFlag(boolean bl) {
        this.updateFlag = bl;
    }

    @Override
    public boolean isUpdate() {
        return this.updateFlag;
    }

    @Override
    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    @Override
    public int getErrorCode() {
        return this.rtnCode;
    }

    protected void setErrorCode(int n) {
        this.rtnCode = n;
    }

    @Override
    public ErrorMessage getErrorMessage() {
        return this.errMessage;
    }

    protected void setErrorMessage(ErrorMessage errorMessage) {
        this.errMessage = errorMessage;
    }

    @Override
    public void setEditConfig(DBEditConfig dBEditConfig) {
        this.config = dBEditConfig;
    }

    protected DBEditConfig getEditConfig() {
        return this.config;
    }

    protected void createTableModel(ResultSet resultSet) {
        try {
            this.table = this.config == null ? DBTableModelUtil.makeDBTable(resultSet, this.getSkipRowCount(), this.maxRowCount, this.resource) : DBTableModelUtil.makeEditDBTable(resultSet, this.getSkipRowCount(), this.maxRowCount, this.resource, this.config);
            this.setExecuteCount(this.table.getRowCount());
        }
        catch (SQLException sQLException) {
            this.realClose();
            throw new HybsSystemException("\u30c6\u30fc\u30d6\u30eb\u30e2\u30c7\u30eb\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", sQLException);
        }
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            if (this.transaction == null) {
                String string = "Transaction \u3092\u30bb\u30c3\u30c8\u3059\u308b\u524d\u306b\u3001\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3092\u53d6\u308a\u51fa\u3059\u8981\u6c42\u304c\u306a\u3055\u308c\u307e\u3057\u305f\u3002" + CR + "connID = [" + this.connID + "]";
                throw new HybsSystemException(string);
            }
            this.connection = this.transaction.getConnection(this.connID);
        }
        return this.connection;
    }

    @Override
    public void setTransaction(String string, Transaction transaction) {
        if (this.transaction != null) {
            String string2 = "\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306f\u3001\u3059\u3067\u306b\u8a2d\u5b9a\u6e08\u307f\u3067\u3059\u3002" + CR + "connID = [" + string + "]";
            throw new HybsSystemException(string2);
        }
        this.transaction = transaction;
        this.connID = string;
    }

    protected boolean useParameterMetaData() {
        return ConnectionFactory.useParameterMetaData((String)this.connID);
    }

    public String toString() {
        return "LastQuery  :[" + this.getStatement() + "] ";
    }
}

