/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.ErrorConstants;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.ExcelReaderEvent;
import org.opengion.fukurou.util.HybsConst;

public final class ExcelReader_HSSF {
    private static final String VERSION = "6.0.3.0 (2014/11/13)";

    public static void excelReader(String string, ExcelReaderEvent excelReaderEvent) {
        BufferedInputStream bufferedInputStream = null;
        DocumentInputStream documentInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)bufferedInputStream);
            documentInputStream = pOIFSFileSystem.createDocumentInputStream("Workbook");
            HSSFRequest hSSFRequest = new HSSFRequest();
            hSSFRequest.addListenerForAllRecords((HSSFListener)new ExcelListener(excelReaderEvent));
            HSSFEventFactory hSSFEventFactory = new HSSFEventFactory();
            hSSFEventFactory.processEvents(hSSFRequest, (InputStream)documentInputStream);
        }
        catch (IOException iOException) {
            try {
                String string2 = "\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u53d6\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + string + HybsConst.CR + iOException.getMessage();
                throw new RuntimeException(string2, iOException);
            }
            catch (Throwable throwable) {
                Closer.ioClose(documentInputStream);
                Closer.ioClose(bufferedInputStream);
                throw throwable;
            }
        }
        Closer.ioClose((Closeable)documentInputStream);
        Closer.ioClose(bufferedInputStream);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.util.ExcelReader_HSSF \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        String string = stringArray[0];
        ExcelReader_HSSF.excelReader(string, new ExcelReaderEvent(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class ExcelListener
    implements HSSFListener {
        private final ExcelReaderEvent event;
        private final List<String> shtNms;
        private SSTRecord sstrec;
        private int shtNo = -1;
        private String shtNm;
        private boolean isNextRecord;
        private boolean isReadSheet = true;
        private int rcdLvl;
        private int rowNo;
        private int colNo;
        private boolean isDebug;

        public ExcelListener(ExcelReaderEvent excelReaderEvent) {
            this.event = excelReaderEvent;
            this.shtNms = new ArrayList<String>();
        }

        public void processRecord(Record record) {
            Object object;
            if (record instanceof CellRecord) {
                object = (CellRecord)record;
                this.rowNo = object.getRow();
                if (this.event.isSkip(this.rowNo)) {
                    return;
                }
                this.colNo = object.getColumn();
            }
            object = null;
            block0 : switch (record.getSid()) {
                case 2057: {
                    BOFRecord bOFRecord = (BOFRecord)record;
                    if (bOFRecord.getType() == 16) {
                        if (this.shtNo < 0) {
                            this.event.sheetSize(this.shtNms.size());
                        }
                        ++this.shtNo;
                        this.shtNm = this.shtNms.get(this.shtNo);
                        this.rcdLvl = 0;
                        this.isReadSheet = this.event.startSheet(this.shtNm, this.shtNo);
                        if (!this.isDebug) break;
                        System.out.println("\u2460 BOFRecord:" + record);
                        break;
                    }
                    ++this.rcdLvl;
                    break;
                }
                case 10: {
                    if (this.rcdLvl == 0) {
                        this.event.endSheet(this.shtNo);
                        this.isReadSheet = true;
                        if (!this.isDebug) break;
                        System.out.println("\u2461 EOFRecord" + record);
                        break;
                    }
                    --this.rcdLvl;
                    break;
                }
                case 133: {
                    if (this.isDebug) {
                        System.out.println("\u2462 BoundSheetRecord");
                    }
                    BoundSheetRecord boundSheetRecord = (BoundSheetRecord)record;
                    this.shtNms.add(boundSheetRecord.getSheetname());
                    break;
                }
                case 252: {
                    if (this.isDebug) {
                        System.out.println("\u2463 SSTRecord");
                    }
                    this.sstrec = (SSTRecord)record;
                    break;
                }
                case 515: {
                    if (!this.isReadSheet) break;
                    NumberRecord numberRecord = (NumberRecord)record;
                    object = NumberToTextConverter.toText((double)numberRecord.getValue());
                    break;
                }
                case 253: {
                    if (!this.isReadSheet) break;
                    LabelSSTRecord labelSSTRecord = (LabelSSTRecord)record;
                    object = this.sstrec.getString(labelSSTRecord.getSSTIndex()).getString();
                    break;
                }
                case 517: {
                    if (!this.isReadSheet) break;
                    BoolErrRecord boolErrRecord = (BoolErrRecord)record;
                    byte by = boolErrRecord.getErrorValue();
                    object = by == 0 ? Boolean.toString(boolErrRecord.getBooleanValue()) : ErrorConstants.getText((int)by);
                    break;
                }
                case 6: {
                    if (!this.isReadSheet) break;
                    FormulaRecord formulaRecord = (FormulaRecord)record;
                    switch (formulaRecord.getCachedResultType()) {
                        case 0: {
                            double d = formulaRecord.getValue();
                            if (Double.isNaN(d)) {
                                this.isNextRecord = true;
                                break block0;
                            }
                            object = NumberToTextConverter.toText((double)d);
                            break block0;
                        }
                        case 4: {
                            object = Boolean.toString(formulaRecord.getCachedBooleanValue());
                            break block0;
                        }
                        case 5: {
                            object = ErrorConstants.getText((int)formulaRecord.getCachedErrorValue());
                            break block0;
                        }
                        case 1: {
                            this.isNextRecord = true;
                            break block0;
                        }
                    }
                    break;
                }
                case 519: {
                    if (!this.isReadSheet || !this.isNextRecord) break;
                    StringRecord stringRecord = (StringRecord)record;
                    object = stringRecord.getString();
                    this.isNextRecord = false;
                    break;
                }
            }
            if (object != null) {
                this.event.value((String)object, this.rowNo, this.colNo);
            }
        }
    }
}

