/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.opengion.fukurou.model.ArrayDataModel;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class EntryTag
extends CommonTagSupport {
    private static final String VERSION = "5.7.8.0 (2014/07/04)";
    private static final long serialVersionUID = 578020140704L;
    public static final String CMD_INSERT = "INSERT";
    public static final String CMD_COPY = "COPY";
    public static final String CMD_MODIFY = "MODIFY";
    public static final String CMD_DELETE = "DELETE";
    public static final String CMD_ENTRY = "ENTRY";
    public static final String CMD_CHANGE = "CHANGE";
    public static final String CMD_RESET = "RESET";
    public static final String CMD_ALLRESET = "ALLRESET";
    public static final String CMD_ALLACTION = "ALLACTION";
    public static final String CMD_RESETDATA = "RESETDATA";
    public static final String CMD_INSERTONE = "INSERTONE";
    public static final String CMD_REALDELETE = "REALDELETE";
    public static final String CMD_REQENTRY = "REQENTRY";
    private static final String[] COMMAND_LIST = new String[]{"INSERT", "COPY", "MODIFY", "DELETE", "ENTRY", "CHANGE", "ALLACTION", "RESET", "ALLRESET", "RESETDATA", "INSERTONE", "REALDELETE", "REQENTRY"};
    public static final String ACT_DEFAULT = "DEFAULT";
    public static final String ACT_CLEAR = "CLEAR";
    public static final String ACT_ADD = "ADD";
    public static final String ACT_LOWER = "LOWER";
    public static final String ACT_UPPER = "UPPER";
    public static final String ACT_COPY = "COPY";
    public static final String ACT_SET = "SET";
    public static final String ACT_NULLSET = "NULLSET";
    public static final String ACT_TBLSET = "TBLSET";
    public static final String ACT_WRTCTRL = "WRTCTRL";
    public static final String ACT_DBMENU = "DBMENU";
    public static final String ACT_REQSET = "REQSET";
    public static final String ACT_SEQSET = "SEQSET";
    public static final String ACT_PREFIX = "PREFIX";
    public static final String ACT_SUFIX = "SUFIX";
    private String tableId = "h_tblmdl";
    private transient DBTableModel table;
    private String command;
    private int[] rowNo;
    private List<Attributes> values;
    private int repeatCount = 1;
    private boolean useConsistency = HybsSystem.sysBool("USE_CONSISTENCY");
    private boolean selectedAll;
    private final boolean RESET_ACTION_ALL_USE = HybsSystem.sysBool("RESET_ACTION_ALL_USE");
    private boolean strictCheck = true;
    private boolean noTransition;
    private int seqsetCnt;

    @Override
    public int doStartTag() {
        int n = 2;
        if (!this.check(this.command, COMMAND_LIST)) {
            n = 0;
        }
        return n;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.noTransition = this.isNoTransitionRequest();
        this.startQueryTransaction(this.tableId);
        this.table = (DBTableModel)this.getObject(this.tableId);
        if (this.table != null && this.check(this.command, COMMAND_LIST)) {
            if (!this.checkConsistency()) {
                return 5;
            }
            if (this.rowNo == null) {
                this.rowNo = this.getParameterRows();
            }
            this.commandExec(this.command);
            if (!this.commitTableObject(this.tableId, this.table)) {
                this.jspPrint("EntryTag Query\u51e6\u7406\u304c\u5272\u308a\u8fbc\u307e\u308c\u307e\u3057\u305f\u3002DBTableModel \u306f\u767b\u9332\u3057\u307e\u305b\u3093\u3002");
                return 5;
            }
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.table = null;
        this.command = null;
        this.rowNo = null;
        this.values = null;
        this.repeatCount = 1;
        this.useConsistency = HybsSystem.sysBool("USE_CONSISTENCY");
        this.selectedAll = false;
        this.strictCheck = true;
        this.noTransition = false;
        this.seqsetCnt = 0;
    }

    protected void setAttributes(Attributes attributes) {
        if (this.values == null) {
            this.values = new ArrayList<Attributes>();
        }
        if (this.command.equalsIgnoreCase(attributes.get("command"))) {
            this.values.add(attributes);
        }
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setCommand(String string) {
        String string2 = this.getRequestParameter(string);
        if (string2 != null && string2.length() > 0) {
            this.command = string2.toUpperCase(Locale.JAPAN);
        }
    }

    private void commandExec(String string) {
        this.table.setDefaultRowWritable(false);
        this.table.setDefaultRowChecked(false);
        if (CMD_INSERT.equals(string)) {
            this.insert();
        } else if ("COPY".equals(string)) {
            this.copy();
        } else if (CMD_MODIFY.equals(string)) {
            this.modify();
        } else if (CMD_CHANGE.equals(string)) {
            this.change();
        } else if (CMD_DELETE.equals(string)) {
            this.delete();
        } else if (CMD_ENTRY.equals(string)) {
            this.entry();
        } else if (CMD_RESET.equals(string)) {
            if (this.RESET_ACTION_ALL_USE) {
                this.allReset();
            } else {
                this.reset();
            }
        } else if (CMD_ALLRESET.equals(string)) {
            this.allReset();
        } else if (CMD_ALLACTION.equals(string)) {
            this.allAction();
        } else if (CMD_RESETDATA.equals(string)) {
            this.resetData();
        } else if (CMD_INSERTONE.equals(string)) {
            this.insertOne();
        } else if (CMD_REALDELETE.equals(string)) {
            this.realDelete();
        } else if (CMD_REQENTRY.equals(string)) {
            this.reqEntry();
        }
    }

    private void insert() {
        int n;
        if (this.rowNo.length == 0) {
            this.rowNo = new int[]{-1};
        }
        boolean bl = "WRITABLE".equalsIgnoreCase(this.table.getColumnName(0));
        String[] stringArray = new String[this.table.getColumnCount()];
        for (n = 0; n < stringArray.length; ++n) {
            DBColumn dBColumn = this.table.getDBColumn(n);
            stringArray[n] = dBColumn.getDefault();
        }
        if (bl) {
            stringArray[0] = "true";
        }
        n = this.table.getRowCount();
        for (int i = this.rowNo.length - 1; i >= 0; --i) {
            int n2 = this.rowNo[i];
            for (int j = 0; j < this.repeatCount; ++j) {
                if (j >= 1) {
                    stringArray = (String[])this.table.getValues(n2);
                }
                String[] stringArray2 = new String[this.table.getColumnCount()];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
                stringArray2 = this.setColumnValues(stringArray2);
                n2 = this.noTransition ? n : ++n2;
                this.table.addValues(stringArray2, n2);
                this.table.setRowWritable(n2, true);
                this.table.setRowChecked(n2, true);
            }
        }
    }

    private void copy() {
        if (this.rowNo.length == 0) {
            this.insert();
            return;
        }
        int n = this.table.getRowCount();
        for (int i = this.rowNo.length - 1; i >= 0; --i) {
            for (int j = 0; j < this.repeatCount; ++j) {
                String[] stringArray = (String[])this.table.getValues(this.rowNo[i] + j);
                String[] stringArray2 = new String[this.table.getColumnCount()];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
                stringArray2 = this.setColumnValues(stringArray2);
                int n2 = -1;
                n2 = this.noTransition ? n : this.rowNo[i] + j + 1;
                this.table.addValues(stringArray2, n2);
                this.table.setRowWritable(n2, true);
                this.table.setRowChecked(n2, true);
            }
        }
    }

    private void modify() {
        for (int i = 0; i < this.rowNo.length; ++i) {
            String[] stringArray = (String[])this.table.getValues(this.rowNo[i]);
            String[] stringArray2 = new String[this.table.getColumnCount()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            if (!this.noTransition || this.table.getModifyType(this.rowNo[i]) == null || this.table.getModifyType(this.rowNo[i]).length() <= 0) {
                stringArray2 = this.setColumnValues(stringArray2);
            }
            this.table.setValues(stringArray2, this.rowNo[i]);
            this.table.setRowWritable(this.rowNo[i], true);
            this.table.setRowChecked(this.rowNo[i], true);
        }
    }

    private void change() {
        for (int i = 0; i < this.rowNo.length; ++i) {
            String[] stringArray = (String[])this.table.getValues(this.rowNo[i]);
            String[] stringArray2 = new String[this.table.getColumnCount()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            if (!this.noTransition || this.table.getModifyType(this.rowNo[i]) == null || this.table.getModifyType(this.rowNo[i]).length() <= 0) {
                stringArray2 = this.setColumnValues(stringArray2);
            }
            this.table.setValues(stringArray2, this.rowNo[i]);
        }
    }

    private void delete() {
        for (int i = 0; i < this.rowNo.length; ++i) {
            String[] stringArray = (String[])this.table.getValues(this.rowNo[i]);
            String[] stringArray2 = new String[this.table.getColumnCount()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            if (!this.noTransition || this.table.getModifyType(this.rowNo[i]) == null || this.table.getModifyType(this.rowNo[i]).length() <= 0) {
                stringArray2 = this.setColumnValues(stringArray2);
            }
            this.table.rowDelete(stringArray2, this.rowNo[i]);
            this.table.setRowWritable(this.rowNo[i], true);
            this.table.setRowChecked(this.rowNo[i], true);
        }
    }

    private void entry() {
        if (this.rowNo.length > 0) {
            this.setRequestValues(false);
            for (int i = 0; i < this.rowNo.length; ++i) {
                String[] stringArray = (String[])this.table.getValues(this.rowNo[i]);
                String[] stringArray2 = new String[this.table.getColumnCount()];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
                stringArray2 = this.setColumnValues(stringArray2);
                this.table.setValues(stringArray2, this.rowNo[i]);
                this.table.setRowWritable(this.rowNo[i], true);
                this.table.setRowChecked(this.rowNo[i], true);
            }
        }
    }

    private void reset() {
        for (int i = this.rowNo.length - 1; i >= 0; --i) {
            this.table.resetRow(this.rowNo[i]);
        }
    }

    private void allReset() {
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.table.resetRow(i);
        }
    }

    private void allAction() {
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.table.getValues(i);
            String[] stringArray2 = new String[this.table.getColumnCount()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            stringArray2 = this.setColumnValues(stringArray2);
            this.table.setValues(stringArray2, i);
            this.table.setRowWritable(i, true);
            this.table.setRowChecked(i, true);
        }
    }

    private void resetData() {
        for (int i = 0; i < this.rowNo.length; ++i) {
            String string = this.table.getModifyType(this.rowNo[i]);
            this.table.resetRow(this.rowNo[i]);
            if (!"C".equals(string) && !"D".equals(string)) continue;
            this.table.setRowWritable(this.rowNo[i], true);
            this.table.setRowChecked(this.rowNo[i], true);
        }
    }

    private void insertOne() {
        this.rowNo = new int[0];
        this.insert();
    }

    private void realDelete() {
        for (int i = this.rowNo.length - 1; i >= 0; --i) {
            this.table.removeValue(this.rowNo[i]);
        }
    }

    private void reqEntry() {
        this.setRequestValues(true);
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.table.getValues(i);
            String[] stringArray2 = new String[this.table.getColumnCount()];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            stringArray2 = this.setColumnValues(stringArray2);
            this.table.setValues(stringArray2, i);
            this.table.setRowWritable(i, true);
            this.table.setRowChecked(i, true);
        }
    }

    private void setRequestValues(boolean bl) {
        Enumeration<?> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string;
            int n;
            String string2 = (String)enumeration.nextElement();
            int n2 = string2.lastIndexOf("__");
            if (n2 <= 0 || (n = this.table.getColumnNo(string = string2.substring(0, n2), this.strictCheck)) < 0) continue;
            DBColumn dBColumn = this.table.getDBColumn(n);
            int n3 = Integer.parseInt(string2.substring(n2 + 2));
            String string3 = null;
            string3 = "ALL".equals(dBColumn.getDbType()) ? dBColumn.valueSet(this.getRequestValue(string2, false)) : dBColumn.valueSet(this.getRequestValue(string2));
            if ("0".equals(string3) && "CHBOX".equals(dBColumn.getEditor()) && (stringArray = this.getRequestValues(string2)) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"1".equals(stringArray[i])) continue;
                    string3 = "1";
                    break;
                }
            }
            if (bl) {
                if (string3 != null && string3.isEmpty()) {
                    string3 = null;
                }
                this.table.setValue(n3, string, string3);
                continue;
            }
            for (int i = 0; i < this.rowNo.length; ++i) {
                if (this.rowNo[i] != n3) continue;
                if (string3 != null && string3.isEmpty()) {
                    string3 = null;
                }
                this.table.setValue(n3, string, string3);
            }
        }
    }

    private String[] setColumnValues(String[] stringArray) {
        if (this.values != null) {
            int n = this.values.size();
            for (int i = 0; i < n; ++i) {
                Object object;
                Attributes attributes = this.values.get(i);
                String string = attributes.get("columnId");
                int n2 = this.table.getColumnNo(string, this.strictCheck);
                if (n2 < 0) continue;
                String string2 = attributes.get("action");
                String string3 = attributes.get("value");
                String string4 = stringArray[n2];
                String string5 = attributes.get("conditionList");
                if (string5 != null) {
                    object = attributes.get("conditionKey");
                    int n3 = this.table.getColumnNo((String)object);
                    String string6 = "|" + stringArray[n3] + "|";
                    if (string5.indexOf(string6) < 0) continue;
                }
                if ("COPY".equals(string2)) {
                    int n4 = this.table.getColumnNo(string3);
                    stringArray[n2] = stringArray[n4];
                } else if (ACT_TBLSET.equals(string2)) {
                    object = new ArrayDataModel(this.table.getNames());
                    object.setValues(stringArray, 0);
                    Formatter formatter = new Formatter((DataModel)object);
                    formatter.setFormat(string3);
                    stringArray[n2] = formatter.getFormatString(0);
                } else if (ACT_WRTCTRL.equals(string2)) {
                    if (string4 != null && string4.length() > 0 && string4.charAt(0) == '_') {
                        stringArray[n2] = string4.substring(1);
                    }
                } else if (ACT_DBMENU.equals(string2)) {
                    int n5;
                    if (string4 != null && string4.length() > 0 && (n5 = string4.indexOf(58)) >= 0) {
                        stringArray[n2] = string4.substring(0, n5);
                    }
                } else if (ACT_REQSET.equals(string2)) {
                    if (string3 != null && string3.length() > 0) {
                        int n6 = this.table.getColumnNo(string3);
                        String string7 = stringArray[n6];
                        int n7 = string7.indexOf(58);
                        if (n7 >= 0) {
                            string7 = string7.substring(0, n7);
                        }
                        stringArray[n2] = this.getRequestValue(string7);
                    }
                } else if (ACT_SEQSET.equals(string2)) {
                    int n8 = this.seqsetCnt;
                    if (string3 != null && string3.length() > 0) {
                        n8 += Integer.parseInt(string3);
                    }
                    stringArray[n2] = String.valueOf(n8);
                } else {
                    object = this.table.getDBColumn(n2);
                    stringArray[n2] = this.actionExec(string2, (DBColumn)object, string4, string3);
                }
                if (stringArray[n2] == null || !stringArray[n2].isEmpty()) continue;
                stringArray[n2] = null;
            }
        }
        ++this.seqsetCnt;
        return stringArray;
    }

    private String actionExec(String string, DBColumn dBColumn, String string2, String string3) {
        String string4 = string2;
        if (ACT_DEFAULT.equals(string)) {
            string4 = dBColumn.getDefault();
        } else if (ACT_CLEAR.equals(string)) {
            string4 = "";
        } else if (ACT_SET.equals(string)) {
            string4 = dBColumn.valueSet(string3);
        } else if (ACT_ADD.equals(string)) {
            string4 = dBColumn.valueAdd(string2, string3);
        } else if (ACT_LOWER.equals(string)) {
            string4 = string2 == null ? dBColumn.getDefault() : string2.toLowerCase(Locale.JAPAN);
        } else if (ACT_UPPER.equals(string)) {
            string4 = string2 == null ? dBColumn.getDefault() : string2.toUpperCase(Locale.JAPAN);
        } else if (ACT_NULLSET.equals(string)) {
            if (string2 == null || string2.isEmpty()) {
                string4 = dBColumn.valueSet(string3);
            }
        } else if (ACT_PREFIX.equals(string)) {
            int n;
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && (n = string2.lastIndexOf(string3)) >= 0) {
                string4 = string2.substring(0, n);
            }
        } else if (ACT_SUFIX.equals(string)) {
            int n;
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && (n = string2.lastIndexOf(string3)) >= 0) {
                string4 = string2.substring(n + 1);
            }
        } else {
            string4 = dBColumn.valueAction(string, string2, string3);
        }
        if (string4 == null) {
            string4 = dBColumn.getDefault();
        }
        return string4;
    }

    public void setRepeatCount(String string) {
        this.repeatCount = StringUtil.nval((String)this.getRequestParameter(string), (int)this.repeatCount);
    }

    public void setUseConsistency(String string) {
        this.useConsistency = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useConsistency);
    }

    private boolean checkConsistency() {
        boolean bl = true;
        String string = this.getRequestValue("h_consisKey");
        if (string != null && string.length() > 0) {
            if (this.useConsistency && !string.equals(this.table.getConsistencyKey())) {
                ErrorMessage errorMessage = new ErrorMessage("Consistency Key Check Error!");
                errorMessage.addMessage(0, 2, "ERR0033.1", new String[0]);
                errorMessage.addMessage(0, 2, "ERR0033.2", new String[0]);
                errorMessage.addMessage(0, 2, "ERR0033.3", new String[0]);
                this.jspPrint(TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource()));
                bl = false;
            }
        } else {
            System.out.println("EntryTag:Consistency Key is null");
        }
        return bl;
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setStrictCheck(String string) {
        this.strictCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.strictCheck);
    }

    public void setNoTransition(String string) {
        this.setNoTransitionRequest(StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.isNoTransitionRequest()));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("command", (Object)this.command).println("rowNo", (Object)this.rowNo).println("repeatCount", (Object)this.repeatCount).println("useConsistency", (Object)this.useConsistency).println("selectedAll", (Object)this.selectedAll).println("strictCheck", (Object)this.strictCheck).println("noTransition", (Object)this.noTransition).println("RESET_ACTION_ALL_USE", (Object)this.RESET_ACTION_ALL_USE).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

