/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opengion.fukurou.util.HybsConst;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.CalendarData;

class CalendarDBData
implements CalendarData {
    private final SortedMap<String, BitSet> ymMap = new TreeMap<String, BitSet>();

    CalendarDBData(String[][] stringArray, boolean bl) {
        if (bl) {
            this.callFlatTable(stringArray);
        } else {
            this.callVerticalTable(stringArray);
        }
    }

    private void callFlatTable(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string = stringArray[i][0];
            if (string.length() != 6) {
                object = "\u5e74\u6708(YYYYMM)\u306f\u3001YYYYMM(\u4f8b\uff1a200406) \u3068\u3044\u3046\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002 YYYYMM [" + string + "]";
                throw new HybsSystemException((String)object);
            }
            object = HybsSystem.getCalendar(string + "01");
            int n = ((Calendar)object).getActualMaximum(5);
            BitSet bitSet = new BitSet(n + 1);
            for (int j = 1; j <= n; ++j) {
                if ("0".equals(stringArray[i][j])) continue;
                bitSet.set(j);
            }
            this.ymMap.put(string, bitSet);
        }
    }

    private void callVerticalTable(String[][] stringArray) {
        String string = null;
        BitSet bitSet = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (stringArray[i][0].length() != 8) {
                string2 = "\u5e74\u6708\u65e5(YYYYMMDD)\u306f\u3001YYYYMMDD(\u4f8b\uff1a20040601) \u3068\u3044\u3046\u5f62\u5f0f\u3067\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002 YYYYMMDD [" + stringArray[i][0] + "]";
                throw new HybsSystemException(string2);
            }
            string2 = stringArray[i][0].substring(0, 6);
            if (!string2.equals(string)) {
                if (bitSet != null && string != null) {
                    this.ymMap.put(string, bitSet);
                }
                string = string2;
                Calendar calendar = HybsSystem.getCalendar(string2 + "01");
                int n = calendar.getActualMaximum(5);
                bitSet = new BitSet(n + 1);
            }
            if ("0".equals(stringArray[i][1])) continue;
            int n = Integer.parseInt(stringArray[i][0].substring(6));
            bitSet.set(n);
        }
        if (bitSet != null && string != null) {
            this.ymMap.put(string, bitSet);
        }
    }

    @Override
    public boolean isHoliday(Calendar calendar) {
        String string = this.cal2YM(calendar);
        BitSet bitSet = (BitSet)this.ymMap.get(string);
        if (bitSet != null) {
            return bitSet.get(calendar.get(5));
        }
        return true;
    }

    @Override
    public boolean isContainedToday(Calendar calendar, int n) {
        boolean bl;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 12);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        if (n == 1) {
            bl = calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
        } else {
            Calendar calendar3 = (Calendar)calendar.clone();
            calendar3.add(5, n);
            bl = calendar.before(calendar2) && calendar3.after(calendar2);
        }
        return bl;
    }

    @Override
    public int getKadoubisu(Calendar calendar, Calendar calendar2) {
        String string = this.cal2YM(calendar);
        String string2 = this.cal2YM(calendar2);
        SortedMap<String, BitSet> sortedMap = this.ymMap.subMap(string, string2 + "\u0000");
        Map.Entry[] entryArray = sortedMap.entrySet().toArray(new Map.Entry[sortedMap.size()]);
        int n = 0;
        for (int i = 0; i < entryArray.length; ++i) {
            String string3 = (String)entryArray[i].getKey();
            BitSet bitSet = string.equals(string3) ? ((BitSet)entryArray[i].getValue()).get(calendar.get(5), 31) : (string2.equals(string3) ? ((BitSet)entryArray[i].getValue()).get(1, calendar2.get(5) + 1) : (BitSet)entryArray[i].getValue());
            n += bitSet.cardinality();
        }
        long l = calendar.getTimeInMillis() - calendar2.getTimeInMillis();
        int n2 = (int)(l / 86400000L) + 1;
        return n2 - n;
    }

    @Override
    public Calendar getAfterDay(Calendar calendar, int n) {
        Calendar calendar2 = (Calendar)calendar.clone();
        int n2 = n;
        while (n2 > 0) {
            if (!this.isHoliday(calendar2)) {
                --n2;
            }
            calendar2.add(5, 1);
        }
        return calendar2;
    }

    private String cal2YM(Calendar calendar) {
        return String.valueOf(calendar.get(1) * 100 + calendar.get(2) + 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("CLASS   : ").append(this.getClass().getName()).append(HybsConst.CR);
        Map.Entry[] entryArray = this.ymMap.entrySet().toArray(new Map.Entry[this.ymMap.size()]);
        for (int i = 0; i < entryArray.length; ++i) {
            String string = (String)entryArray[i].getKey();
            stringBuilder.append(string);
            stringBuilder.append(':');
            stringBuilder.append((BitSet)entryArray[i].getValue());
            stringBuilder.append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }
}

