/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.io;


import org.jfree.chart.axis.NumberAxis;
import org.jfree.data.Range;

/**
 * HybsNumberAxis は、NumberAxis を継承した、縦軸レンジのチック幅指定クラスです。
 * 従来の NumberAxis では、0 から、NumberTickUnit で設定した サイズを刻みます。
 * 例えば、lowerBound=200 , upperBound=7000 で、tickSize=900 とすると、
 * 空白、900,1800,2700・・ と設定されます。
 * 実際に行いたいのは、200,1100,2000・・ という、最小値から始まり、刻み幅を 900 に
 * するという表示です。
 *
 * @og.rev 4.1.1.0 (2008/02/04) 新規作成
 *
 * @version  0.9.0	2008/02/04
 * @author	 Kazuhiko Hasegawa
 * @since	 JDK1.1,
 */
public class HybsNumberAxis extends NumberAxis {
	private static final long serialVersionUID = 411020080204L ;

	/**
	 * ラベルを指定した、コンストラクター
	 *
	 * 親クラスに委譲しています。
	 *
	 * @param	label 	ラベル
	 */
	public HybsNumberAxis( final String label ) {
		super(label);
//		setStandardTickUnits( NumberAxis.createIntegerTickUnits() );
	}

	/**
	 * 軸の上の最小の表示されるチックの値を計算します。
	 *
	 * @return	軸の上の最小のチックの値
	 *
	 * @see #calculateHighestVisibleTickValue()
	 */
	@Override
	protected double calculateLowestVisibleTickValue() {

	//	double unit = getTickUnit().getSize();
	//	double index = Math.ceil(getRange().getLowerBound() / unit);
	//	return index * unit;
		return getRange().getLowerBound() ;

	}

	/**
	 * 表示されるチックの数を計算します。
	 *
	 * @return	軸の上の表示されるチックの数
	 */
	@Override
	protected int calculateVisibleTickCount() {

		final double unit = getTickUnit().getSize();
		final Range range = getRange();
	//	return (int) (Math.floor(range.getUpperBound() / unit)
	//				  - Math.ceil(range.getLowerBound() / unit) + 1);

		return (int)Math.ceil( ( range.getUpperBound() - range.getLowerBound() + 1.0 ) / unit );
	}
}
