/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.tools;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class OGCompressor {
    public static void main(String[] args) {
        if (args.length == 3 && "-dir".equals(args[0])) {
            OGCompressor.copyFile(new File(args[1]), new File(args[2]));
        }
    }

    private static void copyFile(File inDir, File outDir) {
        File[] files = inDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String name = pathname.getName().toLowerCase();
                return name.endsWith(".js") || name.endsWith(".css");
            }
        });
        if (!outDir.exists() && !outDir.mkdirs()) {
            System.err.println("\n[ERROR] " + outDir + "\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File outFile = new File(outDir, files[i].getName());
            if (files[i].isDirectory()) {
                OGCompressor.copyFile(files[i], outFile);
                continue;
            }
            long srcTime = files[i].lastModified();
            if (srcTime == outFile.lastModified()) continue;
            OGCompressor.exec(files[i], outFile);
            outFile.setLastModified(srcTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exec(final File inFile, File outFile) {
        System.err.println("IN:" + inFile);
        Reader in = null;
        Writer out = null;
        try {
            String charset = "UTF-8";
            int linebreakpos = -1;
            in = new InputStreamReader((InputStream)new FileInputStream(inFile), charset);
            String fname = inFile.getName().toLowerCase();
            if (fname.endsWith(".js")) {
                try {
                    JavaScriptCompressor compressor = new JavaScriptCompressor(in, new ErrorReporter(){

                        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            if (line < 0) {
                                System.err.println("\n[WARNING] " + inFile + ": " + message);
                            } else {
                                System.err.println("\n[WARNING] " + inFile + "(" + line + ':' + lineOffset + "): " + message);
                            }
                            System.err.println("\t" + lineSource);
                        }

                        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            if (line < 0) {
                                System.err.println("\n[ERROR] " + inFile + ": " + message);
                            } else {
                                System.err.println("\n[ERROR] " + inFile + "(" + line + ':' + lineOffset + "): " + message);
                            }
                            System.err.println("\t" + lineSource);
                        }

                        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                            this.error(message, sourceName, line, lineSource, lineOffset);
                            return new EvaluatorException(message);
                        }
                    });
                    in.close();
                    in = null;
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), charset);
                    boolean verbose = false;
                    boolean munge = true;
                    boolean preserveAllSemiColons = false;
                    boolean disableOptimizations = false;
                    compressor.compress(out, linebreakpos, munge, verbose, preserveAllSemiColons, disableOptimizations);
                }
                catch (EvaluatorException e) {
                    e.printStackTrace();
                }
            } else if (fname.endsWith(".css")) {
                CssCompressor compressor = new CssCompressor(in);
                in.close();
                in = null;
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), charset);
                compressor.compress(out, linebreakpos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

