<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2021"
	title	= "テーブルカラム(マスタ利用)"
	date	= "2013/05/30"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<og:entry command = "{@command}"  />

<og:dataCheck command="{@command}" uniqCheckClms="SYSTEM_ID,CLM" />

<og:dataCheck command="{@command}" exist="false" sqlType="INSERT" execType="INSERT|COPY" lbl="GFE0006">
		select count(*) from GF03
		where SYSTEM_ID	= [SYSTEM_ID]
		and CLM			= [CLM]
</og:dataCheck>

<!-- とりあえず保留
<og:value command = "SETTBL" key = "TABLE_NAME" separator="','" action = "APPEND"/>
-->


<!-- トランザクション 登録処理 -->
<og:transaction>
	<!-- 通常登録処理 -->
	<og:tableUpdate command="{@command}" sqlType="INSERT" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			constObjKey = "GF"
			sqlType		= "INSERT"
			table		= "GF03"
			omitNames	= "TBLSYU,TABLE_NAME,TABLENAME_JA,NOT_NULL,KBCLM,SEQNO,UNIQ,PUP,DEF_CLM,DEF_NAME_JA,DEF_CLS_NAME,DEF_USE_LENGTH,DEF_DATA_DEFAULT,DEF_RENDERER,DEF_EDITOR,DEF_DBTYPE,DEF_BIKO"
		/>
	</og:tableUpdate>
</og:transaction >

<og:forward page="result.jsp" keys="command" vals="RENEW" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
