<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2180"
	title	= "テーブル"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select SYSTEM_ID , TABLE_NAME , NAME_JA , SUIKOU   , NOJUN , '←' as ARROW , CDIKOU
				, F_TABLE_NAME , F_NAME_JA , F_SUIKOU , F_FILEPATH , DESCRIPTION
				, FGJ , UNIQ
		from GF84
	<og:where>
		<og:and value = "FGJ			in   ('0','1')"				/>
		<og:and value = "SYSTEM_ID		=    '{@SYSTEM_ID}'"		/>
		<og:and value = "TABLE_NAME		like '{@TABLE_NAME}'"		/>
		<og:and value = "NAME_JA		like '{@NAME_JA}%'"			/>
		<og:and value = "CDIKOU			=    '{@CDIKOU}'"			/>
		<og:and value = "F_TABLE_NAME	like '{@F_TABLE_NAME}%'"	/>
		<og:and value = "F_NAME_JA		like '{@F_NAME_JA}%'"		/>
		<og:and value = "DESCRIPTION	like '{@DESCRIPTION}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,NOJUN,TABLE_NAME" />
</og:query>

<og:columnEditor column="ARROW" label="" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="ARROW" />
		<og:submit  action="MODIFY"  noWritable="ARROW,SYSTEM_ID,TABLE_NAME" />
		<og:submit  action="DELETE"  columnWritable="null" />

		<og:fieldset lbl="INSERT_GF84">
			<table>
			  <tr>
				<og:column  name="SYSTEM_ID" size="5" clazz="mustAny" />
				<og:column  name="TBLSYU"    defaultVal="D" addNoValue="false" />
				<og:column  name="TABLE_NAME" size="10" clazz="aimai" />
				<td><og:submit  value="insertGF84"  lbl="INSERT" command="INSERT" /></td>
				<td><og:submit  value="sabunGF84"   lbl="MINUS"  command="INSERT" /></td>
			  </tr>
			  <tr>
				<og:column  name="F_SYSTEM_ID" size="5" />
				<td colspan="5" />
				<td><og:submit  value="updateKENSU" lbl="UPDATE_KENSU" command="MODIFY" /></td>
			  </tr>
			</table>
		</og:fieldset>

		<og:fieldset lbl="{@LBL.NOJUN} StartNo">
			<og:column  name="START_NO" size="5" />
			<og:submit  command="MODIFY"  value="update" columnWritable="NOJUN" />
		</og:fieldset>

		<br />
	</og:writeCheck>

	<og:view
		viewFormType  = "HTMLTable"
		command       = "{@command}"
		noDisplay     = "SYSTEM_ID,UNIQ,FGJ"
		checked       = "{@checked}"
		startNo       = "{@startNo}"
		pageSize      = "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
