<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2190"
	title	= "移行DB対応明細"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select 	A.SYSTEM_ID
				, A.TABLE_NAME , B.NAME_JA as TABLE_LBL , B.F_TABLE_NAME , B.F_NAME_JA as F_TABLE_LBL
				, A.SEQNO , A.KBCLM , A.NAME_JA , A.CLM , A.CLS_NAME , A.USE_LENGTH , '' as DTYPE
				, A.DATA_DEFAULT , A.NOT_NULL , A.BIKO
				, A.F_NAME_JA , A.F_CLM , A.F_CLS_NAME , A.F_USE_LENGTH , '' as F_DTYPE
				, A.NOJUN , A.CONV_FUNC , A.DESCRIPTION
				, A.FGJ , A.UNIQ
		from GF85 A left outer join GF84 B
				on  A.SYSTEM_ID  = B.SYSTEM_ID
				and A.TABLE_NAME = B.TABLE_NAME
	<og:where>
		<og:and value = "A.FGJ			in  ('0','1')"				/>
		<og:and value = "A.SYSTEM_ID	=    '{@SYSTEM_ID}'"		/>
		<og:and value = "A.TABLE_NAME	like '{@TABLE_NAME}%'"		/>
		<og:and value = "A.CLM			like '{@CLM}%'"				/>
		<og:and value = "A.NAME_JA		like '{@NAME_JA}%'"			/>
		<og:and value = "A.KBCLM		&lt;= '{@KBCLM}'"			/>
		<og:and value = "A.F_CLM		like '{@F_CLM}%'"			/>
		<og:and value = "A.F_NAME_JA	like '{@F_NAME_JA}%'"		/>
		<og:and value = "A.CLS_NAME		like '{@CLS_NAME}%'"		/>
		<og:and value = "A.BIKO			like '{@BIKO}%'"			/>
		<og:and value = "A.CONV_FUNC	like '{@CONV_FUNC}%'"		/>
		<og:and value = "A.F_CLS_NAME	like '{@F_CLS_NAME}%'"		/>
		<og:and value = "B.F_TABLE_NAME	like '{@F_TABLE_NAME}%'"	/>
		<og:and value = "A.DESCRIPTION	like '{@DESCRIPTION}%'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.NOJUN,A.TABLE_NAME,A.SEQNO" />
</og:query>

<!-- CLS_NAME,USE_LENGTH,DTYPE カラムが必須。異なる場合は、keys,vals で指定します。 -->
<og:tableFilter classId="DTYPE" keys="CLS_NAME,USE_LENGTH,DTYPE" vals="CLS_NAME,USE_LENGTH,DTYPE" />
<og:tableFilter classId="DTYPE" keys="CLS_NAME,USE_LENGTH,DTYPE" vals="F_CLS_NAME,F_USE_LENGTH,F_DTYPE" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:submit  action="COPY"    noWritable="SEQNO,KBCLM,CLM,NAME_JA,DTYPE,DATA_DEFAULT,NOT_NULL,F_DTYPE" />
		<og:submit  action="MODIFY"  noWritable="SEQNO,KBCLM,CLM,NAME_JA,DTYPE,DATA_DEFAULT,NOT_NULL,F_DTYPE" />
		<og:submit  action="DELETE"  columnWritable="null" />
		　　　<og:submit value="deleteAll" lbl="DeleteAll" columnWritable="null"
					onClick="return confirm('{@LBL.DeleteAll} {@LBL.MSG0075} ({@SYSTEM_ID})');" />

		<og:fieldset lbl="INSERT_GF85">
		  <table>
			<tr>
				<og:column  name="SYSTEM_ID" defaultVal="{@SYSTEM_ID}" size="5" must="true" readonly="true" />
				<td rowspan="3">
					<og:column  name="CDIKOU" optionAttributes="multiple='multiple'" td="false" />
				</td>
				<td><og:submit  value="insertGF85" lbl="INSERT" command="INSERT" /></td>
				<td><og:submit  value="sabunGF85"  lbl="MINUS"  command="INSERT" /></td>
			</tr><tr>
				<og:column  name="TBLSYU"    defaultVal="D" addNoValue="false" />
				<td><og:submit  value="directGF85" lbl="DIRECT" command="INSERT" /></td>
			</tr><tr>
				<og:column  name="TABLE_NAME"  size="10" clazz="aimai" />
			</tr>
		  </table>
		</og:fieldset>
		　　　<og:submit value="report2" lbl="EXCEL" />
	</og:writeCheck>

	<jsp:directive.include file="view.jsp" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
